unit Batchdlg;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, DB, DBTables, ExtCtrls, DBCtrls, Dialogs, Mask;

type
  TFormBatchDef = class(TForm)
    OKBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    DBNavigator1: TDBNavigator;
    TableBatch: TTable;
    DataSourceBatch: TDataSource;
    DBEditTableName: TDBEdit;
    DBEditBackup: TDBEdit;
    DBEditAltStruct: TDBEdit;
    DBEditKeyVTable: TDBEdit;
    DBEditProbTable: TDBEdit;
    OpenDialog1: TOpenDialog;
    SpeedTable: TSpeedButton;
    SpeedBackup: TSpeedButton;
    SpeedAltStr: TSpeedButton;
    SpeedKeyV: TSpeedButton;
    SpeedProbs: TSpeedButton;
    TableBatchTableName      : TStringField;
    TableBatchBackUpName     : TStringField;
    TableBatchAltStructName  : TStringField;
    TableBatchKeyVTableName  : TStringField;
    TableBatchProbTableName  : TStringField;
    procedure SpeedTableClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormBatchDef: TFormBatchDef;

implementation

{$R *.DFM}

procedure TFormBatchDef.SpeedTableClick(Sender: TObject);
begin
  begin
    if      Sender = SpeedTable  then
    begin
      OpenDialog1.Title := 'Select Table';
      if OpenDialog1.Execute then
        DBEditTableName.field.AsString := OpenDialog1.Filename;
    end
    else if Sender = SpeedBackup then
    begin
      OpenDialog1.Title := 'Select Backup Table';
      if OpenDialog1.Execute then
        DBEditBackup   .field.AsString := OpenDialog1.Filename;
    end
    else if Sender = SpeedAltStr then
    begin
      OpenDialog1.Title := 'Select Alternate Structure Table';
      if OpenDialog1.Execute then
        DBEditAltStruct.field.AsString := OpenDialog1.Filename;
    end
    else if Sender = SpeedKeyV   then
    begin
      OpenDialog1.Title := 'Select Key Violation Table';
      if OpenDialog1.Execute then
        DBEditKeyVTable.field.AsString := OpenDialog1.Filename;
    end
    else if Sender = SpeedProbs  then
    begin
      OpenDialog1.Title := 'Select Problems Table';
      if OpenDialog1.Execute then
        DBEditProbTable.field.AsString := OpenDialog1.Filename;
    end
  end;
end;

procedure TFormBatchDef.OKBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TFormBatchDef.FormActivate(Sender: TObject);
begin
  TableBatch.Active := True;
end;

end.
