unit Btchmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Rebdlg, Verdlg, Tu, ExtCtrls, DB, DBTables,
  StatDlg, Batchdlg, Getdlg, Errtbdlg, DBIErrs;

type
  TFormBatchMain = class(TForm)
    TUtilityVerReb: TTUtility;
    Panel1: TPanel;
    ButtonFixAll: TButton;
    ListBoxStatus: TListBox;
    ButtonDefBatch: TButton;
    ButtonConfirmBatch: TButton;
    ButtonVerifyOnly: TButton;
    ButtonViewErrTable: TButton;
    ButtonSaveLog: TButton;
    Bevel1: TBevel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    ButtonClose: TButton;
    Label3: TLabel;
    Label4: TLabel;
    Label2: TLabel;
    label1: TLabel;
    Label5: TLabel;
    LabelBatchName: TLabel;
    Label6: TLabel;
    LabelNumFiles: TLabel;
    SaveDialogActivityLog: TSaveDialog;
    TUtilityVerOnly: TTUtility;
    procedure ButtonFixAllClick(Sender: TObject);
    procedure TUtilityVerRebInfoRebuild(Sender: TObject;
      RebuildCBRec: TRebuildCBData);
    procedure TUtilityVerRebInfoVerify(Sender: TObject;
      VerifyCBRec: TVerifyCBData);
    procedure TUtilityRestInfoVerReb(Sender: TObject; AMessage: String;
      Process: TUVerRebProcess; var Abort: Boolean);
    procedure ButtonDefBatchClick(Sender: TObject);
    procedure ButtonCloseClick(Sender: TObject);
    procedure ButtonConfirmBatchClick(Sender: TObject);
    procedure ButtonVerifyOnlyClick(Sender: TObject);
    procedure ButtonSaveLogClick(Sender: TObject);
    procedure ButtonViewErrTableClick(Sender: TObject);
  private
    { Private declarations }
    CurProcess : TUVerRebProcess; {keep track of the rebuild or verify to eliminate screen flash}
    TablesProcessed : Word;
    Procedure ZeroGages;
    Procedure AssignBatchRec(TU : TTUtility);
    Procedure SendToLog(aMsg : String);
    Procedure UpdateStats(TU : TTUtility);
    procedure DeleteErrorTable;
  public
    { Public declarations }
  end;

var
  FormBatchMain: TFormBatchMain;

implementation

{$R *.DFM}

Procedure TFormBatchMain.ZeroGages;
begin
  FormStatus.GaugeHeader.Progress := 0;
  FormStatus.GaugeIndex.Progress := 0;
  FormStatus.GaugeData.Progress := 0;
  FormStatus.GaugeHeaderIdx.Progress := 0;
  FormStatus.GaugeIndexIdx.Progress := 0;
  FormStatus.GaugeDataIdx.Progress := 0;
  FormStatus.GaugeIntegrity.Progress := 0;
  FormStatus.GaugeRebuild.Progress := 0;
  FormStatus.LabelNumPacked.Caption := '';
  FormStatus.LabelNumPacked.refresh;
end;

Procedure TFormBatchMain.AssignBatchRec(TU : TTUtility);
begin
  With FormBatchDef do
  begin
    TU.TableName      := TableBatchTableName.value;
    TU.tBkUpTableName := TableBatchBackUpName.value;
    TU.AltStructName  := TableBatchAltStructName.value;
    TU.tKeyVTableName := TableBatchKeyVTableName.value;
    TU.tProbTableName := TableBatchProbTableName.value;
  end;
end;

Procedure TFormBatchMain.SendToLog(aMsg : String);
begin
  With ListBoxStatus do
  begin
    Items.Add(AMsg);
    { This next bit scrolls the text so the most recent msg is visible}
    if (ItemHeight * Items.count) > Height then
      TopIndex:= Items.count - (Height div ItemHeight) ;
  end;
  ListBoxStatus.Refresh;
end;

Procedure TFormBatchMain.UpdateStats(TU : TTUtility);
Begin
  With FormStatus do
  begin
    LabelStatus.Caption := '';
    LabelNumRecs.Caption         := InttoStr(TU.TblInfo.iRecords);
    LabelRecSize.Caption         := IntToStr(TU.TblInfo.iRecSize);
    LabelNumFields.Caption       := IntToStr(TU.TblInfo.iFields);
    LabelNumAuxPasswords.Caption := IntToStr(TU.TblInfo.iPasswords);
    if TU.TblInfo.bProtected then
      LabelPasswordTF.Caption := 'True'
    else
      LabelPasswordTF.Caption := 'False';
    Inc(TablesProcessed);
    LabelTableOf.Caption := IntToStr(TablesProcessed);
    LabelOfTable.Caption := IntToStr(FormBatchDef.TableBatch.RecordCount);
    GroupBoxTableStats.Refresh;
  end;
end;

procedure TFormBatchMain.DeleteErrorTable;
Var
  ErrTblName : String;
begin
  { make sure the error table is not active }
  BtnBottomDlg.TableErrTable.Active := False;
  BtnBottomDlg.TableErrTable.DatabaseName := Session.PrivateDir;
  {Make sure the error table name has an extension }
  if extractFileExt(BtnBottomDlg.TableErrTable.TableName) = '' then
    ErrTblName := BtnBottomDlg.TableErrTable.TableName + '.DB'
  else
    ErrTblName := BtnBottomDlg.TableErrTable.TableName;
  {if the error table  does not have a path then assign the private one}
  if extractFilePath(BtnBottomDlg.TableErrTable.TableName) = '' then
    ErrTblName := Session.PrivateDir + '\' + ErrTblName;
  {Now delete the table if it exists}
  if fileexists(ErrTblName) then
    BtnBottomDlg.TableErrTable.DeleteTable;
end;

procedure TFormBatchMain.ButtonFixAllClick(Sender: TObject);
var
  P1,P2 : TPoint;
begin
  ListBoxStatus.Setfocus;
  CurProcess := TURebuilding;
  P1.X := (Width - FormStatus.Width) div 2;
  P1.Y := 100;
  P2 := ClienttoScreen(P1);
  FormStatus.Left := P2.X;
  FormStatus.Top := P2.Y;
  FormStatus.Show;
  Try
    ZeroGages;
    TablesProcessed := 0;
    FormBatchDef.TableBatch.Active := True;
    FormBatchDef.TableBatch.First;
    While not FormBatchDef.TableBatch.EOF do
    begin
      try
        AssignBatchRec(TUtilityVerReb);
        UpdateStats(TUtilityVerReb);
        TUtilityVerReb.ExecuteVerifyRebuild;
      except
        {report the error to the log  so it doesn't stop the process}
        on E:Exception do
          SendToLog(E.Message);
      end;
      try
        ZeroGages;
        FormBatchDef.TableBatch.Next;
      except
      { report the error to the log  so it doesn't stop the process}
        on E:Exception do
          SendToLog(E.Message);
      end;
    end;
  finally
    deletefile(TUtilityVerReb.tErrTableName);
    FormStatus.Hide;
    FormStatus.Refresh;
  end;
end;

procedure TFormBatchMain.TUtilityVerRebInfoRebuild(Sender: TObject;
  RebuildCBRec: TRebuildCBData);
begin
{ NOTE : This is VERRRRY important. DO NOT MAKE ANY DATABASE CALLS FROM
  THIS METHOD. This event is actually part of a BDE Callback response.
  The rules for Callback responses are clear. The BDE is not re-entrant,
  that means that you can not do anything here that would call the BDE.
  So.... No database calls. Just make pictures.}
  with RebuildCBRec do
  begin
    if sMsg = '' then
    begin
      FormStatus.GaugeRebuild.Progress := iPercentDone;
    end
    else
    begin
      FormStatus.LabelNumPacked.Caption := sMsg;
      FormStatus.LabelNumPacked.refresh;
    end;
  end;
end;

procedure TFormBatchMain.TUtilityVerRebInfoVerify(Sender: TObject;
  VerifyCBRec: TVerifyCBData);
begin
{ NOTE : This is VERRRRY important. DO NOT MAKE ANY DATABASE CALLS FROM
  THIS METHOD. This event is actually part of a BDE Callback response.
  The rules for Callback responses are clear. The BDE is not re-entrant,
  that means that you can not do anything here that would call the BDE.
  So.... No database calls. Just make pictures.}
  with VerifyCBRec do
  begin
    Case Process of
      TUVerifyTableName :
        begin
          FormStatus.LabelStatus.Caption := TableName;
          FormStatus.LabelStatus.refresh;
{          FormStatus.GroupBoxVerify.refresh; }
        end;
      TUVerifyHeader    : FormStatus.GaugeHeader.Progress := PercentDone;
      TUVerifyIndex     : FormStatus.GaugeIndex.Progress := PercentDone;
      TUVerifyData      : FormStatus.GaugeData.Progress := PercentDone;
      TUVerifySXHeader  : FormStatus.GaugeHeaderIdx.Progress := PercentDone;
      TUVerifySXIndex   : FormStatus.GaugeIndexIdx.Progress := PercentDone;
      TUVerifySXData    : FormStatus.GaugeDataIdx.Progress := PercentDone;
      TUVerifySXIntegrity :   {the index count and current index is passed by the TUVerifySXIntegrity Process}
        begin
          FormStatus.GaugeIntegrity.Progress := PercentDone;
          FormStatus.LabelZeroOf.Caption := IntToStr(CurrentIndex);
          FormStatus.LabelOfZero.Caption := IntToStr(TotalIndex);
          FormStatus.LabelZeroOf.refresh;
          FormStatus.LabelOfZero.refresh;
        end;
    end; {Case}
  end;

end;

procedure TFormBatchMain.TUtilityRestInfoVerReb(Sender: TObject;
  AMessage: String; Process: TUVerRebProcess; var Abort: Boolean);
begin
  SendToLog(AMessage);
  { use process to highlight the active panal in the status dialog }
  if process <> CurProcess then
  begin
    Case Process of
    TUVerifying  :
      begin
        FormStatus.GroupBoxVerify.Font.Color := clRed;
        FormStatus.GroupBoxRebuild.Font.Color := clBlack;
      end;
    TURebuilding :
      begin
        FormStatus.GroupBoxVerify.Font.Color := clBlack;
        FormStatus.GroupBoxRebuild.Font.Color := clRed;
      end;
    end; {case}
    FormStatus.GroupBoxVerify.refresh;
    FormStatus.GroupBoxRebuild.refresh;
    CurProcess := Process;
  end;
end;

procedure TFormBatchMain.ButtonDefBatchClick(Sender: TObject);
var
 temp : Integer;
begin
   DeleteErrorTable;
   If GetBatchDlg.Showmodal = mrOK then
     FormBatchDef.ShowModal;
   { Show the batch selected }
   If GetBatchDlg.modalResult <> mrCancel then
   begin
     LabelBatchName.Caption :=
       ExtractFileName(FormBatchDef.TableBatch.TableName);
     FormBatchDef.TableBatch.Active := True;
     LabelNumFiles.Caption := IntToStr(FormBatchDef.TableBatch.RecordCount) +
       ' Tables';
     FormBatchDef.TableBatch.Active := False;
   end;
end;

procedure TFormBatchMain.ButtonCloseClick(Sender: TObject);
begin
  DeleteErrorTable;
  Close;
end;

procedure TFormBatchMain.ButtonConfirmBatchClick(Sender: TObject);
begin
  FormBatchDef.TableBatch.Active := True;
  FormBatchDef.TableBatch.First;
  SendToLog('START CHECKING BATCH FOR ERRORS');
  While not FormBatchDef.TableBatch.EOF do
  begin
    With FormBatchDef do
    begin
      if not fileexists(TableBatchTableName.value) then
        SendToLog('Table not found            : '+ TableBatchTableName.value);
      if fileexists(TableBatchBackUpName.value) then
        SendToLog('Backup table already Exists: '+ TableBatchBackUpName.value);
      if not fileexists(TableBatchAltStructName.value) then
        SendToLog('Alternate table not found  : '+ TableBatchAltStructName.value);
      TableBatch.Next;
    end;
  end;
  SendToLog('DONE CHECKING BATCH FOR ERRORS');
end;

procedure TFormBatchMain.ButtonVerifyOnlyClick(Sender: TObject);
{ There is nothing really special about the ExecuteVerifyRebuild
  method. It just compines the ExecuteVerify and ExecuteRebuild
  into one convient call. The following shows how to just verify all
  the files in the batch}
var
  P1,P2 : TPoint;
begin
  ListBoxStatus.Setfocus;
  CurProcess := TURebuilding;
  P1.X := (Width - FormStatus.Width) div 2;
  P1.Y := 100;
  P2 := ClienttoScreen(P1);
  FormStatus.Left := P2.X;
  FormStatus.Top := P2.Y;
  FormStatus.GroupBoxVerify.Font.Color := clRed;
  TablesProcessed := 0;
  FormStatus.Show;
  FormStatus.Refresh;
  Try
    ZeroGages;
    FormBatchDef.TableBatch.Active := True;
    FormBatchDef.TableBatch.First;
    SendToLog('STARTING VERIFY ONLY PROCESSING OF THE BATCH');
    TUtilityVerOnly.Options := [];
    While not FormBatchDef.TableBatch.EOF do
    begin
      try
        SendToLog('Verifying Table           :' +
           FormBatchDef.TableBatchTableName.value);
        AssignBatchRec(TUtilityVerOnly);
        UpdateStats(TUtilityVerOnly);
        TUtilityVerOnly.ExecuteVerify;
        SendToLog('Verifying Status          : ' +
           IntToStr(TUtilityVerOnly.iErrorLevel));
      except
        {report the error to the log  so it doesn't stop the process}
        on E:Exception do
          SendToLog(E.Message);
      end;
      try
        ZeroGages;
        {now append all errors to the verify only error toble for reporting}
        if fileexists(TUtilityVerOnly.tErrTableName) then
          TUtilityVerOnly.Options := [vTU_Append_Errors];
        FormBatchDef.TableBatch.Next;
      except
        {report the error to the log  so it doesn't stop the process}
        on E:Exception do
          SendToLog(E.Message);
      end;
    end;
  finally
    SendToLog('VERIFY ONLY PROCESSING - COMPLETE');
    FormStatus.Hide;
    FormStatus.GroupBoxRebuild.Font.Color := clBlack;
    FormStatus.Refresh;
  end;
end;

procedure TFormBatchMain.ButtonSaveLogClick(Sender: TObject);
begin
   if SaveDialogActivityLog.Execute then
   begin
     ListBoxStatus.Items.SaveToFile(SaveDialogActivityLog.FileName);
     if MessageDlg('Do you want to clear the message log?', mtConfirmation,
        [mbYes, mbNo], 0) = mrYes then
        ListBoxStatus.Items.Clear;
   end;
end;

procedure TFormBatchMain.ButtonViewErrTableClick(Sender: TObject);
begin
  BtnBottomDlg.TableErrTable.DatabaseName := Session.PrivateDir;
  BtnBottomDlg.TableErrTable.Active := True;
  BtnBottomDlg.ShowModal;
  { Deactivate Error Table }
  BtnBottomDlg.TableErrTable.Active := False;
end;

end.

Note - This demo expects an alias named Batch with the Batch.DB file in
it.

The designer must remember to set the append option for the error table
when doing batch processing.

Make it clear in documentation that all the files that must be checked
must be actvie=false while running under delphi otherwise verify/rebuild
reports that the table is busy.

Doc Notes - Verify and Rebuild require that Session.PrivDir be read write.
