unit General;

interface

uses SysUtils, Printers, WinTypes;

type
   TVersion = record
      case typ : Boolean of
         True  : (Version : Longint);
         False : (Minor, Major : Word);
   end;

   TPrinterInfo = record
      Name,
      Driver,
      Port     : string;
      Mode     : THandle;
   end;

function GetTCrpeVersion(const Value : LongInt) : string;
function GetPrinterInfo : TPrinterInfo;

implementation

function GetTCrpeVersion(const Value : LongInt) : string;
var
   V : TVersion;
   nMajorHi, nMajorLo,
   nMinorHi, nMinorLo  : Word;
begin
   V.Version := Value;
   nMajorHi := Hi(V.Major);
   nMajorLo := Lo(V.Major);
   nMinorHi := Hi(V.Minor);
   nMinorLo := Lo(V.Minor);
   Result := Format('%d.%d.%d', [nMajorLo, nMinorHi, nMinorLo]);
end; { GetVersionStr }

{ GetPrinterInfo }
function GetPrinterInfo : TPrinterInfo;
var
   lpPrinter, lpDriver, lpPort : PChar;

begin
   lpPrinter := StrAlloc(255);
   try
      lpDriver := StrAlloc(255);
      try
         lpPort := StrAlloc(255);
         try
            Printer.GetPrinter(lpPrinter, lpDriver, lpPort, Result.Mode);
            Result.Name := StrPas(lpPrinter);
            Result.Driver := StrPas(lpDriver);
            Result.Port := StrPas(lpPort);
         finally
            StrDispose(lpPort);
         end; { Protected Block }
      finally
         StrDispose(lpDriver);
      end; { Protected Block }
   finally
      StrDispose(lpPrinter);
   end; { Protected Block }
end;

end.
