(*
MAIN.PAS Main Form
TCrpe Demo Application
Copywright 1995, John B. Murphy

Note: UCrpe is included here, however there are no TCrpe Fields on the Main Form.
      Since this Demo shows how to create and set multiple TCrpe instances, for
      MDI purposes. This is because each TCrpe instance can track it's own print
      window.  If you don't care about controlling multiple PrintWindows then
      one TCrpe instance included on the form will work, since each time TCrpe
      recieves an ReportName message it resets itself.

Conventions: {} are used to denote user coded members as oppossed to the members and
                event handlers that Delphi is keeping track of.
             sb Speed Button
             mm Menu
             pw Print Window


Known Problems: This demo will GPF on AppIdle with Dashboard 3.0, Does not exibit this
                behavior when run under progman in WFWG3.11, or Windows 95 Desktop, or
                progman in NT 3.51.

*)

unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, UCrpe, Menus, RptDlg, ExtCtrls, Buttons;

const
   NumberOfReports  = 3;

type
  TfrmMain = class(TForm)
    MainMenu1: TMainMenu;
    mmFile: TMenuItem;
    mmAbout: TMenuItem;
    mmFileReport: TMenuItem;
    mmFilePrint: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    pnlTools: TPanel;
    sbFirstPage: TSpeedButton;
    sbPrevPage: TSpeedButton;
    sbNextPage: TSpeedButton;
    sbLastPage: TSpeedButton;
    sbZoomPage: TSpeedButton;
    sbReport: TSpeedButton;
    sbCloseReport: TSpeedButton;
    mmWindow: TMenuItem;
    mmWindowTile: TMenuItem;
    mmWindowCascade: TMenuItem;
    mmWindowArrangeIcons: TMenuItem;
    sbPrint: TSpeedButton;
    sbClose: TSpeedButton;
    procedure mmFileReportClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure mmAboutClick(Sender: TObject);
    procedure sbZoomPageClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure sbCloseReportClick(Sender: TObject);
    procedure sbFirstPageClick(Sender: TObject);
    procedure mmWindowCascadeClick(Sender: TObject);
    procedure mmFilePrintClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    FReportWindowOpen : Boolean;
    procedure EnableControls(const Value : Boolean);
    procedure SetChildPosition(Value : TCrpe);
    function NewReportWindow(Value : TCrpe) : Pointer;
    function ActiveReport(var i : Integer) : TCrpe;
    procedure UpdateControls;
    procedure ClearReport;
  protected
    procedure OnApplicationIdle(Sender : TObject; var Done : Boolean);
    procedure OnCrpeExecute(Sender : TObject);
  end;

  TObjRatios = record                                         { pw sizing strucure }
     Top,
     Left,
     Height,
     Width   : Real;
  end;

var
  frmMain           : TfrmMain;

implementation

{$R *.DFM}

uses
   General;

const
   RightJustifyMenu = #8;

type
   MyReport = (ReportName, ReportFileName);
   MyReports = array[0..NumberOfReports-1 , MyReport] of string;

const
   MyReportStr : MyReports = (('Cassetts', 'cs1.rpt'),
                              ('Videos',   'vd1.rpt'),
                              ('Company',  'comp1.rpt'));

var
   ReportWindows     : TList;                                 { pw list of TCrpe }
   ChildWindowOffSet : Integer;                               { static accumulator }
   ObjRatios         : TObjRatios;                            { pw sizing ratios }

{ ReportsOpen }
function ReportsOpen : Integer;
var
   nIndex : Integer;
begin
   for nIndex := 0 to ReportWindows.Count - 1 do
      if TCrpe(ReportWindows.Items[nIndex]) <> nil then inc(Result);
end; { ReportsOpen }

{ Class TfrmMain Definition }

procedure TfrmMain.mmFileReportClick(Sender: TObject);
var
   nSelection,
   nIndex      : Integer;
   Report      : TCrpe;
   PrinterInfo : TPrinterInfo;
   PrintDate   : TDateTime;
   Year, Month, Day    : Word;
begin
  { Add the Report Names to the Report Combobox }
   PrintDate := Date;
   MultPageDlg.cbReports.Clear;                               { set up dialog box }
   for nIndex := 0 to NumberOfReports - 1 do
      MultPageDlg.cbReports.Items.Add(MyReportStr[nIndex, ReportName]);
   MultPageDlg.MaskEdit1.Text := DateToStr(PrintDate);
   MultPageDlg.Left := ((Width - MultPageDlg.Width) div 2) + Left;
   MultPageDlg.Top := ((Height - MultPageDlg.Height) div 2) + Top;
   MultPageDlg.ShowModal;
   if MultPageDlg.Tag = 1 then                                { report requested }
   begin
      Report := TCrpe.Create(Self);
      if MultPageDlg.cbReports.ItemIndex in [0..NumberOfReports - 1] then
         Report.ReportName := MyReportStr[MultPageDlg.cbReports.ItemIndex, ReportFileName]
      else
         Report.ReportName := MyReportStr[0, ReportFileName];
      Report.MDIChild := MultPageDlg.cbMDIChild.Checked;
      Report.WindowTitle := MultPageDlg.txtWindowTitle.Text;
      Report.WindowControls := MultPageDlg.cbWinControls.Checked;
      PrinterInfo := GetPrinterInfo;
      Report.PrinterName := PrinterInfo.Name;
      Report.PrinterDriver := PrinterInfo.Driver;
      Report.PrinterPort := PrinterInfo.Port;
      Report.PrinterMode := PrinterInfo.Mode;
      try
         PrintDate := StrToDate(MultPageDlg.MaskEdit1.Text);
      except on
         EConvertError do PrintDate := Date;
      end; { exception block }
      DecodeDate(PrintDate, Year, Month, Day);
      Report.PrintYear := Year;
      Report.PrintMonth := Month;
      Report.PrintDay := Day;
      Report.WindowTop := Round(Height * ObjRatios.Top);      { Size the TCrpe Window }
      Report.WindowLeft := Round(Width * ObjRatios.Left);
      Report.WindowHeight := Round(Height * ObjRatios.Height);
      Report.WindowWidth := Round(Width * ObjRatios.Width);
      Report.UserPrinterSetup.Enabled := MultPageDlg.cbUsePrintDlg.Checked;
      if MultPageDlg.txtReportTitle.Text <> EmptyStr then
         Report.Formulas[0] := 'Report_Title="' + MultPageDlg.txtReportTitle.Text + '"';
      if Report.MDIChild then SetChildPosition(Report);
      FReportWindowOpen := (Report.Destination = toWindow) and Report.Execute;
      if FReportWindowOpen then
      begin
         if Report.MDIChild then EnableControls(True);
         if NewReportWindow(Report) = nil then
         begin
            MessageBeep(0);
            ShowMessage('Out of memory, please exit');
            Report.CloseWindow;
            Report.Free;
         end; { if }
      end; { if }
   end; { if }
end;

procedure TfrmMain.Exit1Click(Sender: TObject);
begin
   Close;
end;

procedure TfrmMain.mmAboutClick(Sender: TObject);
var
   AboutBox : TCrpeAboutBox;
begin
   AboutBox := TCrpeAboutBox.Create(Self);
   AboutBox.Caption := 'TCrpe Demo About';
   AboutBox.Version.Caption := 'Version ' + GetTCrpeVersion(TCRPE_VERSION);
   AboutBox.CopyRight.Caption := TCRPE_COPYRIGHT;
   AboutBox.Information.Caption := TCRPE_INFORMATION;
   AboutBox.Comments.Caption := TCRPE_COMMENTS;
   AboutBox.ShowModal;
   AboutBox.Free;
end;

procedure TfrmMain.sbZoomPageClick(Sender: TObject);
const
   Lowest : TPreviewWindowZoom = pwFullSize;
var
   ZoomLevel : TPreviewWindowZoom;
   nIndex : Integer;
   Report : TCrpe;
begin
    Report := ActiveReport(nIndex);
    if (Report <> nil) then
    begin
       { Gets the instance zoom state }
       ZoomLevel := Report.ZoomPreviewWindow;
       { now increment the level }
       case ZoomLevel of
          pwFullSize..pwFitOneSize : Inc(ZoomLevel);
          pwFitBothSides           : ZoomLevel := Lowest;
       end; { case }
       { set the instance zomm state }
       Report.ZoomPreviewWindow := ZoomLevel;
    end; { if }
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
var
  nIndex : Integer;
begin
   for nIndex := 0 to ReportWindows.Count - 1 do
      if ReportWindows.Items[nIndex] <> nil then
         TCrpe(ReportWindows.Items[nIndex]).Free;
   ReportWindows.Free;
end;

procedure TfrmMain.sbCloseReportClick(Sender: TObject);
begin
   ClearReport;
   if ReportsOpen = 0 then EnableControls(False);
end;

procedure TfrmMain.sbFirstPageClick(Sender: TObject);
var
   Report  : TCrpe;
   nIndex  : Integer;
begin
   Report := ActiveReport(nIndex);
   if (Report <> nil) then
      if Sender = sbFirstPage then
         Report.ShowFirstPage
      else if Sender = sbNextPage then
         Report.ShowNextPage
      else if Sender = sbPrevPage then
         Report.ShowPreviousPage
      else if Sender = sbLastPage then
         Report.ShowLastPage
end;

procedure TfrmMain.mmWindowCascadeClick(Sender: TObject);
begin
   if Sender = mmWindowTile then Tile
   else if Sender = mmWindowCascade then Cascade
   else if Sender = mmWindowArrangeIcons then ArrangeIcons
end;

procedure TfrmMain.mmFilePrintClick(Sender: TObject);
var
   Report  : TCrpe;
   nIndex  : Integer;
begin
   Report := ActiveReport(nIndex);
   if (Report <> nil) then
      Report.PrintWindow(True);
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
   mmAbout.Caption := RightJustifyMenu + frmMain.mmAbout.Caption + ' ';
   Application.OnIdle := OnApplicationIdle;                   { method pointer }
   ObjRatios.Height := TCRPE_WINPOS_HEIGHT / Height;          { pw sizeing ratios }
   ObjRatios.Width := TCRPE_WINPOS_WIDTH / Width;             { constants are the }
   ObjRatios.Left := TCRPE_WINPOS_LEFT / Width;               { TCrpe defaults }
   ObjRatios.Top := TCRPE_WINPOS_TOP / Height;
   Top := 0;                                                  { size to fit }
   Left := 0;
   Width := Screen.Width;
   Height := Screen.Height;

end;

{ Member SetChildPosition }
procedure TfrmMain.SetChildPosition(Value : TCrpe);
const
   OffSetWindowBy = 22;
begin
   Value.WindowTop := ChildWindowOffSet;
   Value.WindowLeft := ChildWindowOffSet;
   ChildWindowOffSet := ChildWindowOffSet + OffSetWindowBy;
end; { SetChildPosition }

{ Member NewReportWindow }
function TfrmMain.NewReportWindow(Value : TCrpe) : Pointer;
var
  nIndex : Integer;
begin
  Result := nil;
  nIndex := 0;
  for nIndex := 0 to (ReportWindows.Count - 1) do
     if ReportWindows.Items[nIndex] = nil then
     begin
        ReportWindows.Items[nIndex] := Value;                 { re-use deleted }
        Result := ReportWindows.Items[nIndex];
        Exit;
     end; { if }
   try
      ReportWindows.Capacity := ReportWindows.Count + 1;      { expand }
      ReportWindows.Add(Value);
      Result := ReportWindows.Items[ReportWindows.Count - 1];
   except
      on EOutOfMemory do Result := nil;
   end;
end; { NewReportWindow }

{ Member ActiveReport }
function TfrmMain.ActiveReport(var i : Integer) : TCrpe;
var
   hWindow : hWnd;
   nIndex  : Integer;
begin
   hWindow := SendMessage(ClientHandle, WM_MDIGETACTIVE, 0, 0);
   Result := nil;
   i := 0;
   for nIndex := 0 to (ReportWindows.Count - 1) do
      if TCrpe(ReportWindows.Items[nIndex]) <> nil then
         if TCrpe(ReportWindows.Items[nIndex]).ReportWindowHandle = hWindow then
         begin
            Result := TCrpe(ReportWindows.Items[nIndex]);
            i := nIndex;
         end; { if }
end; { ActiveReport }

{ Member EnableControls }
procedure TfrmMain.EnableControls(const Value : Boolean);
begin
   sbFirstPage.Enabled := Value;
   sbNextPage.Enabled := Value;
   sbPrevPage.Enabled := Value;
   sbLastPage.Enabled := Value;
   sbZoomPage.Enabled := Value;
   mmFilePrint.Enabled := Value;
   sbPrint.Enabled := Value;
   sbCloseReport.Enabled := Value;
end; { EnableControls }

{ Member UpdateControls }
procedure TfrmMain.UpdateControls;                            { for active window }
var
   nIndex  : Integer;
   Report  : TCrpe;
begin
   Report := ActiveReport(nIndex);
   if (Report <> nil) then
   begin
      with Report do
      begin
         if ReportDisplayPage = ReportStartPage then
         begin
            sbPrevPage.Enabled := False;
            sbFirstPage.Enabled := False;
         end
         else
         begin
            sbPrevPage.Enabled := True;
            sbFirstPage.Enabled := True;
         end;
         if ReportDisplayPage = ReportLatestPage then
         begin
            sbNextPage.Enabled := False;
            sbLastPage.Enabled := False;
         end
         else
         begin
            sbNextPage.Enabled := True;
            sbLastPage.Enabled := True;
         end;
      end; { with }
   end; { if }
end; { UpdateControls }

{ ClearReport }
procedure TfrmMain.ClearReport;
var
   nIndex : Integer;
   Report : TCrpe;
begin
   Report := ActiveReport(nIndex);
   if Report <> nil then
   begin
      Report.CloseWindow;
      Report.Free;
      ReportWindows.Items[nIndex] := nil;
   end; { if found }
end; { ClearReport }

{ Member OnCrpeExecute }
procedure TfrmMain.OnCrpeExecute(Sender : TObject);
begin
end; { OnCrpeExecute }

{ Member OnApplicationIdle }
procedure TFrmMain.OnApplicationIdle(Sender : TObject; var Done : Boolean);
var
   nIndex  : Integer;
   nCount  : Integer;

begin
   nCount := 0;
   if ReportWindows.Count <> 0 then
   for nIndex := 0 to (ReportWindows.Count - 1) do
      if TCrpe(ReportWindows.Items[nIndex]) <> nil then       { closed via this }
         if TCrpe(ReportWindows.Items[nIndex]).ReportWindowHandle = 0 then
         begin
            TCrpe(ReportWindows[nIndex]).Free;                { Free the memory }
            ReportWindows[nIndex] := nil                      { closed via pw }
         end
         else
            Inc(nCount);                                      { yes, so count em }
   if nCount = 0 then                                         { no, so disable btns }
      EnableControls(False)
   else
      UpdateControls;
   Done := True;
end; { OnApplicationIdle }

initialization

   ReportWindows := TList.Create;                             { pw list of TCrpe }
   ChildWindowOffSet := 1;                                    { static accumulator }

end.
