unit Rptdlg;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls, Tabs,
  Buttons, ExtCtrls, Dialogs, Mask;

type
  TMultPageDlg = class(TForm)
    ButtonPanel: TPanel;
    TabSet: TTabSet;
    Notebook: TNotebook;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    gbRptPg1: TGroupBox;
    gpRptPg2: TGroupBox;
    gpRptPg3: TGroupBox;
    cbWinControls: TCheckBox;
    cbMDIChild: TCheckBox;
    txtWindowTitle: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    cbReports: TComboBox;
    SpeedButton1: TSpeedButton;
    PrinterSetupDialog1: TPrinterSetupDialog;
    lblPrinter: TLabel;
    Button1: TButton;
    Label3: TLabel;
    Label4: TLabel;
    txtReportTitle: TEdit;
    Label5: TLabel;
    MaskEdit1: TMaskEdit;
    cbUsePrintDlg: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure TabSetClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MultPageDlg: TMultPageDlg;

implementation

{$R *.DFM}

uses
   General;

procedure TMultPageDlg.FormCreate(Sender: TObject);
var
   PrinterInfo : TPrinterInfo;
begin
  { make the number of Tabs = number of Pages,
    and have the same names }
  TabSet.Tabs := Notebook.Pages;
  PrinterInfo := GetPrinterInfo;
  lblPrinter.Caption := PrinterInfo.Name;
end;

procedure TMultPageDlg.TabSetClick(Sender: TObject);
begin
  { set visible Page to which Tab was clicked }
  Notebook.PageIndex := TabSet.TabIndex;
end;

procedure TMultPageDlg.OKBtnClick(Sender: TObject);
begin
   NoteBook.PageIndex := TabSet.TabIndex;
   Tag := 1;
   Hide;
end;

procedure TMultPageDlg.CancelBtnClick(Sender: TObject);
begin
   Tag := 0;
   Hide;
end;

procedure TMultPageDlg.Button1Click(Sender: TObject);
var
   PrinterInfo : TPrinterInfo;
begin
   PrinterSetupDialog1.Execute;
   PrinterInfo := GetPrinterInfo;
   lblPrinter.Caption := PrinterInfo.Name;
end;

end.
