unit Scr_Set;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, Dialogs, IniFiles, ScrSav;

type
  TfrmSetup = class(TForm)
    btnOk: TButton;
    btnCancel: TButton;
    Panel1: TPanel;
    Label1: TLabel;
    edFile: TEdit;
    btnScan: TButton;
    dlgFiles: TOpenDialog;
    procedure CancelBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure btnScanClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Saver : TScreenSaver;
  end;

var
  frmSetup: TfrmSetup;

implementation

{$R *.DFM}

procedure TfrmSetup.CancelBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmSetup.OKBtnClick(Sender: TObject);
begin
  Saver.CtrlIni.WriteString(Saver.CtrlSection,'Video',edFile.Text);
  Close;
end;

procedure TfrmSetup.btnScanClick(Sender: TObject);
begin
  dlgFiles.FileName:=edFile.Text;
  if dlgFiles.Execute then
     edFile.Text:=dlgFiles.FileName;
end;

procedure TfrmSetup.FormActivate(Sender: TObject);
begin
  edFile.Text:=Saver.CtrlIni.ReadString(Saver.CtrlSection,'Video','*.avi');
end;

end.
