unit Scr_Uni;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, ScrSav, MPlayer;

type
  { This is actual screensaving module, in this case a spotlight }
  TSpot = class (TTimer)
  private
    zx, zy      : Integer;
    cx, cy      : Integer;
    vx, vy      : integer;
    procedure   Draw(Sender:TObject);
    procedure   SetSpeed(Value:Integer);
    function    GetSpeed:Integer;
  public
    constructor Create(aOwner:TComponent); override;
  published
    property Speed: Integer read GetSpeed write SetSpeed default 6;
  end;

  { This is the container of the screensaver. It handles the
    display and termination of the screensaver. }
  TfrmSaver = class(TForm)
    ScrSav   : TScreenSaver;
    AviPlay  : TMediaPlayer;
    View     : TPanel;
    procedure FormDestroy(Sender: TObject);
    procedure ScrSavSetup(Sender: TObject);
    procedure ScrSavSave(Sender: TObject);
  private
    { Private-Deklarationen }
    FOldMouse : TPoint;                  { The mouse position }
    FSaver    : TSpot;
  public
    { Public-Deklarationen }
  end;

var
  frmSaver: TfrmSaver;

implementation

{$R *.DFM}

uses
  Scr_Set;

constructor TSpot.Create(aOwner:TComponent);
begin
  inherited Create(aOwner);
  Speed:= 6;
  OnTimer:=Draw;
  randomize;
  zx := Screen.Width;   zy := Screen.Height;
  cx := random (zx div 2) + 1; cy := random (zy div 2) + 1;
  vx := -1 + 2 * random (2);   vy := -1 + 2 * random (2);
end;

procedure TSpot.Draw(Sender:TObject);
begin
  with frmSaver do begin
    if ((cx <= 0) or (cx+View.Width  >= zx)) then vx := -vx;
    if ((cy <= 0) or (cy+View.Height >= zy)) then vy := -vy;
    cx := cx+vx*2;
    cy := cy+vy*2;
    View.Left:=cx;
    View.Top:=cy;
    with AviPlay do begin
      if Position>=Length then
      begin
        Rewind;
        Play;
      end;
    end;
  end;
end;

procedure TSpot.SetSpeed(Value:Integer);
begin Interval:=Value; end;

function TSpot.GetSpeed:Integer;
begin Result:=Interval; end;

{ ---------------------------------------------------------------------- }

procedure TfrmSaver.FormDestroy(Sender: TObject);
begin
  FSaver.Free;
end;

procedure TfrmSaver.ScrSavSetup(Sender: TObject);
begin
  Application.CreateForm(TfrmSetup, frmSetup);
  frmSetup.Saver:=ScrSav;
end;

procedure TfrmSaver.ScrSavSave(Sender: TObject);
begin
 { ScrSav.Password:='xTool'; }
  FSaver:=TSpot.Create(Self);
  FSaver.Speed:=3;
  with AviPlay, ScrSav do begin
    FileName:=CtrlIni.ReadString(CtrlSection,'Video','*.avi');
    AutoRewind:=True;
    Open;
    Play;
  end;
end;

end.
