unit Maindemo;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, YRChrono, Buttons;

type
  TTestChrono = class(TForm)
    BitBtn1: TBitBtn;
    MyChrono: TYRChronometre;
    Reset: TButton;
    Start: TButton;
    Stop: TButton;
    Elapsed: TButton;
    TotalElapsed: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Edit2: TEdit;
    TestDiffDate: TButton;
    Label3: TLabel;
    Edit3: TEdit;
    procedure BitBtn1Click(Sender: TObject);
    procedure ResetClick(Sender: TObject);
    procedure StartClick(Sender: TObject);
    procedure StopClick(Sender: TObject);
    procedure ElapsedClick(Sender: TObject);
    procedure TotalElapsedClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TestDiffDateClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TestChrono: TTestChrono;

implementation

{$R *.DFM}

procedure TTestChrono.BitBtn1Click(Sender: TObject);
begin
	Close ;
end;

procedure TTestChrono.ResetClick(Sender: TObject);
begin
	MyChrono.Reset ;
  Edit1.Text	:= MyChrono.Time2Str(MyChrono.TimeElapsed) ;
  Edit2.Text	:= MyChrono.Time2Str(MyChrono.TotalTimeElapsed) ;
  Edit3.Text	:= '' ;
end;

procedure TTestChrono.StartClick(Sender: TObject);
begin
  MyChrono.Start ;
end;

procedure TTestChrono.StopClick(Sender: TObject);
begin
  MyChrono.Stop ;
end;

procedure TTestChrono.ElapsedClick(Sender: TObject);
begin
  Edit1.Text := MyChrono.Time2Str(MyChrono.TimeElapsed) ;
end;

procedure TTestChrono.TotalElapsedClick(Sender: TObject);
begin
  Edit2.Text := MyChrono.Time2Str(MyChrono.TotalTimeElapsed) ;
end;

procedure TTestChrono.FormCreate(Sender: TObject);
begin
  TestChrono.Caption := 'TYRChronometre ( Copyright 1995 by Y. Rochat)';
  MyChrono.Reset ;
  Edit1.Text	:= MyChrono.Time2Str(MyChrono.TimeElapsed) ;
  Edit2.Text	:= MyChrono.Time2Str(MyChrono.TotalTimeElapsed) ;
  Edit3.Text	:= '' ;
end;

procedure TTestChrono.TestDiffDateClick(Sender: TObject);

var D1,D2 	: TDateTime ;
    NbDays	: Word ;

begin
  D1 					:= EncodeDate(2000,1,1) ;
  D2 					:= EncodeDate(2001,1,1) ;
  NbDays			:= MyChrono.jours_Ecoule(D1,D2) ;
  Edit3.Text	:= InttoStr(NbDays) ;
end;

end.
