{%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%}
{   \\\                                      }
{  -(j)-                                     }
{    /juanco                                }
{    ~                                       }
{                                            }
{  Juanco Aez 1995, All rights reserved    }
{   73000.1064@compuserve.com                }
{%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%}
{
// This unit implements a convenient assertion mechanism for
// Borland Delphi programs.  Some of the Delphi features used in
// this implementation of assertions are class references and
// the hardly documented RAISE-AT statement.
//
// An explanation of the unit and of a reasonable approach to
// assertions in Delphi can be found in the February 1996 edition
// of Windows Tech Journal (Oakley Publishing, Eugene, OR).
//
// You are granted complete freedom to use this code in your applications.
// You can also distribute the Pascal unit or parts of it with components
// you develop as long as the above copyright notice is kept.
//
// There are no guarantees, expressed or implied, as to the use of this code.
// You use the provided code at your own risk.
}
unit Assert_;

interface
{$ifndef VER70}
uses
    SysUtils;
{$endif}

type
 {$ifdef VER70}
   Exception = Pointer;
   EAssertionFailedClass = Pointer;
 {$else}
   EFailed = class (Exception)
      constructor Create; virtual;
   end;

   EAssertionFailedClass = class of EFailed;
   EFreeNilObject = class(EFailed);
   EInvalidFileName = class(EFailed);
{$endif}
  TAssertProc      = procedure( fact:Boolean; ExceptClass :EAssertionFailedClass);

  function ReturnAddr :Pointer;
  function ConvertAddr(Address: Pointer): Pointer;

  procedure Assert(fact:Boolean; ExceptClass :EAssertionFailedClass);
  procedure AssertMsg(fact:Boolean; ExceptClass :EAssertionFailedClass; const msg :String);

const
    require :TAssertProc = Assert;
    ensure  :TAssertProc = Assert;

implementation

{$ifndef VER70}
  constructor EFailed.Create;
  begin
       inherited Create(ClassName)
  end;

{$endif}

function ReturnAddr :Pointer; assembler;
const
  FaultIP = $02;
  FaultCS = $04;
asm
   mov   ax, [bp].FaultIP
   mov   dx, [bp].FaultCS
end;

{ from VCL }
 function ConvertAddr(Address: Pointer): Pointer; assembler;
 asm
      MOV     AX,Address.Word[0]
      MOV     DX,Address.Word[2]
      MOV     CX,DX                   { Always convert nil to nil }
      OR      CX,AX
      JE      @@1
 {$IFDEF MSDOS}
      SUB     DX,PrefixSeg
      SUB     DX,10H
 {$ELSE}
      CMP     DX,0FFFFH
      JE      @@1
      MOV     ES,DX
      MOV     DX,ES:Word[0]
 {$ENDIF}
 @@1:
 end;

procedure Assert(fact :Boolean; ExceptClass :EAssertionFailedClass);
const
  { place these two in the data segment. we're gonna pot the stack }
  exc          :Exception = nil;
  FaultAddress :Pointer   = nil;
begin
  if not fact then begin
  {$ifdef VER70}
     runError(201); {generate a RangeCheck error }
  {$else}
      if Assigned(ExceptClass) then
         exc := ExceptClass.Create
      else
         exc := EFailed.Create;
      { save the caller's return-to address}
      FaultAddress := ReturnAddr;
      { pop the stack frame so we don't fool the debugger with this long jump }
      asm
         mov sp, bp { undo the stack frame (same as "leave" ) }
         pop bp
         add sp, 6  { pop parameters and return address }
      end;
      raise exc at FaultAddress;
  {$endif}
  end
end;


procedure AssertMsg(fact :Boolean; ExceptClass :EAssertionFailedClass; const msg :String);
const
   exc          :Exception = nil;
   FaultAddress :Pointer = nil;
begin
  if not fact then begin
   {$ifdef VER70}
     runError(201); {generate a RangeCheck error }
   {$else}
     if assigned(ExceptClass) then
        exc := ExceptClass.Create
     else
        exc := EFailed.Create;
     if msg <> '' then
        exc.Message := exc.Message+#13+msg;
     FaultAddress := ReturnAddr;
     asm
        { pop the stack frame so we don't fool the debugger with this long jump }
        mov sp, bp { undo the stack frame (same as "leave" ) }
        pop bp
        add sp, 6  { pop parameters and return address }
     end;
     raise exc at FaultAddress;
   {$endif}
  end
end;


end.
