unit calc;
{ Delphi Project translation }
{ From EarthTrek Inc.        }

interface

uses VB,
SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
Forms, Dialogs, StdCtrls;
{ append modal form names here }

type
 TCalculator = class(TForm)
  NumberIndeX7: TButton;
  NumberIndeX8: TButton;
  NumberIndeX9: TButton;
  Cancel: TButton;
  CancelEntry: TButton;
  NumberIndeX4: TButton;
  NumberIndeX5: TButton;
  NumberIndeX6: TButton;
  OperatorIndeX1: TButton;
  OperatorIndeX3: TButton;
  NumberIndeX1: TButton;
  NumberIndeX2: TButton;
  NumberIndeX3: TButton;
  OperatorIndeX2: TButton;
  OperatorIndeX0: TButton;
  NumberIndeX0: TButton;
  Decimal: TButton;
  OperatorIndeX4: TButton;
  Percent: TButton;
  Readout: TLabel;
  procedure Cancel_Click(Sender: TObject);
  procedure CancelEntry_Click(Sender: TObject);
  procedure Decimal_Click(Sender: TObject);
  procedure Form_Load(Sender: TObject);
  procedure Number_Click(Sender: TObject);
  procedure Operator_Click(Sender: TObject);
  procedure Percent_Click(Sender: TObject);
  { Array function helpers }
  function Number(ind: integer): TButton;
  function Operator(ind: integer): TButton;
private
  { Private declarations }
public
  { Public declarations }
end;

var
 iCalculator: TCalculator;
  Op1, Op2: Previously { possible unknown, or user type };
  DecimalFlag: integer;
  NumOps: integer;
  LastInput: Indicate { possible unknown, or user type };
  OpFlag: Indicate { possible unknown, or user type };
  TempReadout:  { possible unknown, or user type };

implementation

{$R *.DFM}

{----------------------------------------}
{ Array function helpers - code body }

  function TCalculator.Number(ind: integer): TButton;
  begin
    result := TButton(FindComponent('NumberIndeX'+VBstr(ind)));
  end;

  function TCalculator.Operator(ind: integer): TButton;
  begin
    result := TButton(FindComponent('OperatorIndeX'+VBstr(ind)));
  end;
{----------------------------------------}
procedure TCalculator.Cancel_Click(Sender: TObject);
begin
    ReadOut := '0.';
    Op1 := 0;
    Op2 := 0;
    Form_Load;
end;
{----------------------------------------}
procedure TCalculator.CancelEntry_Click(Sender: TObject);
begin
    ReadOut := '0.';
    DecimalFlag := False;
    LastInput := 'CE';
end;
{----------------------------------------}
procedure TCalculator.Decimal_Click(Sender: TObject);
begin
    If LastInput = 'NEG' Then
    begin
	ReadOut := '-0.';
    end
    else
    if LastInput <> 'NUMS' Then
    begin
	ReadOut := '0.';
    end;
    DecimalFlag := True;
    LastInput := 'NUMS';
end;
{----------------------------------------}
procedure TCalculator.Form_Load(Sender: TObject);
begin
    DecimalFlag := False;
    NumOps := 0;
    LastInput := 'NONE';
    OpFlag := ' ';
end;
{----------------------------------------}
procedure TCalculator.Number_Click(Sender: TObject);
begin
    If LastInput <> 'NUMS' Then
    begin
	ReadOut := '.';
	DecimalFlag := False;
    end;
    If DecimalFlag Then
    begin
	ReadOut := ReadOut + Number(VBIndex(Sender)).Caption;
    end
    else
    begin
	ReadOut := VBLeft(ReadOut, InStr(ReadOut, '.') - 1) + Number(VBIndex(Sender)).Caption + '.';
    end;
    If LastInput = 'NEG' Then 
      ReadOut := '-' + ReadOut;
    LastInput := 'NUMS';
end;
{----------------------------------------}
procedure TCalculator.Operator_Click(Sender: TObject);
begin
    TempReadout := ReadOut;
    If LastInput = 'NUMS' Then
    begin
	NumOps := NumOps + 1;
    end;
    case NumOps of
0: begin;
	If (Operator(VBIndex(Sender)).Caption = '-') And (LastInput <> 'NEG') Then 
 begin
	    ReadOut := '-' + ReadOut;
	    LastInput := 'NEG';
 end;
end;
1: begin;
	Op1 := ReadOut;
	If (Operator(VBIndex(Sender)).Caption = '-') And (LastInput <> 'NUMS') And (OpFlag <> '=') Then 
 begin
	    ReadOut := '-';
	    LastInput := 'NEG';
 end;
end;
2: begin;
	Op2 := TempReadout;
 case OpFlag of
'+': begin;
  		Op1 := VBval(Op1) + VBval(Op2);
end;
'-': begin;
		Op1 := Op1 - Op2;
end;
'X': begin;
		Op1 := Op1 * Op2;
end;
'/': begin;
		If Op2 = 0 Then
  begin
		   MsgBox "Can't divide by zero", 48, "Calculator";
  end
  else
  begin
		   Op1 := Op1 div Op2;
  end;
end;
'=': begin;
		Op1 := Op2;
end;
'%': begin;
		Op1 := Op1 * Op2;
end;
end; {c a s e}
	ReadOut := Op1;
	NumOps := 1;
end;
end; {c a s e}
    If LastInput <> 'NEG' Then
    begin
	LastInput := 'OPS';
	OpFlag := Operator(VBIndex(Sender)).Caption;
    end;
end;
{----------------------------------------}
procedure TCalculator.Percent_Click(Sender: TObject);
begin
    ReadOut := ReadOut div 100;
    LastInput := 'Ops';
    OpFlag := '%';
    NumOps := NumOps + 1;
    DecimalFlag := True;
end;

begin
 RegisterClasses( [TCalculator,TButton,TLabel] );
 iCalculator := TCalculator.Create(Application);
end.

