{ Class Delegation Example.
  David Berneda. May-1996
  Released to the public domain.
  Redistribute freely.
}
unit Mypanel;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls,Buttons;

type
  TMyPanel = class(TCustomPanel)
  private
    { Private declarations }
    FButton:TButton;
  protected
    { Protected declarations }
    Procedure ClickedButton(Sender:TObject); virtual;
    Function GetDelegatedClass(AClass:TComponentClass):TComponentClass; virtual;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    Destructor Destroy; override;
    property Button:TButton read FButton;
  published
    { Published declarations }
  end;

  TMyOtherPanel = class(TMyPanel)
  protected
    Procedure ClickedButton(Sender:TObject); override;
    Function GetDelegatedClass(AClass:TComponentClass):TComponentClass; override;
  public
    constructor Create(AOwner: TComponent); override;
  end;

procedure Register;

implementation

constructor TMyPanel.Create(AOwner: TComponent);
Begin
  inherited Create(AOwner);
  Height:=32;

  FButton:=GetDelegatedClass(TButton).Create(Self) as TButton; { <-- here !! }

  { we change the button's properties here... }
  FButton.Width:=80;
  FButton.Left:=Width-FButton.Width;
  FButton.Height:=Height;
  FButton.OnClick:=ClickedButton;
  FButton.Caption:='Hi !';
  FButton.Parent:=Self;
End;

Procedure TMyPanel.ClickedButton(Sender:TObject);
Begin
  { this code will change the panel color (just an example) }
  if Color=clBtnFace then Color:=clBlue
                     else Color:=clBtnFace;
End;

Function TMyPanel.GetDelegatedClass(AClass:TComponentClass):TComponentClass;
Begin
  { This is the special function.
    In this TMyPanel class, we just return the same parameter class,
    meaning we don't want to change the default Button class }
  result:=AClass;
End;

Destructor TMyPanel.Destroy;
Begin
  { cleaning stuff... }
  FButton.Free;
  inherited Destroy;
End;

{ Now here it comes our next derived panel:

  TMyOtherPanel

  For this example, we just change the Button.Kind property to see
  something both at design and run-time.
  See that we cast Button to "TBitBtn" because this is the
  Button class we are changing in this component.

}
constructor TMyOtherPanel.Create(AOwner: TComponent);
Begin
  inherited Create(AOwner);
  (Button as TBitBtn).Kind:=bkAll;
End;

Procedure TMyOtherPanel.ClickedButton(Sender:TObject);
Begin
  { more sample code with no meaning }
  if Color=clBtnFace then Color:=clRed
                     else Color:=clBtnFace;
End;

{ Here is the Class Delegation trick !!! }
{
  We change the default TButton class with TBitBtn.
  The ancestor ( TMyPanel ) allows it with this virtual
  function.
}
Function TMyOtherPanel.GetDelegatedClass(AClass:TComponentClass):TComponentClass;
Begin
  if AClass=TButton then result:=TBitBtn   { <-- here !!  }
                    else result:=inherited GetDelegatedClass(AClass);
End;

procedure Register;
begin
  RegisterComponents('Samples', [TMyPanel,TMyOtherPanel]);
end;

end.
