{Conversion Unit -

 Designer:  Craig Ward
 Date:      19/7/95

 Function:  Measurement converter

*******************************************************************************}
unit Cvert;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
 TConvertKind = (FahrenConvert, CelsiusConvert, MileConvert, KMConvert);
 TValueConverter = class(TComponent)
  private
    { Private declarations }
    FKind: TConvertKind;
    procedure SetConvertKind(Value: TConvertKind);
  protected
    { Protected declarations }
  public
    { Public declarations }
    function ConvertValue(value: double): double;
  published
    { Published declarations }
    property Kind: TConvertKind read FKInd write SetConvertKind;
end;

procedure Register;

{****************************************************************************}
implementation

{procedure to register this as a custom component}
procedure Register;
begin
  RegisterComponents('Samples', [TValueConverter]);
end;

{set the conversion type}
procedure TValueConverter.SetConvertKind(Value: TConvertKind);
begin
 if value <> FKind then
  begin
   FKind := Value;
  end;
end;

{convert the value passed as a parameter}
function TValueConverter.ConvertValue(value: double): double;
begin
 case FKind of
  FahrenConvert:
   begin
    result := ((value * 9)/5) + 32;
   end;
  CelsiusConvert:
   begin
    result := ((value - 32) * 5)/9;
   end;
  MileConvert:
   begin
    result := (value/8) * 5;
   end;
  KMConvert:
   begin
    result := (value/5) * 8;
   end;
  end;
end;


end.
