{Conversion Programme -

 Designer:  Craig Ward
 Date:      19/7/95

 Function:  Converts values entered by user to format as specified
            by the user.

******************************************************************************}
unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Cvert, Menus,
  About;

type
  TForm1 = class(TForm)
    ValueConverter1: TValueConverter;
    Edit1: TEdit;
    Edit2: TEdit;
    RadioGroup1: TRadioGroup;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Label1: TLabel;
    Label2: TLabel;
    Execute1: TMenuItem;
    N1: TMenuItem;
    Help2: TMenuItem;
    N2: TMenuItem;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Help2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{conversion procedure}
procedure TForm1.BitBtn1Click(Sender: TObject);
var
 dRaw, dRet: double;
begin
 if Edit1.Text = '' then
  exit;
 {convert text entered by the user into float value}
 dRaw := StrToFloat(Edit1.Text);
 {send over the float value to the ValueConverter}
 dRet := ValueConverter1.ConvertValue(dRaw);
 {convert the returned value into text}
 Edit2.Text := FloatToStr(dRet);
end;

{close form}
procedure TForm1.BitBtn2Click(Sender: TObject);
begin
 close;
end;

{set the conversion routine to be used by ValueConverter -
 note that we have to hard-code the indices. Make sure they don't
 change!}
procedure TForm1.RadioGroup1Click(Sender: TObject);
var
 iConvert: integer;
begin
 iConvert := RadioGroup1.ItemIndex;
 case iConvert of
  0:
   ValueConverter1.Kind := CelsiusConvert;
  1:
   ValueConverter1.Kind := FahrenConvert;
  2:
   ValueConverter1.Kind := MileConvert;
  3:
   ValueConverter1.Kind := KMConvert;
 end;
end;

{set the RadioGroup's default}
procedure TForm1.FormCreate(Sender: TObject);
begin
 RadioGroup1.ItemIndex := 1;
end;

{show About box}
procedure TForm1.About1Click(Sender: TObject);
begin
 AboutBox.ShowModal;
end;

procedure TForm1.Help2Click(Sender: TObject);
begin
 Application.HelpContext(2);
end;

end.
