{    Last change:  JW    1 Sep 95    8:25 am    }
unit Ufile;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, FileCtrl, ExtCtrls;

type

  TDFMOrTXT = (ConvertToForm, ConvertToText) ;

  TForm1 = class(TForm)
    ResultLabel: TLabel;
    StatusLabel: TLabel;
    Wizard: TNotebook;
    RadioGroup2: TRadioGroup;
    GroupBox1: TGroupBox;
    FileListBox1: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    FilterComboBox1: TFilterComboBox;
    Panel1: TPanel;
    pbPrevious: TButton;
    pbNext: TButton;
    pbConvert: TButton;
    pbExit: TButton;
    RadioGroup1: TRadioGroup;
    Step3lLabel: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    pbAboutMe: TButton;
    procedure pbConvertClick(Sender: TObject);
    procedure pbExitClick(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    Function ConvertFormOrText(FileToConvertFrom : string) : boolean ;
    procedure ProcessAllFiles(const Extension : string) ;
    procedure pbNextClick(Sender: TObject);
    procedure pbPreviousClick(Sender: TObject);
    procedure pbAboutMeClick(Sender: TObject);

  private

    { This holds the current type of conversion we are performing }

    ConversionType : TDFMOrTXT ;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

Function TForm1.ConvertFormOrText(FileToConvertFrom : string) : boolean ;
Var
  InputStream, OutputStream : TFileStream;
  FileToConvertTo : string ;
Begin

  { Given a file name this routine will convert the file from either
    1. A text file to a DFM file or
    2. A DFM file to a text file
    The output file name is built from the input file name }


  Result := True ;
  FileToConvertTo := FileToConvertFrom ;

  { change file extensions as appropriate }

  case ConversionType of
    ConvertToForm :
    Begin
      FileToConvertFrom := ChangeFileext(FileToConvertFrom, '.TXT') ;
      FileToConvertTo := ChangeFileext(FileToConvertFrom, '.DFM') ;
    End ;
    ConvertToText :
    Begin
      FileToConvertFrom := ChangeFileext(FileToConvertFrom, '.DFM') ;
      FileToConvertTo := ChangeFileext(FileToConvertFrom, '.TXT') ;
    End ;
  End ;


  try

    try

      { Create a file stream for the specified file }

      InputStream  := TFileStream.Create(FileToConvertFrom, fmOpenRead);
      OutputStream := TFileStream.Create(FileToConvertTo, fmCreate);

      { Now perform the selected conversion }

      case ConversionType of
        ConvertToForm : ObjectTextToResource(InputStream, OutputStream) ;
        ConvertToText : ObjectResourceToText(InputStream, OutputStream);
      end ;

    Except
      On EStreamError do Result := False ;
      On EGPFault do result := False ;
    End ;
  Finally

    InputStream.Free;
    OutputStream.Free;
  End ;
End;

procedure TForm1.ProcessAllFiles(const Extension : string) ;
var
  SourceFile : string ;
  d : string ;
  SearchRec: TSearchRec;
  RetCode : integer ;
  FilesConverted : Integer ;
Begin

  { Routine to process all files of a specified type }

  FilesConverted := 0 ;

  d := DirectoryListBox1.directory+'\' ;

  RetCode := FindFirst(d+Extension, 0, SearchRec);
  while RetCode = 0 do
  Begin
    SourceFile := d+SearchRec.Name ;
    if ConvertFormOrText(SourceFile) then
      Inc(FilesConverted) ;

    RetCode := FindNext(SearchRec) ;
  end ;

  ResultLabel.Caption := inttostr(FilesConverted)+' file(s) converted correctly' ;

End ;

procedure TForm1.pbConvertClick(Sender: TObject);
var
  SourceFile : string ;
begin

  { Choose whether to convert the selected file or
    all the files }

  case RadioGroup1.ItemIndex of
    0 :
    Begin
      SourceFile := FileListBox1.FileName ;
      if fileexists(SourceFile) then
      Begin
        if ConvertFormOrText(SourceFile) then
          ResultLabel.Caption := 'Done'
        else
          ResultLabel.caption := 'Failed to convert - may be invalid format'
      End
      else
        ResultLabel.Caption := 'File Not Found' ;
    end ;
    1 :
    Begin

      { Process all the files in the selected directory }

      case ConversionType of
        ConvertToText : ProcessAllFiles('*.DFM') ;
        ConvertToForm : ProcessAllFiles('*.TXT') ;
      End ;
    End ;
  end ;
end;

procedure TForm1.pbExitClick(Sender: TObject);
begin
  close ;
end;

procedure TForm1.RadioGroup2Click(Sender: TObject);
begin

  { Swap TXT to DFM or DFM to TXT }

  case RadioGroup2.itemIndex of
   0 :
    Begin
      pbConvert.caption := 'DFM -> TXT' ;
      FileListBox1.Mask := '*.DFM' ;
      FilterComboBox1.Filter := 'Form Files|*.DFM' ;
      ConversionType := ConvertToText ;
    End ;
    1 :
    Begin
      pbConvert.caption := 'TXT -> DFM' ;
      FileListBox1.Mask := '*.TXT' ;
      FilterComboBox1.Filter := 'Text Files|*.TXT' ;
      ConversionType := ConvertToForm ;
    End ;
  end ;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ConversionType := ConvertToText ;
  pbConvert.caption := 'DFM -> TXT' ;
  FileListBox1.Mask := '*.DFM' ;
end;

procedure TForm1.pbNextClick(Sender: TObject);
begin

  { Next screen button }

  pbConvert.Enabled := false ;
  pbNext.Enabled := True ;
  pbPrevious.Enabled := True ;
  case Wizard.PageIndex of
    0 :
    Begin
      Wizard.PageIndex := Wizard.PageIndex + 1 ;
    End ;
    1 :
    Begin
      Wizard.PageIndex := Wizard.PageIndex + 1 ;
      pbConvert.Enabled := True ;
      pbNext.enabled := false ;

    End ;
  end ;
end;

procedure TForm1.pbPreviousClick(Sender: TObject);
begin

  { Previous Screen button }

  pbConvert.Enabled := false ;
  pbNext.Enabled := True ;
  pbPrevious.Enabled := True ;
  case Wizard.PageIndex of
    1 :
    Begin
      Wizard.PageIndex := Wizard.PageIndex - 1 ;
      pbPrevious.enabled := false ;
    End ;
    2 :
    Begin
      Wizard.PageIndex := Wizard.PageIndex - 1 ;
    End ;
  end ;

end;

procedure TForm1.pbAboutMeClick(Sender: TObject);
begin
  MessageDlg('Written by John Wright (CIS 100335,322) (c) 1995.'+#13+'Use at your own risk.', mtInformation, [mbOK], 0) ;
end;

end.
