{DRAG N DROP TOOLBAR DEMONSTRATION PROGRAM

BY MR. KELLY YOUNG, MAINE COMPUTER GROUP: JUNE, 1995

THIS DEMO PROGRAM IS FREEWARE AND HAS ABSOLUTELY NO WARRANTY
OF ANY KIND, SHAPE, OR FORM, AND YOU, THE USER, ACCEPT FULL
RESPONSIBILITY FOR ITS USE!}

unit Main;

interface

uses WinTypes, WinProcs, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, TBC{My Global Variable Unit}, TEFORM;{The Editor Form}


  type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    Panel1: TPanel;
    StatusLine: TPanel;
    File1: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    Panel2: TPanel;
    FileCloseItem: TMenuItem;
    Window1: TMenuItem;
    Help1: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    WindowCascadeItem: TMenuItem;
    WindowTileItem: TMenuItem;
    WindowArrangeItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    Edit1: TMenuItem;
    CutItem: TMenuItem;
    CopyItem: TMenuItem;
    PasteItem: TMenuItem;
    WindowMinimizeItem: TMenuItem;
    Toolbar: TPanel;
    EditToolbar1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure WindowCascadeItemClick(Sender: TObject);
    procedure UpdateMenuItems(Sender: TObject);
    procedure WindowTileItemClick(Sender: TObject);
    procedure WindowArrangeItemClick(Sender: TObject);
    procedure WindowMinimizeItemClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ToolbarDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure ToolbarDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ToolbarEndDrag(Sender, Target: TObject; X, Y: Integer);
    procedure SB1Click(Sender: TObject);
    procedure SB2Click(Sender: TObject);
    procedure SB3Click(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure EditToolbar1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ShowHint(Sender: TObject);
 {MoveBut is the Method assigned to a new button}
 {SaveTB is the Method that Saves the Toolbar Configuration to the Hard Drive}
 {LoadTB is the Method that Loads the Toolbar Configuration at startup time}
    procedure MoveBut(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure SaveTB(Sender: TObject);
    procedure LoadTB(Sender: TObject);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnHint := ShowHint;
  Screen.OnActiveFormChange := UpdateMenuItems;
  {Set Global variables to startup defaults}
  ConfigTB := false;
  Working := false;
  TBChanged := false;
  {Load the Toolbar Configuration}
  LoadTB(Sender);  {MAKE SURE YOU COMMENT THIS OUT THE FIRST TIME YOU RUN THIS THING!!!}
end;               {See Big hint #1 in the Readme file...}

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  action := caFree;
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusLine.Caption := Application.Hint;
end;

procedure TMainForm.WindowCascadeItemClick(Sender: TObject);
begin
  Cascade;
end;

procedure TMainForm.WindowTileItemClick(Sender: TObject);
begin
  Tile;
end;

procedure TMainForm.WindowArrangeItemClick(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TMainForm.WindowMinimizeItemClick(Sender: TObject);
var
  I: Integer;
begin
  for I := MDIChildCount - 1 downto 0 do
    MDIChildren[I].WindowState := wsMinimized;
end;

procedure TMainForm.UpdateMenuItems(Sender: TObject);
begin
  FileCloseItem.Enabled := MDIChildCount > 0;
  FileSaveItem.Enabled := MDIChildCount > 0;
  FileSaveAsItem.Enabled := MDIChildCount > 0;
  CutItem.Enabled := MDIChildCount > 0;
  CopyItem.Enabled := MDIChildCount > 0;
  WindowCascadeItem.Enabled := MDIChildCount > 0;
  WindowTileItem.Enabled := MDIChildCount > 0;
  WindowArrangeItem.Enabled := MDIChildCount > 0;
  WindowMinimizeItem.Enabled := MDIChildCount > 0;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  Screen.OnActiveFormChange := nil;
end;

{This Method handles the action when a button is dropped onto the toolbar.  It has 2 ways
to go:  #1: If it is a brand new button (Working = false), then assign the stuff listed
below from the button in the Editor Window to the new button, and  #2: If we're just moving
and existing button (Working = true), just move it to the new location we dragged it to.
Also, if you attempt to drag a button onto the toolbar that is already on the toolbar, a
ECOMPONENTERROR exception is generated.  We handle that here, as well}
procedure TMainForm.ToolbarDragDrop(Sender, Source: TObject; X,Y: Integer);
begin
if source is TSpeedButton then
begin
   if (Working = false) then   {if this is a brand new button...}
   begin
   try
   TempButton := TSpeedButton.Create(Toolbar);  {create the new button in memory}
   TempButton.Parent := Toolbar;                {set the new buttons' parent}
   TempButton.Name := TSpeedButton(Source).Name; {copy over the name of the button}
   TempButton.glyph := TSpeedButton(Source).glyph;{copy the glyph}
   TempButton.Width := TSpeedButton(Source).Width; {the width}
   TempButton.Hint := TSpeedButton(Source).Hint;  {the hint, too, while we're at it}
   AssignOnClick(Sender);  {from the global TBC unit, assign a Method and bitmap to the new button}
   TempButton.OnMouseDown := MoveBut; {assign this method to the OnMouseDown event}
   TempButton.Top := 5;         {assign a default Y pos, relational to the top of the toolbar}
   TempButton.Left := X;        {assign the left side of the button to the drop's X position}
   TempButton.NumGlyphs := 2;   {assign the standard 2 bitmaps bitmap to the button}
   TempButton.Visible := true;  {finally, after all that, let's see the little booger!}
     except
     on EComponentError do      {if we already have this button on the toolbar}
     begin
     TempButton.Free;           {delete the attempted creation of the button}
     Messagedlg('This button is already on your Toolbar!',mterror,[mbok],0);{let user know about it}
     end;
     end;
   end
   else
   begin
   with source as TSpeedButton do {if we're just moving an existing button...}
   begin
     Top := 5;                   {set it to these coordinates}
     Left := x;
   end;
   end;
 end;
 Working := false;         {make sure we don't stay in the "just moving existing button" mode}
end;


{If we're dragging a SpeedButton over the Toolbar, we like that and are willing to accept it!}
procedure TMainForm.ToolbarDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
if source is TSpeedButton then accept := true;
end;


{This method, assigned to the OnMouseDown event of new buttons, kicks in when we click on an
existing button on the toolbar}
procedure TMainForm.MoveBut(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  SendFromPool := false; {Global var, saying that this button didn't come from Editor Window}
  if ConfigTB = True then{if we're configuring the toolbar when we click this button...}
  begin
  Working := true;       {put us in "just moving existing button" mode}
  With sender as TSpeedButton do
  begin
    beginDrag(true);
  end;
  end;
end;


{This method loads up the saved Toolbar configuration file from your hard drive}
procedure TMainForm.LoadTB (Sender: TObject);
var
i,Num:integer;
begin
  AssignFile(TBF,'TBINFO.INF'); {suck up the file, a record found in the TBC unit}
  Reset(TBF);
  Read(TBF, TB);
  CloseFile(TBF);
  Num := TB.Count;
  with Toolbar do               {make sure we're working with Toolbar stuff}
  begin
   for i := 0 to Num-1 do       {do the following for each and every button on the toolbar}
   begin
   TempButton := TSpeedButton.Create(Toolbar); {create it in memory}
   TempButton.Parent := Toolbar;               {assign the parent}
   TempButton.Name := strpas(TB.Name[i]);      {assign the button a name}
   TempButton.Hint := strpas(TB.Hint[i]);      {give it a hint, too}
   TempButton.Width := TB.Width[i];            {make it the same size as we saved it}
   TempButton.Left := TB.XPos[i];              {put it right where we left it last}
   AssignOnClick(Sender);                      {tell it what to do when clicked}
   TempButton.NumGlyphs := 2;                  {give it the standard 2 bitmaps bitmap}
   TempButton.OnMouseDown := MoveBut;          {if we should decide to move it later}
   TempButton.Top := 5;                        {give it a Y pos, from the top of the toolbar}
   TempButton.Visible := true;                 {well, LETS SEE IT!}
   end;
  end;
end;


{This Method saves the Toolbar configuration file to your hard drive.  The file is the record
found in the TBC unit.  It keeps track of the button's Name, Hint, Width, and X position on
the toolbar, so each time we start our app the toolbar is just the way the user wants it!}
procedure TMainForm.SaveTB(Sender: TObject);
var
i:integer;
label 1;
begin
fillchar (TB,sizeof(TB),#0);   {clear out the record, so no junk winds up getting saved}
  with Toolbar do
  begin

  1:
    for i := 0 to Componentcount-1 do  {with each component found on the toolbar...}
      if TSpeedButton(Components[i]).visible = false then {has it been "deleted"?}
      begin
        TSpeedButton(components[i]).free;{if so, blow it out}
        goto 1;                    {I can't believe I used this, but start the function all over}
      end;                         {so we don't get a "list out of bounds" error here}

    for i := 0 to ComponentCount-1 do {now that the deadwood is gone, with each button...}
      begin
        strpcopy(TB.Name[i],TSpeedButton(Components[i]).Name);{let's fill up the record with}
        strpcopy(TB.Hint[i],TSpeedButton(Components[i]).Hint);{these parameters for each button}
        TB.Width[i] := TSpeedButton(Components[i]).Width;
        TB.XPos[i] := TSpeedButton(Components[i]).Left;
      end;
  TB.Count := Componentcount;      {also save the number of buttons on the toolbar}
  end;
  AssignFile(TBF,'TBINFO.INF');    {slam that info onto my hard drive, please!}
  ReWrite(TBF);
  Write(TBF, TB);
  CloseFile(TBF);
  TBChanged := False;              {toolbar is saved, so it's no longer "changed"}
end;

{This method is a precautionary step, to make sure we can't delete buttons from the Editor}
procedure TMainForm.ToolbarEndDrag(Sender, Target: TObject; X, Y: Integer);
begin
  Working := false;      {set to "new button" mode}
  SendFromPool := true;  {set to "button from editor" mode}
end;

{These next 3 are whatever you want toolbar buttons to do whenever your user clicks on them during
normal program use.  Note that we make sure that if we're in Toolbar Configuration mode, we
don't do SQUAT, for fear of really messing up our toolbar while we're configuring it!  THIS IS
BIG HINT #2!  YOU MUST PUT THE SAFETY CODE INTO EVERY METHOD THAT IS ATTACHED TO ANY TOOLBAR
BUTTON, WHETHER THAT BUTTON IS EVER USED OR NOT!!!!}
procedure TMainForm.SB1Click(Sender: TObject);
begin
if ConfigTB = false then
begin
  messagedlg('You pressed the Exit Toolbar button.',mtinformation,[mbok],0);
end;
end;

procedure TMainForm.SB2Click(Sender: TObject);
begin
if ConfigTB = false then
begin
  messagedlg('You pressed the Save Toolbar button.',mtinformation,[mbok],0);
end;
end;

procedure TMainForm.SB3Click(Sender: TObject);
begin
if ConfigTB = false then
begin
  messagedlg('You pressed the Copy Toolbar button.',mtinformation,[mbok],0);
end;
end;

procedure TMainForm.FileExitItemClick(Sender: TObject);
begin
  close;
end;

{Normal opening of the Toolbar Editor Window}
procedure TMainForm.EditToolbar1Click(Sender: TObject);
begin
  try
  Editor := TEditor.Create(Self);
  application.processmessages;
    try
    Editor.Show;
    application.processmessages;
    except
    Editor.Close;
    end;
  except
  Editor.Close;
  end;
end;

end.
