{DRAG N DROP TOOLBAR DEMONSTRATION PROGRAM

BY MR. KELLY YOUNG, MAINE COMPUTER GROUP: JUNE, 1995

THIS DEMO PROGRAM IS FREEWARE AND HAS ABSOLUTELY NO WARRANTY
OF ANY KIND, SHAPE, OR FORM, AND YOU, THE USER, ACCEPT FULL
RESPONSIBILITY FOR ITS USE!}

unit Teform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, ExtCtrls, StdCtrls, TBC;

type
  TEditor = class(TForm)
    SB1: TSpeedButton;
    SB2: TSpeedButton;
    Panel1: TPanel;
    OKBut: TBitBtn;
    SB3: TSpeedButton;
    Timer1: TTimer;
    procedure SB1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure Panel1DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure Panel1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure OKButClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Editor: TEditor;

implementation

uses    {in order to access the methods in the Main form, we need to add the unit to our uses}
Main;   {clause.  However, we can't put it up top of this unit, or we'll get a big fat error}

{$R *.DFM}


{IMPORTANT - Give this method to EVERY TOOLBAR BUTTON's OnMouseDown event on your Editor Window!}
procedure TEditor.SB1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  with sender as TSpeedButton do
  begin
  SendFromPool := true; {This button comes from the Editor, so don't let the user "Delete" it!}
  Working := false;     {We're not moving an existing (on the toolbar) button, either}
  BeginDrag(False);
  end;
end;


procedure TEditor.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ConfigTB := False;  {We're done editing, so make all button methods active}
  Working := False;   {We're not dragging an existing button, either}
  MainForm.SaveTB(Sender);{since we're done editing, SAVE THE TOOLBAR!}
  action := caFree;
end;

procedure TEditor.FormCreate(Sender: TObject);
begin
  SendFromPool := true; {set this switch to a default "button from editor" mode}
  ConfigTB := true;     {we're editing now, so disable all button methods}
  bordericons := bordericons - [biMaximize];
end;


procedure TEditor.OKButClick(Sender: TObject);
begin
  close;
end;


{In this demo, we used a plain old TPanel as our "garbage can" or "black hole" to delete
buttons off the toolbar.  You can use just about any component, as long as it has a
OnDragDrop event that you can access.}
procedure TEditor.Panel1DragDrop(Sender, Source: TObject; X, Y: Integer);
begin
  SendFromPool := true; {keep the default "button from Editor" mode}
  Working := false;     {reset this to "New button" mode}
  TSpeedButton(Source).visible := false; {make the button "disappear" from toolbar}
  TBChanged := true;    {we just deleted a button, the toolbar has CHANGED!}
end;

{This method will only allow buttons dragged from the Toolbar get dropped on our TPanel for deletion.
This prevents the rocket scientists of the world from "deleting" buttons from the Editor.}
procedure TEditor.Panel1DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  if SendFromPool = false then accept := true else accept := false;
end;


{This was the tricky part of this whole process.  We needed a way for a method that was outside
the TSpeedButton's realm to actually delete an invisible button from the toolbar.  Everything that
we tried using an event that in any way was associated with the TSpeedButton in question generated
an instant and profound GP Fault.  With this thing, every 1/2 second (settable by you to a
different time frame, but we recommend a very short time frame) the timer checks to see if
the toolbar has changed (which is set by the TPanels OnDragDrop event).  If the toolbar has
changed (meaning a button has been made invisible), within 1/2 second it triggers the Save Toolbar
method that is in the Main form.  Of course, the Save Toolbar method deletes all invisible buttons,
thereby allowing a rocket scientist user to put the same toolbar button back on the toolbar that
he/she just deleted, if he/she wants.  It works rather well.}
procedure TEditor.Timer1Timer(Sender: TObject);
begin
  if TBChanged = true then MainForm.SaveTB(Sender);
end;

end.
