Program Ddtest;

Uses WinCRT,
  Sysutils,
  DPMI {in '\DELPHI\COMMON\DPMI.PAS'},
  Drives {in '\DELPHI\COMMON\DRIVES.PAS'};

Type
	TypesArray = Array [TDriveTypes] Of String[ 11 ];
  DriveStateArray= Array [TDriveState] Of String[30];

Const
	TypeNames: TypesArray =
	  ( 'FLOPPY', 'HARDDISK','REMAPPED','REMOTE','CD_ROM',
      'RAMDISK', 'SUBSTITUTED', 'SHARED','INVALID' );
  DriveStates: DriveStateArray =
  ( 'DS_NO_DISK', 'DS_UNFORMATTED_DISK', 'DS_EMPTY_DISK',
    'DS_DISK_WITH_FILES' );
Var
	n: TDriveNums;
	Map: TDriveMap;
	first: Boolean;
	f: TDriveTypes;

Procedure WriteInfo( Const di: TDriveInfo );
	Begin
		If ([ INVALID, CD_ROM, FLOPPY ] * di.Flags ) = [] Then Begin
		  Write( '  ' );
			If not(REMOTE In di.Flags) Then Begin
			  WriteLn( 'Volumen Name: ', StrPas(@di.Info.VolName),
			           ', Serial-No.: ', Format('%p',[Pointer(di.Info.SerialNo)]),
			           ', FAT-Type: ', StrPas(@di.Info.FATType) );
			End { If }
			Else
			  WriteLn( 'Netshare: ', StrPas(@di.DevName));
		End; { If }
	End; { WriteInfo }

Function MediaType( n: Byte ): String;
Var
  s: String;
Begin
  Case GetUnitType(1) Of
     0: S := '320/360 KByte 5.25" floppy';
     1: S := '1,2 MByte 5.25" floppy';
     2: S := '720 KByte 3.5" floppy';
     3: S := '8" single density floppy';
     4: S := '8" double density floppy';
     5: S := 'fixed disk';
     6: S := 'tape';
     7: S := '1.44 MByte 3.5" floppy';
     8: S := 'read/write optical disk';
     9: S := '2.88 MByte 3.5" floppy';
     $FF: S := 'error in GetUnitType';
   Else
     S := 'Unknown unit type';
   end;
   MediaType := S;
End;

Begin
{$IFDEF WINDOWS}
  ScreenSize.Y := 300;
{$ENDIF}

  BuildDriveMap( Map );
	For n := Min_DriveNums To Max_DriveNums Do Begin
	  first := True;
		Write( 'Drive ',Chr( n+Ord( '@' ) ),': [' );
		For f := Low( TDriveTypes ) To High( TDriveTypes )  Do Begin
		  If f in Map[ n ].Flags Then Begin
			  If first Then
				  first := false
				Else
				  Write( ', ' );
				Write( TypeNames[ f ] );
		  End; { If }
		End; { For }
		WriteLn(']');
		WriteInfo( Map[ n ] );
	End; { For }
  WriteLn;
  WriteLn('State of drive A: is ', DriveStates[ DriveState( 1 )]);
  WriteLn('State of drive B: is ', DriveStates[ DriveState( 2 )]);
  WriteLn('State of drive F: is ', DriveStates[ DriveState( 6 )]);
  WriteLn('State of drive G: is ', DriveStates[ DriveState( 7 )]);
  WriteLn('Default media type of drive A: is ',
          Mediatype( 1 ));
  WriteLn('Default media type of drive B: is ',
          Mediatype( 2 ));
End.
