unit Editstat;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Grids, Valeurs;

const WM_Valid = WM_User +1;

type
  TEditStat = class(TEdit)
  private
    { Private-dclarations }
    FAfficheLie : TLabel;
    FChoices: TStrings;
    FTabPercent: string;
    procedure WMValid(var mess:TMessage); message WM_Valid;
    procedure WMKillFocus(var Mess: TCMExit); message CM_EXIT;
    procedure WMDblClick(var Mess: TMessage); message WM_LBUTTONDBLCLK;
    procedure AfficheElements(s:string);
  protected
    { Protected-dclarations }
    procedure SetChoices(Value: TStrings);
  public
    { Public-dclarations }
    DerChaineAcceptee, Liee: string;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published-dclarations }
    property TabPercentages: string read FTabPercent write FTabPercent;
    property StaticAffiche: TLabel read FAfficheLie write FAfficheLie;
    property Lines: TStrings read FChoices write SetChoices;
  end;

procedure Register;

implementation

constructor TEditStat.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FChoices := TStringList.Create;
  FAfficheLie := nil;
  DerChaineAcceptee := '';
  Liee := '';
end;

destructor TEditStat.Destroy;
begin
  FChoices.Free;
  inherited Destroy;
end;

procedure TEditStat.AfficheElements(s:string);
var i, postab1,postab2: integer;
begin
  postab1 := pos(chr(9),s);
  i:= postab1+1; postab2:=0;
  if postab1>1 then begin
    while (i<=length(s)) and (postab2=0) do begin
      if s[i]=chr(9) then postab2:=i;
      inc(i);
    end;
    Text := Copy(s,1,postab1-1);
    if postab2=0 then postab2 := length(s)+1;
    FAfficheLie.Caption := Copy(s,postab1+1,postab2-postab1-1);
  end else begin
    Text := s;
    FAfficheLie.Caption := '';
  end;
end;

procedure TEditStat.WMKillFocus(var Mess: TCMExit);
var i,ntrouve,der_trouve: integer;
begin
  inherited;
  if (FAfficheLie=nil) or (FChoices.Count=0) then begin exit; end;
  if Text='' then begin FAfficheLie.Caption := ''; exit; end;
  if Text=DerChaineAcceptee then begin FAfficheLie.Caption := Liee; exit; end;
  ntrouve := 0; der_trouve := 0;
  for i:=0 to FChoices.Count-1 do
    if pos(AnsiUpperCase(Text),AnsiUpperCase(FChoices[i]))=1
    then begin
      der_trouve := i;
      Inc(ntrouve);
    end;
  case ntrouve of
    0: begin
         Text := '';
         FAfficheLie.Caption := '';
         SetFocus;
       end;
    1: begin
         AfficheElements(FChoices[der_trouve]);
         DerChaineAcceptee := Text;
         Liee := FAfficheLie.Caption;
       end;
    else begin
      PostMessage(Handle,WM_Valid,0,0);
    end;
  end;
end;

procedure TEditStat.WMValid(var mess: TMessage);
var i, Renvoye: integer;
    Valeur: TValeurs;
    m:TMsg;
begin
  if (Focused) then exit;
  while GetCapture<>0 do begin
    if PeekMessage(m, GetCapture, 0, 0, PM_REMOVE) then begin
      TranslateMessage(m);
      DispatchMessage(m);
     end;
  end;
  Valeur := TValeurs.Create(Application);
  Valeur.Caption := Name;
  with Valeur do begin
    if FTabPercent<>'' then TabListBox1.TabPercentages := FTabPercent;
    TabListBox1.Items.Clear;
    for i:=0 to FChoices.Count-1 do
      if pos(AnsiUpperCase(Text),AnsiUpperCase(FChoices[i]))=1
      then TabListBox1.Items.Add(FChoices[i]);
    TabListBox1.ItemIndex := 0;
    Renvoye := ShowModal;
    if (Renvoye = IDOK) and (TabListBox1.ItemIndex>=0) then begin
      AfficheElements(Valeur.TabListBox1.Items[Valeur.TabListBox1.ItemIndex]);
    end;
  end;
  Valeur.Free;
  if Renvoye=IDOK then begin
    DerChaineAcceptee := Text;
    Liee := FAfficheLie.Caption;
  end
  else SetFocus;
end;

procedure TEditStat.WMDblClick(var mess: TMessage);
var Valeur: TValeurs;
    Renvoye: Integer;
begin
  Valeur := TValeurs.Create(Application);
  Valeur.Caption := Name;
  with Valeur do begin
    TabListBox1.Items.Clear;
    TabListBox1.Items := FChoices;
    if FTabPercent<>'' then TabListBox1.TabPercentages := FTabPercent;
    TabListBox1.ItemIndex := 0;
    Renvoye := ShowModal;
    if (Renvoye = IDOK) and (TabListBox1.ItemIndex>=0) then begin
      AfficheElements(Valeur.TabListBox1.Items[Valeur.TabListBox1.ItemIndex]);
      DerChaineAcceptee := Text;
      Liee := FAfficheLie.Caption;
    end;
  end;
  Valeur.Free;
end;

procedure TEditStat.SetChoices(Value: TStrings);
begin
  FChoices.Assign(Value);
end;

procedure Register;
begin
  RegisterComponents('Samples', [TEditStat]);
end;

end.
