unit Enhgrid;

interface

uses
  SysUtils, WinTypes, WinProcs,
  Messages, Classes, Graphics, Controls,
  buttons,  Forms, nav, Dialogs, Grids, DBGrids,
  extctrls, dbctrls, db, dbtables,
  dbiprocs, dbitypes,  dbierrs, stdctrls, enhds;

type
  TStatusTypes = (ssTable, ssRows, ssAccess, ssState, ssEof);
  TStatusSections = set of TStatusTypes;
  TDBEnhancedGrid = class(TPanel)
  private
    FStatus: THeader;
    FGrid: TDBGrid;
    FDataSource: TEnhancedsource;
    FDataset: TDataset;
    FRecordNumber: longint;
    FStatusSections: TStatusSections;
    procedure SetDataset(value: TDataset);
    procedure DataChange(sender: tobject; field: tfield);
    procedure TableIsClosed(DataSet: TDataset);
  protected
    function UniqueName(const Value: String):string;
  public
    constructor create(aowner: TComponent); override;
    destructor Destroy; override;
    procedure Loaded; override;
    procedure setStatusSections(Value: TStatusSections);
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    property RecordNumber: longint read FRecordNumber;

  published
     property Dataset: TDataset read FDataset write SetDataset;
     property StatusPanel: THeader read FStatus write FStatus;
     property Grid: TDBGrid read FGrid write FGrid;
     property StatusSections: TStatussections read FStatusSections write setStatusSections;

  end;
procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TDBEnhancedGrid]);
end;

constructor TDBEnhancedGrid.Create(AOwner: TComponent);
  begin
   inherited Create(AOwner);

   Height := 120;
   Width := 100;
   BevelInner := bvlowered;
   BevelOuter := bvraised;
   BorderStyle := bsSingle;
   BevelWidth := 1;
   BorderWidth := 1;

   FDataset := TDataset.create(self);
   with fdataset do
      AfterClose := TableIsClosed;

   FDatasource := TEnhancedsource.create(self);
   with fDataSource do begin
      OnDataChange := datachange;
      dataset := fdataset;
   end;

   if aowner.name = '' then exit;

   FStatus := THeader.Create(aowner);
   with Fstatus do begin
     Parent := Self;
     Visible := True;
     Height := 25;
     BorderStyle := bsSingle;
     Align := albottom;
     Name := UniqueName(ClassName);
   end;

   with tpanel.create(aowner) do begin
     Parent := Self;
     Visible := True;
     Left := 1;
     Top := 1;
     Height := 25;
     BorderStyle := bsSingle;
     Caption := 'Database Heading';
     Align := altop;
     Name := UniqueName(ClassName);
   end;

   with TDBNavigatorSpec.create(aowner) do begin
   Parent := Self;
   Visible := True;
   height := 20;
   Showhint := true;
   align := albottom;
   Name := UniqueName(ClassName);
   datasource := fdatasource;
   end;

   fgrid := tdbgrid.create(aowner);
   With FGrid do begin
     Parent := Self;
     Parentcolor := true;
     Parentctl3d := true;
     Visible := True;
     Height := 100;
     BorderStyle := bsSingle;
     Align := alclient;
     datasource := fdatasource;
     Name := UniqueName(ClassName);
   end;
 end;

 procedure TDBEnhancedGrid.Loaded;
 var
 i,n: longint;
 begin
  Inherited Loaded;
  n := ControlCount -1;
  for i := 0 to n do
     if Controls[i] is TDBNavigatorSpec then
       TDBNavigatorSpec(controls[i]).datasource := fdatasource
     else
      if Controls[i] is TDBGrid then
       TDBGrid(Controls[i]).Datasource := fDatasource;
 end;

 procedure TDBEnhancedGrid.Notification(AComponent: TComponent; Operation: TOperation);
 begin
  Inherited Notification(AComponent, Operation);
  if Operation = opRemove then begin
    if AComponent = fDataset then
      fDataset := nil;

    if acomponent = fstatus then
       fstatus := nil;

    if acomponent = fgrid then
       fgrid := nil;
 end;
 end;

 destructor TDBEnhancedGrid.destroy;
 begin
   FDatasource.free;
   inherited destroy;
 end;

 function tdbEnhancedGrid.UniqueName(const Value: String):string;
var
 i: integer;
 a: string[4];

begin
  Result := copy(Value,2,255);
  a := '1';
  i := 1;
  while true do
   if owner.findcomponent(Result+a)=nil then begin
    Result := Result+a;
    break;
    end
   else begin
    inc(i);
    a := inttostr(i);
    end;
end;



procedure tdbEnhancedGrid.datachange(sender: tobject; field: Tfield);

begin
if fstatus = nil then exit;
fdatasource.updatestatus;
frecordnumber := fdatasource.getrownumber;
fstatus.sections.clear;
if sstable in fstatusSections then
   fstatus.sections.add(fdatasource.tablename);
if ssrows in fstatussections then
   fstatus.sections.add(fdatasource.rowstatus);
if ssaccess in fstatussections then
   fstatus.sections.add(fdatasource.fileaccess);
if ssstate in fstatussections then
   fstatus.sections.add(fdatasource.filestate);
if sseof in fstatussections then
   fstatus.sections.add(fdatasource.eofbof);
end;

procedure tdbEnhancedGrid.setdataset(Value: TDataset);
begin
   if fdataset <> value then begin
      fdataset := value;
      if value <> nil then
       if not fdataset.active then
         fdataset.active := true;
   fdatasource.dataset := fdataset;
   fdataset.AfterClose := TableIsClosed;
   end;
end;
procedure tdbEnhancedGrid.TableIsClosed(DataSet: TDataset);
begin
if Fstatus = nil then exit;
FStatus.sections.clear;  {Clear by itself doesn't clear header}
fstatus.sections.add(' ');
frecordnumber := 0;
end;
procedure tdbEnhancedGrid.setStatusSections(Value: TStatusSections);
begin
FstatusSections := value;
if fstatus <> nil then begin
  fstatus.sections.clear;
  fstatus.sections.add(' ');
end;
datachange(nil, nil);
end;


end.
