{ ErrList - Copyright 1995 Robert Arnson }

program ErrList;

uses DbiTypes, DbiProcs, DbiErrs, SysUtils;

var
  Category: byte;
  Code: byte;
  ResultCode: word;
  ErrorString: array[0..DBIMAXMSGLEN + 1] of char;
  Output: text;
  OutString: string;

begin
  DbiInit(nil);

  Assign(Output, 'ErrList.Txt');
  Rewrite(Output);

  for Category := ERRCAT_NONE to ERRCAT_RC do
    for Code := 0 to 255 do
    begin
      ResultCode := (Category shl 8) + Code;
      DbiGetErrorString(ResultCode, ErrorString);
      if StrLen(ErrorString) > 0 then
      begin
        OutString := Format('%6d  %0.4x  %s', [ResultCode, ResultCode, ErrorString]);
        WriteLn(Output, OutString);
      end;
    end;

  DbiExit;
end.
