unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DB, FileCtrl, DBTables, Gauges, ExtCtrls,
  Status;

type
  TFrmMain = class(TForm)
    CBDatabase: TComboBox;
    Label1: TLabel;
    LBTable: TListBox;
    Label2: TLabel;
    LBDir: TDirectoryListBox;
    BtnExport: TButton;
    EdFile: TEdit;
    DriveComboBox1: TDriveComboBox;
    Label3: TLabel;
    Table: TTable;
    Progress: TGauge;
    Status1: TStatus;
    procedure FormCreate(Sender: TObject);
    procedure CBDatabaseChange(Sender: TObject);
    procedure LBTableClick(Sender: TObject);
    procedure BtnExportClick(Sender: TObject);
    procedure EdFileChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmMain: TFrmMain;

implementation
{$R *.DFM}

procedure TFrmMain.FormCreate(Sender: TObject);
begin
 Session.GetDatabaseNames(CBDatabase.Items);
end;

procedure TFrmMain.CBDatabaseChange(Sender: TObject);
begin
 Session.GetTableNames(CBDatabase.Items[CBDatabase.ItemIndex], '', True, False,
                       LBTable.Items);
end;

procedure TFrmMain.LBTableClick(Sender: TObject);
begin
 if EdFile.Text <> '' then BtnExport.Enabled := true;
end;

procedure TFrmMain.BtnExportClick(Sender: TObject);
const
 NoExport : set of TFieldType = [ftUnknown, ftBlob, ftMemo, ftGraphic];
var
 rec : longint;
 i,j : integer;
 out : textfile;
 tbl : TFileName;
 ff  : boolean;
 tmp : string;
begin
 if EdFile.Text = '' then
 begin
  MessageDlg('Define filename.', mtError, [mbOK], 0);
  Abort;
 end;
 Table.DatabaseName := CBDatabase.Items[CBDatabase.ItemIndex];
 Table.TableName    := LBTable.Items[LBTable.ItemIndex];
 Table.Open;
 AssignFile(out, LBDir.Directory + '\' + EdFile.Text);
 Rewrite(out);
 tbl := Table.TableName;
 Delete(tbl, Pos('.', tbl), length(tbl));
 Progress.MinValue := 1;
 Progress.MaxValue := Table.RecordCount;
 Progress.Progress := 1;
 Progress.Show;
 with Table do
 begin
  for rec := 1 to RecordCount do
  begin
   Write(out, 'INSERT INTO ', tbl, '(');
   ff := false;
   for i:=0 to FieldCount - 1 do
   begin
    if not (Fields[i].DataType in NoExport) then
    begin
     if ff then Write(out, ',');
     Write(out, Fields[i].FieldName);
     ff := true;
    end;
   end;
   Write(out, ') VALUES (');
   ff := false;
   for i:=0 to FieldCount - 1 do
   begin
    if not (Fields[i].DataType in NoExport) then
    begin
     if ff then Write(out, ',');
     tmp := Fields[i].AsString;
     for j:=1 to length(tmp) do
      if tmp[j]=#39 then
      begin
       System.Insert(#39, tmp, j);
       j := j + 1;
      end;
     Write(out, #39, tmp , #39);
     ff := true;
    end;
   end;
   WriteLn(out, ');');
   Progress.Progress := rec;
   Next;
  end;
 end;
 Progress.Hide;
 Table.Close;
 CloseFile(out);
 EdFile.Text := '';
end;

procedure TFrmMain.EdFileChange(Sender: TObject);
begin
 if LBTable.ItemIndex <> -1 then BtnExport.Enabled := true;
 if EdFile.Text = '' then BtnExport.Enabled := false;
end;

end.
