program DTstBtre;
  {Test program for binary trees: normal, search and redblack}

{ Undefine this if you don't want debugging info or assertion checks }
{$DEFINE DEBUG}

{ Check for Delphi }
{$IFNDEF VER80}
!! Error - this unit is for Delphi only
{$ENDIF}

{$define bintree}     {define to test binary trees}
{.$define bstree}     {define to test binary search trees}
{.$define rbtree}     {define to test red black trees}

{------Changeable compiler switches-----------------------------------}
{$A+   Word align variables }
{$F+   Force Far calls }
{$K+   Use smart callbacks
{$N+   Allow coprocessor instructions }
{$P+   Open parameters enabled }
{$Q+   No integer overflow checking }
{$R+   No range checking }
{$S+   No stack checking }
{$T-   @ operator is NOT typed }
{---------------------------------------------------------------------}


{------Fixed compiler switches----------------------------------------}
{$B-   Short-circuit boolean expressions }
{$G+   80286+ type instructions }
{$I+   I/O checking via exceptions }
{$V-   Disable var string checking }
{$W-   No Windows realmode stack frame }
{$X+   Enable extended syntax }
{$IFDEF DEBUG}
{$D+,L+,Y+  Enable debug information }
{$ELSE}
{$D-,L-,Y-  Disable debug information }
{$ENDIF}
{---------------------------------------------------------------------}

uses
  SysUtils,
  EZDSLCts in 'EZDSLCTS.PAS',
  EZDSLBse in 'EZDSLBSE.PAS',
  EZDSLBtr in 'EZDSLBTR.PAS',
  EZDSLSup in 'EZDSLSUP.PAS',
  WinProcs,
  WinTypes,
  WinCrt;

function RandomStr(Len : byte) : string;
  var
    i : integer;
  begin
    for i := 1 to Len do
      Result[i] := char(Random(26) + ord('A'));
    Result[0] := char(Len);
  end;

function NumToName(i : integer) : string;
  const
    NumNames : array [0..10] of string[5] =
               ('zero', 'one', 'two', 'three', 'four', 'five',
                'six', 'seven', 'eight', 'nine', 'ten');
  begin
    if (i < 0) then
      Result := 'LessThanZero'
    else if (i > 10) then
      Result := 'BigNumber'
    else
      Result := NumNames[i];
  end;

function PrintStrs(C : TAbstractContainer;
                   aData : pointer;
                   ExtraData : pointer) : boolean; far;
  var
    F : ^text absolute ExtraData;
    S : PString absolute aData;
  begin
    Result := true;
    writeln(F^, S^);
  end;

function AlterStrs(C : TAbstractContainer;
                   aData : pointer;
                   ExtraData : pointer) : boolean; far;
  var
    S : PString absolute aData;
  begin
    Result := true;
    S^[length(S^)] := 'z';
  end;

const
  InsertSeq : string [79] = 'titlitritllitlritrlitrritlllitllritrrri';

type
  {$ifdef bintree}
  TMyTree = TBinTree;
  {$endif}
  {$ifdef bstree}
  TMyTree = TBinSearchTree;
  {$endif}
  {$ifdef rbtree}
  TMyTree = TrbSearchTree;
  {$endif}

var
  P : pointer;
  Tree, NewTree : TMyTree;
  i, j : integer;
  S : PString;
  Walker : TTreeCursor;
  StartMem  : longint;
  C : char;
  F : text;
  SavedS : string;

begin
  {make sure there's a new heap block}
  GetMem(P, 8);

  InitWinCrt;
  writeln('Starting tests');

  StartMem := MemAvail;

  Tree := nil;

  Assign(F, 'TEST.LOG');
  Rewrite(F);
  try
    writeln(F, 'First test: insertion into a tree, iterating');
    Tree := TMyTree.Create(true);
    with Tree do
      begin
        Compare := EZStrCompare;
        DupData := EZStrDupData;
        DisposeData := EZStrDisposeData;
        j := 0;
        for i := 1 to length(InsertSeq) do
          case InsertSeq[i] of
            't' : Walker := Root;
            'l' : if not IsLeaf(Walker) then
                    Walker := Left(Walker);
            'r' : if not IsLeaf(Walker) then
                    Walker := Right(Walker);
            'i' : begin
                    inc(j);
                    Insert(Walker, NewStr(NumToName(j)));
                  end;
          end;{case}
        writeln(F, 'Pushed strings, now iterating...');
        writeln(F, '..preorder..');
        TraversalType := ttPreOrder;
        Iterate(PrintStrs, false, @F);
        writeln(F, '..inorder..');
        TraversalType := ttInOrder;
        Iterate(PrintStrs, false, @F);
        writeln(F, '..postorder..');
        TraversalType := ttPostOrder;
        Iterate(PrintStrs, false, @F);
        writeln(F, '..levelorder..');
        TraversalType := ttLevelOrder;
        Iterate(PrintStrs, false, @F);
        writeln(F, '..preorder reversed..');
        TraversalType := ttPreOrder;
        Iterate(PrintStrs, true, @F);
        writeln(F, '..inorder reversed..');
        TraversalType := ttInOrder;
        Iterate(PrintStrs, true, @F);
        writeln(F, '..postorder reversed..');
        TraversalType := ttPostOrder;
        Iterate(PrintStrs, true, @F);
        writeln(F, '..levelorder reversed..');
        TraversalType := ttLevelOrder;
        Iterate(PrintStrs, true, @F);
      end;

    writeln(F, 'Second test: deletion');
    with Tree do
      begin
        Walker := Root;
        while not IsLeaf(Walker) do
          Walker := Right(Walker);
        Walker := Parent(Walker);
        Erase(Walker);
        writeln(F, '..preorder..');
        TraversalType := ttPreOrder;
        Iterate(PrintStrs, false, @F);
        writeln(F, '..inorder..');
        TraversalType := ttInOrder;
        Iterate(PrintStrs, false, @F);
        writeln(F, '..postorder..');
        TraversalType := ttPostOrder;
        Iterate(PrintStrs, false, @F);
        writeln(F, '..levelorder..');
        TraversalType := ttLevelOrder;
        Iterate(PrintStrs, false, @F);
        Walker := Root;
        while not IsLeaf(Walker) do
          Walker := Left(Walker);
        Walker := Parent(Walker);
        Erase(Walker);
        writeln(F, '..preorder..');
        TraversalType := ttPreOrder;
        Iterate(PrintStrs, false, @F);
        writeln(F, '..inorder..');
        TraversalType := ttInOrder;
        Iterate(PrintStrs, false, @F);
        writeln(F, '..postorder..');
        TraversalType := ttPostOrder;
        Iterate(PrintStrs, false, @F);
        writeln(F, '..levelorder..');
        TraversalType := ttLevelOrder;
        Iterate(PrintStrs, false, @F);
        Walker := Root;
        while not IsLeaf(Walker) do
          Walker := Right(Walker);
        Walker := Parent(Walker);
        Erase(Walker);
        writeln(F, '..preorder..');
        TraversalType := ttPreOrder;
        Iterate(PrintStrs, false, @F);
        writeln(F, '..inorder..');
        TraversalType := ttInOrder;
        Iterate(PrintStrs, false, @F);
        writeln(F, '..postorder..');
        TraversalType := ttPostOrder;
        Iterate(PrintStrs, false, @F);
        writeln(F, '..levelorder..');
        TraversalType := ttLevelOrder;
        Iterate(PrintStrs, false, @F);
      end;

    writeln(F, 'Third test: cloning');
    Tree.Empty;
    with Tree do
      begin
        j := 0;
        for i := 1 to length(InsertSeq) do
          case InsertSeq[i] of
            't' : Walker := Root;
            'l' : if not IsLeaf(Walker) then
                    Walker := Left(Walker);
            'r' : if not IsLeaf(Walker) then
                    Walker := Right(Walker);
            'i' : begin
                    inc(j);
                    Insert(Walker, NewStr(NumToName(j)));
                  end;
          end;{case}
        NewTree := TMyTree.Clone(Tree, true, EZStrCompare);
        writeln(F, '..clone preorder..');
        NewTree.TraversalType := ttPreOrder;
        NewTree.Iterate(PrintStrs, false, @F);
        writeln(F, '..clone inorder..');
        NewTree.TraversalType := ttInOrder;
        NewTree.Iterate(PrintStrs, false, @F);
        writeln(F, '..clone postorder..');
        NewTree.TraversalType := ttPostOrder;
        NewTree.Iterate(PrintStrs, false, @F);
        writeln(F, '..clone levelorder..');
        NewTree.TraversalType := ttLevelOrder;
        NewTree.Iterate(PrintStrs, false, @F);
      end;

    writeln(F, 'Fourth test: joining');
    with Tree do
      begin
        {$ifdef bintree}
        Walker := left(right(left(root)));
        {$endif}
        NewTree.Iterate(AlterStrs, false, nil);
        Join(Walker, NewTree);
        writeln(F, '..preorder..');
        TraversalType := ttPreOrder;
        Iterate(PrintStrs, false, @F);
        writeln(F, '..inorder..');
        TraversalType := ttInOrder;
        Iterate(PrintStrs, false, @F);
        writeln(F, '..postorder..');
        TraversalType := ttPostOrder;
        Iterate(PrintStrs, false, @F);
        writeln(F, '..levelorder..');
        TraversalType := ttLevelOrder;
        Iterate(PrintStrs, false, @F);
      end;
    writeln(F, '..complete');

  finally
    Tree.Free;

    writeln(F, 'Memory - Start: ', StartMem);
    writeln(F, '           End: ', MemAvail);

    Close(F);
  end;

  writeln('Tests complete, TEST.LOG file created, press any key');
  C := ReadKey;
  DoneWinCrt;
  FreeMem(P, 8);
end.

