program Dtstlist;
  {Test program for lists: single, double and skip lists}

{.$Define Sorted}

{.$DEFINE DList}
{$IFDEF DList}
{$DEFINE SkipList}
{$ENDIF}

{$IFDEF SkipList}
{$Define Sorted}
{$ENDIF}

{ Undefine this if you don't want debugging info or assertion checks }
{$DEFINE DEBUG}

{ Check for Delphi }
{$IFNDEF VER80}
!! Error - this program is for Delphi only
{$ENDIF}

{------Changeable compiler switches-----------------------------------}
{$A+   Word align variables }
{$F+   Force Far calls }
{$K+   Use smart callbacks
{$N+   Allow coprocessor instructions }
{$P+   Open parameters enabled }
{$Q+   No integer overflow checking }
{$R+   No range checking }
{$S+   No stack checking }
{$T-   @ operator is NOT typed }
{---------------------------------------------------------------------}


{------Fixed compiler switches----------------------------------------}
{$B-   Short-circuit boolean expressions }
{$G+   80286+ type instructions }
{$I+   I/O checking via exceptions }
{$V-   Disable var string checking }
{$W-   No Windows realmode stack frame }
{$X+   Enable extended syntax }
{$IFDEF DEBUG}
{$D+,L+,Y+  Enable debug information }
{$ELSE}
{$D-,L-,Y-  Disable debug information }
{$ENDIF}
{---------------------------------------------------------------------}

uses
  SysUtils,
  EZDSLCts in 'EZDSLCTS.PAS',
  EZDSLBse in 'EZDSLBSE.PAS',
  EZDSLLst in 'EZDSLLST.PAS',
  EZDSLDbl in 'EZDSLDBL.PAS',
  EZDSLSkp in 'EZDSLSKP.PAS',
  EZDSLSup in 'EZDSLSUP.PAS',
  WinProcs,
  WinTypes,
  WinCrt;

function RandomStr(Len : byte) : string;
  var
    i : integer;
  begin
    for i := 1 to Len do
      Result[i] := char(Random(26) + ord('A'));
    Result[0] := char(Len);
  end;

function NumToName(i : integer) : string;
  const
    NumNames : array [0..10] of string[5] =
               ('zero', 'one', 'two', 'three', 'four', 'five',
                'six', 'seven', 'eight', 'nine', 'ten');
  begin
    if (i < 0) then
      Result := 'LessThanZero'
    else if (i > 10) then
      Result := 'BigNumber'
    else
      Result := NumNames[i];
  end;

function PrintStrs(C : TAbstractContainer;
                   aData : pointer;
                   ExtraData : pointer) : boolean; far;
  var
    F : ^text absolute ExtraData;
    S : PString absolute aData;
  begin
    Result := true;
    writeln(F^, S^);
  end;

type
{$IFDEF DList}
{$IFDEF SkipList}
  TMyList = class(TSkipList);
{$ELSE}
  TMyList = class(TDList);
{$ENDIF}
{$ELSE}
  TMyList = class(TLinkList);
{$ENDIF}

var
  i : word;
  List, NewList : TMyList;
  S : PString;
  StartMem  : longint;
  Cursor    : TListCursor;
  C : char;
  F : text;
  P : pointer;
begin
  {make sure there's a new heap block}
  GetMem(P, 8);

  InitWinCrt;

  StartMem := MemAvail;

  Assign(F, 'TEST.LOG');
  Rewrite(F);
  try
    {$IFDEF Sorted}
    writeln(F, 'Tests with a sorted list');
    {$ELSE}
    writeln(F, 'Tests with a non-sorted list');
    {$ENDIF}

    writeln(F, 'First test: insertion and deletion from a list');
    List := TMyList.Create(true);
    with List do
      begin
        Compare := EZStrCompare;
        DupData := EZStrDupData;
        DisposeData := EZStrDisposeData;
        for i := 1 to 10 do
          {$IFDEF Sorted}
          {$IFDEF SkipList}
          Insert(Cursor, NewStr(NumToName(i)));
          {$ELSE}
          InsertSorted(NewStr(NumToName(i)));
          {$ENDIF}
          {$ELSE}
          {$IFDEF DList}
          InsertAfter(SetBeforeFirst, NewStr(NumToName(i)));
          {$ELSE}
          InsertAfter(NewStr(NumToName(i)));
          {$ENDIF}
          {$ENDIF}
        writeln(F, '-orig list');
        Iterate(PrintStrs, false, @F);
        writeln(F, '-after deletion of last, third from last');
        {$IFDEF DList}
        Cursor := Prev(SetAfterLast);
        Cursor := Erase(Cursor);
        Cursor := Prev(Prev(SetAfterLast));
        Cursor := Erase(Cursor);
        {$ELSE}
        SetAfterLast;
        Prev;
        Erase;
        SetAfterLast;
        Prev; Prev;
        Erase;
        {$ENDIF}
        Iterate(PrintStrs, false, @F);
        writeln(F, '-after Empty');
        {$IFDEF SkipList}
        Cursor := Next(SetBeforeFirst);
        while not IsAfterLast(Cursor) do
          Cursor := Erase(Cursor);
        {$ELSE}
        Empty;
        {$ENDIF}
        Iterate(PrintStrs, false, @F);
        {$IFNDEF DList}
        SetBeforeFirst;
        {$ENDIF}
        writeln(F, '---end of test 1---');
      end;

    writeln(F, 'Second test: cloning, splitting and joining');
    with List do
      begin
        for i := 1 to 5 do
          {$IFDEF Sorted}
          {$IFDEF SkipList}
          Insert(Cursor, NewStr(NumToName(i)));
          {$ELSE}
          InsertSorted(NewStr(NumToName(i)));
          {$ENDIF}
          {$ELSE}
          {$IFDEF DList}
          InsertAfter(SetBeforeFirst, NewStr(NumToName(i)));
          {$ELSE}
          InsertAfter(NewStr(NumToName(i)));
          {$ENDIF}
          {$ENDIF}
        writeln(F, '-orig list before clone');
        Iterate(PrintStrs, false, @F);
        writeln(F, '-new list after clone');
        NewList := TMyList.Clone(List, true, EZStrCompare);
        NewList.Iterate(PrintStrs, false, @F);
        NewList.Free;
        {$IFDEF DList}
        Cursor := Next(Next(Next(SetBeforeFirst)));
        NewList := TMyList(Split(Cursor));
        {$ELSE}
        SetBeforeFirst;
        Next; Next; Next;
        NewList := TMyList(Split);
        {$ENDIF}
        writeln(F, '-orig list after split');
        Iterate(PrintStrs, false, @F);
        writeln(F, '-new list after split');
        NewList.Iterate(PrintStrs, false, @F);
        {$IFDEF DList}
        Cursor := SetBeforeFirst;
        {$IFDEF SkipList}
        Join(NewList);
        {$ELSE}
        Join(Cursor, NewList);
        {$ENDIF}
        {$ELSE}
        SetBeforeFirst;
        Join(NewList);
        {$ENDIF}
        writeln(F, '-orig list after join');
        Iterate(PrintStrs, false, @F);
        writeln(F, '---end of test 2---');
      end;

    writeln(F, 'Third test: various basic iteration tests');
    with List do
      begin
        {$IFDEF DList}
        writeln(F, '-first element');
        Cursor := Next(SetBeforeFirst);
        writeln(F, PString(Examine(Cursor))^);
        writeln(F, '-last element');
        Cursor := Prev(SetAfterLast);
        writeln(F, PString(Examine(Cursor))^);
        writeln(F, '-moving forward');
        Cursor := Next(SetBeforeFirst);
        while not IsAfterLast(Cursor) do
          begin
            writeln(F, PString(Examine(Cursor))^);
            Cursor := Next(Cursor);
          end;
        writeln(F, '-moving backwards');
        Cursor := Prev(Cursor);
        while not IsBeforeFirst(Cursor) do
          begin
            writeln(F, PString(Examine(Cursor))^);
            Cursor := Prev(Cursor);
          end;
        {$ELSE}
        writeln(F, '-first element');
        SetBeforeFirst;
        Next;
        writeln(F, PString(Examine)^);
        writeln(F, '-last element');
        SetAfterLast;
        Prev;
        writeln(F, PString(Examine)^);
        writeln(F, '-moving forward');
        SetBeforeFirst;
        Next;
        while not IsAfterLast do
          begin
            writeln(F, PString(Examine)^);
            Next;
          end;
        writeln(F, '-moving backwards');
        Prev;
        while not IsBeforeFirst do
          begin
            writeln(F, PString(Examine)^);
            Prev;
          end;
        {$ENDIF}
        writeln(F, '---end of test 3---');
      end;

    writeln(F, 'Fourth test: miscellaneous');
    with List do
      begin
        writeln(F, 'Replace');
        {$IFDEF DList}
        Cursor := Next(SetBeforeFirst);
        S := PString(Replace(Cursor, NewStr(NumToName(6))));
        {$ELSE}
        SetBeforeFirst;
        Next;
        S := PString(Replace(NewStr(NumToName(6))));
        {$ENDIF}
        writeln(F, '-replaced ', S^);
        DisposeStr(S);
        Iterate(PrintStrs, false, @F);

        Empty;
        writeln(F, '---end of test 4---');
      end;

  finally
    List.Free;

    writeln(F, 'Memory - Start: ', StartMem);
    writeln(F, '           End: ', MemAvail);

    Close(F);
  end;

  writeln('Tests complete, TEST.LOG file created, press any key');
  C := ReadKey;
  DoneWinCrt;
  FreeMem(P, 8);
end.