program DTstStak;
  {Test program for stacks, queues, deques, and priority queues}

{ Undefine this if you don't want debugging info or assertion checks }
{$DEFINE DEBUG}

{ Check for Delphi }
{$IFNDEF VER80}
!! Error - this unit is for Delphi only
{$ENDIF}

{------Changeable compiler switches-----------------------------------}
{$A+   Word align variables }
{$F+   Force Far calls }
{$K+   Use smart callbacks
{$N+   Allow coprocessor instructions }
{$P+   Open parameters enabled }
{$Q+   No integer overflow checking }
{$R+   No range checking }
{$S+   No stack checking }
{$T-   @ operator is NOT typed }
{---------------------------------------------------------------------}


{------Fixed compiler switches----------------------------------------}
{$B-   Short-circuit boolean expressions }
{$G+   80286+ type instructions }
{$I+   I/O checking via exceptions }
{$V-   Disable var string checking }
{$W-   No Windows realmode stack frame }
{$X+   Enable extended syntax }
{$IFDEF DEBUG}
{$D+,L+,Y+  Enable debug information }
{$ELSE}
{$D-,L-,Y-  Disable debug information }
{$ENDIF}
{---------------------------------------------------------------------}

uses
  SysUtils,
  EZDSLCts in 'EZDSLCTS.PAS',
  EZDSLBse in 'EZDSLBSE.PAS',
  EZDSLStk in 'EZDSLSTK.PAS',
  EZDSLQue in 'EZDSLQUE.PAS',
  EZDSLPqu in 'EZDSLPQU.PAS',
  EZDSLSup in 'EZDSLSUP.PAS',
  WinProcs,
  WinTypes,
  WinCrt;

function RandomStr(Len : byte) : string;
  var
    i : integer;
  begin
    for i := 1 to Len do
      Result[i] := char(Random(26) + ord('A'));
    Result[0] := char(Len);
  end;

function NumToName(i : integer) : string;
  const
    NumNames : array [0..10] of string[5] =
               ('zero', 'one', 'two', 'three', 'four', 'five',
                'six', 'seven', 'eight', 'nine', 'ten');
  begin
    if (i < 0) then
      Result := 'LessThanZero'
    else if (i > 10) then
      Result := 'BigNumber'
    else
      Result := NumNames[i];
  end;

var
  P : pointer;
  Stack, NewStack : TStack;
  Queue, NewQueue : TQueue;
  DeQue, NewDeQue : TDeQue;
  PrQueue, NewPrQueue : TPriorityQueue;
  i : integer;
  S : PString;
  StartMem  : longint;
  C : char;
  F : text;
  SavedS : string;

begin
  {make sure there's a new heap block}
  GetMem(P, 8);

  InitWinCrt;
  writeln('Starting tests');

  StartMem := MemAvail;

  Stack := nil;
  Queue := nil;

  Assign(F, 'TEST.LOG');
  Rewrite(F);
  try
    writeln(F, 'First test: insertion and deletion from a stack');
    Stack := TStack.Create(true);
    with Stack do
      begin
        Compare := EZStrCompare;
        DupData := EZStrDupData;
        DisposeData := EZStrDisposeData;
        for i := 1 to 10 do
          Push(NewStr(NumToName(i)));
        writeln(F, 'Pushed 10 strings, popping them all...');
        while not IsEmpty do
          begin
            S := PString(Pop);
            writeln(F, S^);
            DisposeStr(S);
          end;
      end;

    writeln(F, 'Second test: cloning');
    with Stack do
      begin
        for i := 1 to 10 do
          Push(NewStr(NumToName(i)));
        NewStack := TStack.Clone(Stack, true, Compare);
        writeln(F, 'Popping the first 5 strings from the new stack...');
        for i := 1 to 5 do
          begin
            S := PString(NewStack.Pop);
            writeln(F, S^);
            DisposeStr(S);
          end;
        NewStack.Free;
      end;

    writeln(F, 'Third test: insertion and deletion from a queue');
    Queue := TQueue.Create(true);
    with Queue do
      begin
        Compare := EZStrCompare;
        DupData := EZStrDupData;
        DisposeData := EZStrDisposeData;
        for i := 1 to 10 do
          Append(NewStr(NumToName(i)));
        writeln(F, 'Appended 10 strings, popping them all...');
        while not IsEmpty do
          begin
            S := PString(Pop);
            writeln(F, S^);
            DisposeStr(S);
          end;
      end;

    writeln(F, 'Fourth test: cloning');
    with Queue do
      begin
        for i := 1 to 10 do
          Append(NewStr(NumToName(i)));
        NewQueue := TQueue.Clone(Queue, true, Compare);
        writeln(F, 'Popping the first 5 strings from the new queue...');
        for i := 1 to 5 do
          begin
            S := PString(NewQueue.Pop);
            writeln(F, S^);
            DisposeStr(S);
          end;
        NewQueue.Free;
      end;

    writeln(F, 'Fifth test: insertion and deletion from a deque');
    DeQue := TDeQue.Create(true);
    with DeQue do
      begin
        Compare := EZStrCompare;
        DupData := EZStrDupData;
        DisposeData := EZStrDisposeData;
        for i := 1 to 5 do
          Append(NewStr(NumToName(i)));
        for i := 6 to 10 do
          Push(NewStr(NumToName(i)));
        writeln(F, 'Added 10 strings, popping them all...');
        while not IsEmpty do
          begin
            S := PString(Pop);
            writeln(F, S^);
            DisposeStr(S);
          end;
      end;

    writeln(F, 'Sixth test: cloning');
    with DeQue do
      begin
        for i := 1 to 10 do
          Append(NewStr(NumToName(i)));
        NewDeQue := TDeQue.Clone(DeQue, true, Compare);
        writeln(F, 'Popping the first 5 strings from the new deque...');
        for i := 1 to 5 do
          begin
            S := PString(NewDeQue.Pop);
            writeln(F, S^);
            DisposeStr(S);
          end;
        NewDeQue.Free;
      end;

    writeln(F, 'Seventh test: insertion and deletion from a priority queue');
    PrQueue := TPriorityQueue.Create(true);
    with PrQueue do
      begin
        Compare := EZStrCompare;
        DupData := EZStrDupData;
        DisposeData := EZStrDisposeData;
        for i := 1 to 10 do
          Append(NewStr(NumToName(i)));
        writeln(F, 'Appended 10 strings, popping them all...');
        while not IsEmpty do
          begin
            S := PString(Pop);
            writeln(F, S^);
            DisposeStr(S);
          end;
      end;

    writeln(F, 'Eighth test: cloning');
    with PrQueue do
      begin
        for i := 1 to 10 do
          Append(NewStr(NumToName(i)));
        NewPrQueue := TPriorityQueue.Clone(PrQueue, true, Compare);
        writeln(F, 'Popping the first 5 strings from the new priority queue...');
        for i := 1 to 5 do
          begin
            S := PString(NewPrQueue.Pop);
            writeln(F, S^);
            DisposeStr(S);
          end;
        NewPrQueue.Free;
      end;

    writeln(F, 'Ninth test: megatest');
    writeln('Please  wait: starting megatest');
    with PrQueue do
      begin
        for i := 1 to 30000 do
          begin
            SavedS := RandomStr(10+Random(15));
            Append(NewStr(SavedS));
          end;
        SavedS := '';
        while not IsEmpty do
          begin
            S := PString(Pop);
            if (SavedS > S^) then
              writeln('sequence error');
            SavedS := S^;
            DisposeStr(S);
          end;
      end;
    writeln(F, '..complete');


  finally
    Stack.Free;
    Queue.Free;
    DeQue.Free;
    PrQueue.Free;

    writeln(F, 'Memory - Start: ', StartMem);
    writeln(F, '           End: ', MemAvail);

    Close(F);
  end;

  writeln('Tests complete, TEST.LOG file created, press any key');
  C := ReadKey;
  DoneWinCrt;
  FreeMem(P, 8);
end.
