program EXStrStk;
  {-Example program to show how to use a string stack}

uses
  SysUtils,
  WinCrt,
  EZDSLSup,
  EZStrStk;

var
  Stk : TStringStack;
  StartMem : longint;
  i   : integer;
  S   : string;
  P   : pointer;
  C   : char;

begin
  GetMem(P, 8);

  Stk := nil;
  InitWinCrt;
  Writeln('String stack test');

  try
    {initialise the stack}
    writeln('Creating the string stack');
    Stk := TStringStack.Create;

    {push some strings onto the stack}
    writeln('Pushing 10 strings');
    for i := 1 to 10 do
      begin
        Str(i, S);
        Stk.Push(S);
      end;

    {pop the strings off, and write them out}
    writeln('Popping 10 strings');
    for i := 1 to 10 do
      writeln(Stk.Pop);

  finally
    {destroy the stack}
    Stk.Free;
  end;

  writeln('Tests complete, press any key');
  C := ReadKey;
  DoneWinCrt;
  FreeMem(P, 8);
end.
