{===EZDSLSUP==========================================================

Part of the Delphi Structures Library--supplementary routines.

EZDSLSUP is  Copyright (c) 1993, 1995 by  Julian M. Bucknall

VERSION HISTORY
18Jun95 JMB 1.00 conversion of EZStrucs to Delphi
======================================================================}
{ Copyright (c) 1993, 1995, Julian M. Bucknall. All Rights Reserved   }

unit EZDSLSup;

{Declare the compiler defines}
{$I EZDSLDEF.INC}

{------Changeable compiler switches-----------------------------------}
{$A+   Word align variables }
{$F+   Force Far calls }
{$K+   Use smart callbacks
{$N+   Allow coprocessor instructions }
{$P+   Open parameters enabled }
{$Q+   Integer overflow checking }
{$R+   Range checking }
{$S+   Stack checking }
{$T-   @ operator is NOT typed }
{$U-   Non Pentium safe FDIV }
{$Z-   No automatic word-sized enumerations}
{---------------------------------------------------------------------}

interface

uses
  SysUtils,
  WinTypes,
  WinProcs,
  Classes,
  EZDSLCts;

type
  { EZDSL exception class }
  EEZContainerError = class(Exception);

  { EZDSL assertion exception class }
  EEZAssertionError = class(EEZContainerError);


{---String data object routines---}
function  EZStrCompare(Data1, Data2 : pointer) : integer;
procedure EZStrDisposeData(aData : pointer);
function  EZStrDupData(aData : pointer) : pointer;

{---ASCIIZ String data object routines---}
function  EZStrZCompare(Data1, Data2 : pointer) : integer;
procedure EZStrZDisposeData(aData : pointer);
function  EZStrZDupData(aData : pointer) : pointer;

{---Longint data object routines---}
function  EZIntCompare(Data1, Data2 : pointer) : integer;
procedure EZIntDisposeData(aData : pointer);
function  EZIntDupData(aData : pointer) : pointer;

{---Do nothing routines---}
function  EZNoCompare(Data1, Data2 : pointer) : integer;
procedure EZNoDisposeData(aData : pointer);

{---Safe memory alloc/free routines---}
procedure SafeGetMem(var P; BlockSize : word);
procedure SafeFreeMem(var P; BlockSize : word);

{---EZDSL exceptions---}
procedure RaiseError(WhatCode : word);
procedure Assert(Proposition : boolean; WhatCode : word);

implementation

{---EZDStruc exceptions-----------------------------------------------}
procedure RaiseError(WhatCode : word);
  begin
    raise EEZContainerError.CreateRes(WhatCode);
  end;
{--------}
procedure Assert(Proposition : boolean; WhatCode : word);
  begin
    if (Proposition = false) then
      raise EEZAssertionError.CreateRes(WhatCode);
  end;
{---------------------------------------------------------------------}


{---Data object routines----------------------------------------------}
function  EZStrCompare(Data1, Data2 : pointer) : integer;
  begin
    if (Data1 = nil) then
      if (Data2 = nil) then
           EZStrCompare := 0
      else EZStrCompare := -1
    else
      if (Data2 = nil) then EZStrCompare := 1
      else
        asm
          xor ax, ax
          mov cx, ax
          mov dx, ds
          lds si, Data1
          les di, Data2
          mov bl, [si]
          inc si
          mov bh, es:[di]
          inc di
          mov cl, bl
          cmp cl, bh
          jbe @@CompareStrings
          mov cl, bh
        @@CompareStrings:
          or cx, cx
          jz @@CompareLengths
          cld
          repe cmpsb
          jb @@LT
          ja @@GT
        @@CompareLengths:
          cmp bl, bh
          je @@Exit
          jb @@LT
        @@GT:
          inc ax
          inc ax
        @@LT:
          dec ax
        @@Exit:
          mov @Result, ax
          mov ds, dx
        end;
  end;
{--------}
procedure EZStrDisposeData(aData : pointer);
  begin
    DisposeStr(PString(aData));
  end;
{--------}
function  EZStrDupData(aData : pointer) : pointer;
  begin
    if (aData = nil) then
      Result := nil
    else
      Result := NewStr(PString(aData)^);
  end;
{--------}
function  EZStrZCompare(Data1, Data2 : pointer) : integer;
  begin
    if (Data1 = nil) then
      if (Data2 = nil) then
           Result := 0
      else Result := -1
    else
      if (Data2 = nil) then
           Result := 1
      else Result := StrComp(PChar(Data1), PChar(Data2));
  end;
{--------}
procedure EZStrZDisposeData(aData : pointer);
  begin
    StrDispose(PChar(aData));
  end;
{--------}
function  EZStrZDupData(aData : pointer) : pointer;
  begin
    if (aData = nil) then
      Result := nil
    else
      Result := StrNew(PChar(aData));
  end;
{--------}
function  EZIntCompare(Data1, Data2 : pointer) : integer; assembler;
  asm
    xor ax, ax                  {assume equal}
    mov bx, Data1.Word[2]       {get high integer of Data1}
    cmp bx, Data2.Word[2]       {compare with high integer of Data2}
    jl @@LT                     {less than? jump if so}
    jg @@GT                     {greater than? jump if so}
    mov bx, Data1.Word[0]       {get low word of Data1}
    cmp bx, Data2.Word[0]       {compare with low word of Data2}
    je @@Exit                   {equal? exit if so}
    jb @@LT                     {less than? jump if so}
  @@GT:                         {get here if Data1 > Data2}
    inc ax                      {set ax to 2}
    inc ax                      {fall through next bit to set ax to 1}
  @@LT:                         {get here if Data1 < Data2}
    dec ax                      {decrement ax by 1}
  @@Exit:
  end;
{--------}
procedure EZIntDisposeData(aData : pointer);
  begin
    {do nothing}
  end;
{--------}
function  EZIntDupData(aData : pointer) : pointer;
  begin
    Result := aData;
  end;
{--------}
function EZNoCompare(Data1, Data2 : pointer) : integer; assembler;
  asm
    xor ax, ax {return 0}
  end;
{--------}
procedure EZNoDisposeData(aData : pointer);
  begin
    {do nothing}
  end;
{---------------------------------------------------------------------}


{===SafeFreeMem/SafeGetMem===========================================
Allocates and deallocates memory 'safely'. In debug mode SafeGetMem
will fill the allocated block with $CC characters - in the debugger
it will show up data in the block that wasn't initialised, and if
there is a bug such that the block is executed as code you'll get an
automatic breakpoint ($CC = INT $03).
18Jun95 JMB
=====================================================================}
procedure SafeGetMem(var P; BlockSize : word);
  var
    Pt : pointer absolute P;
  begin
    GetMem(Pt, BlockSize);
    {$IFDEF DEBUG}
    FillChar(Pt^, BlockSize, $CC);
    {$ENDIF}
  end;
{--------}
procedure SafeFreeMem(var P; BlockSize : word);
  var
    Pt : pointer absolute P;
  begin
    if Assigned(Pt) then
      begin
        FreeMem(Pt, BlockSize);
        Pt := nil;
      end;
  end;

end.
