unit DirNav;

{$S-,W-,R-}
{$C PRELOAD}

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, Forms, Menus,
  Graphics, StdCtrls;

type
  TDirNavigator = class(TComponent)
  private
    FEnabled: Boolean;
    FBeforeNavigate: TNotifyEvent;
    FAfterNavigate: TNotifyEvent;
    FOnRecurse: TNotifyEvent;
    procedure SetEnabled(Value: Boolean);
    procedure SetBeforeNavigate(Value: TNotifyEvent);
    procedure SetAfterNavigate(Value: TNotifyEvent);
    procedure SetOnRecurse(Value: TNotifyEvent);
  protected
    procedure BeforeNav; dynamic;
    procedure AfterNav; dynamic;
    procedure Recursed; dynamic;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Navigate;
  published
    property Enabled: Boolean read FEnabled write SetEnabled default True;
    property BeforeNavigate: TNotifyEvent read FBeforeNavigate write SetBeforeNavigate;
    property AfterNavigate: TNotifyEvent read FAfterNavigate write SetAfterNavigate;
    property OnRecurse: TNotifyEvent read FOnRecurse write SetOnRecurse;
  end;

procedure Register;

implementation

{ TDirNavigator }

constructor TDirNavigator.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FEnabled := True;
end;

destructor TDirNavigator.Destroy;
begin
  FEnabled := False;
  inherited Destroy;
end;

procedure TDirNavigator.SetEnabled(Value: Boolean);
begin
  if Value <> FEnabled then FEnabled := Value;
end;

procedure TDirNavigator.SetBeforeNavigate(Value: TNotifyEvent);
begin
  FBeforeNavigate := Value;
end;

procedure TDirNavigator.SetAfterNavigate(Value: TNotifyEvent);
begin
  FAfterNavigate := Value;
end;

procedure TDirNavigator.SetOnRecurse(Value: TNotifyEvent);
begin
  FOnRecurse := Value;
end;

procedure TDirNavigator.BeforeNav;
begin
  if Assigned(FBeforeNavigate) then FBeforeNavigate(Self);
end;

procedure TDirNavigator.AfterNav;
begin
  if Assigned(FAfterNavigate) then FAfterNavigate(Self);
end;

procedure TDirNavigator.Recursed;
begin
  if Assigned(FOnRecurse) then FOnRecurse(Self);
end;

procedure TDirNavigator.Navigate;

procedure ReadDirectory;
var
  IsFileEntry: boolean;
  Sr: TSearchRec;
  DosError: integer;
begin
  Recursed;
  DosError := FindFirst('*.*', faDirectory, Sr);
  while DosError = 0 do with Sr do
  begin
    IsFileEntry := Name[1] <> '.';
    if IsFileEntry and (Attr and faDirectory <> 0) then
    begin
      ChDir(Name);
      ReadDirectory;
      ChDir('..');
    end;
    DosError := FindNext(Sr);
  end;
end;

begin
  if FEnabled then
  begin
    BeforeNav;
    ReadDirectory;
    AfterNav;
  end;
end;

procedure Register;
begin
  RegisterComponents('System', [TDirNavigator]);
end;

end.
