(************************************************************************************)
(* Author      : Yoram Halberstam                                                   *)
(* Version     : 1.00                                                               *)
(* Last update : 04/11/95 (DD/MM/YY for American people)                            *)
(* OS          : Windows 3.x (16 bit)                                               *)
(* Function    : File Manager                                                       *)
(* E-Mails     : Compuserve (CIS)        - 100773,1675@compuserve.com               *)
(*               Microsoft Network (MSN) - KOBAIA_MAN@msn.com                       *)
(*                                                                                  *)
(* This is a FREEWARE DLL. You might modify it as you wish, but I'll be happy to    *)
(* hear about any major changes or added procedures, by E-Mail. I created this DLL  *)
(* to help other users, and to leave a trace of myself in the Delphi-Pascal Forum,  *)
(* you never know who's gonna give you some job to do (hahaha). As we're all here   *)
(* to help each other, I'll be pleased if anyone can give me some suggestions or    *)
(* report any bugs to me, at one of my E-Mail above.                                *)
(*                                                                                  *)
(* I tried to make this Pascal DLL as clear as possible. If you do not agree, sorry *)
(* I'm only human.                                                                  *)
(*                                                                                  *)
(* THERE IS NO WARRANTIES THAT THIS DLL WORKS AND NO WARRANTIES ABOUT THE SAFETY    *)
(* OF YOUR SYSTEM, USING IT. I DON'T THINK IT IS POSSIBLE FOR IT TO DO ANY          *)
(* DAMMAGE BUT YOU NEVER KNOW. THIS IS FREE TO USE, EVEN IN A COMMERCIAL WAY, BUT   *)
(* I'LL ACCEPT SOME CASH IF YOU THINK I'M WOTH IT. ENJOY THIS DLL!                  *)
(*                                                                                  *)
(* Yoram Halberstam                                                                 *)
(************************************************************************************)
Library FilMgr95;

{$B-}
{$D This DLL was created by Yoram Halberstam - France. This is a FREEWARE DLL.}

Uses WinDos, WinProcs;

Const (* Program *)
      HiVer : Word = 1;
      LoVer : Word = 0;

      (* General File Errors *)
      File_Not_Found           : Byte = 2;
      Path_Not_Found           : Byte = 3;
      Too_Many_File_Open       : Byte = 4;
      File_Access_Denied       : Byte = 5;
      Invalid_Drive            : Byte = 15;
      Cant_Remove_Dir          : Byte = 16;
      Disk_Read_Error          : Byte = 100;
      Disk_Write_Error         : Byte = 101;

      (* General File Copy Errors *)
      Cant_Copy_File_On_Itself : Byte = 1;
      Error_While_Copying      : Byte = 6;

      (* General File Compare Errors *)
      Cant_Compare_Same_File   : Byte = 7;
      Wrong_Compare_Header     : Byte = 8;

      (* Compare File Items *)
      Same                     : Char = #0;
      Diff                     : Char = #1;
      Compare_File_Header      : Array[0..11] of Char = 'Compfilev1.0';

      (* General Compare Status *)
      Same_Size                : Word = $0001;
      Same_Attr                : Word = $0002;
      Same_DT                  : Word = $0004;  

Type (************************************************************)
     (* Type TFileInfo, store essential information about a file *)
     (************************************************************)
     TFileInfo = Record
                   F     : File;    (* File Handler                                   *)
                   Drv   : Char;    (* Drive letter                                   *)
                   Path  : String;  (* Path                                           *)
                   FName : String;  (* Name of file                                   *)
                   Ext   : String;  (* Extension of file                              *)
                   Attr  : Word;    (* Attribute (Archive, Hidden, Read Only, System) *)
                   Size  : LongInt; (* Size of the file in byte                       *)
                   DT    : LongInt; (* Date and time of creation of the File          *)
                 End;

     (****************************************************************************)
     (* Type TCompRec, Store the position where a compare between 2 files didn't *)
     (* match. It store as well the 2 different character                        *)
     (****************************************************************************)
     TCompRec  = Record
                   Pos                  : Longint; (* Position in file     *)
                   CharSource, CharDest : Char;    (* Character mismatched *)
                 End;

(********************************************************************************)
(* Function Min : Determine the lowest between the 2 values given as parameters *)
(* L1           : First value                                                   *)
(* L2           : Second Value                                                  *)
(* Result       : Lowest value between L1 and L2                                *)
(********************************************************************************)
Function Min(LI1, LI2 : Longint) : Longint;
Begin
  If LI1 > LI2 then Min := LI2
  Else Min := LI1;
End;

(***********************************************************************************)
(* Function FilMgr95Ver : Determine the version of the DLL                         *)
(* NO PARAMETERS REQUIRED                                                          *)
(* Result               : The version of the DLL in the HiWord and the sub version *)
(*                        in the LowWord                                           *)
(***********************************************************************************)
Function FilMgr95Ver : LongInt; Export;
Begin
  FilMgr95Ver := MakeLong(LoVer, HiVer);
End;

(*************************************************************************************)
(* Function FileExist : Determine if file exist                                      *)
(* FName              : Name of the file to be verify                                *)
(* Result             : The result value, no error = 0, for other value check in the *)
(*                      Const above, GENERAL FILES ERRORS value                      *)
(*************************************************************************************)
Function FileExist(FName : String) : Byte; Export;
Var F      : File;
    Count : Byte;
Begin
  Assign(F, FName);

  { Open the file with setting the $I (IOResult) to false so there won't be any }
  { error if the file don't exist. This way you can report any error            }
  {$I-} Reset(F); {$I+}

  Count := IoResult;

  { If count (IOResult) is 0 then no Error. Then you can close the file }
  If Count = 0 then Close(F);

  FileExist := Count;
End;

(*************************************************************************************)
(* Function GetFreeFile : Find a file name that doesn't exist, very good when you    *)
(*                        want to create a temporary file on a disk.                 *)
(* Result               : An unused file name                                        *)
(*************************************************************************************)
Function GetFreeFile : String; Export;
Var F             : File;
    S             : String;
    Count, Count2 : Byte;
Begin
  Randomize;

  Repeat
    S := '';

    { Find 8 random character to be the name of the file }
    For Count := 1 to 8 do
    Begin
      Count2 := Random(26);

      S := S + Chr(Count2 + 65);
    End;
  Until FileExist(S) = 2;

  GetFreeFile := S;
End;

(*************************************************************************************)
(* Function SeparateFileName : Separate the file name in to 4 parts                  *)
(*                             the Drive, Path, FileName, Extension of file          *)
(* S                         : the complete filename                                 *)
(*                             Only the filename is indispensable in the source      *)
(*                             if it is in the same drive and directory the computer *)
(*                             is now.                                               *)
(* Drive                     : The drive where the file is                           *)
(* Path                      : The path where the file is                            *)
(* FName                     : The File Name                                         *)
(* Ext                       : The File Extension                                    *)
(*************************************************************************************)
Procedure SeparateFileName(S : String; Var Drive : Char; Var Path, FName, Ext : String); Export;
Var Count, Count2 : Byte;
    S2            : String;
    S3            : ^String;
Begin
  {UpCase the string. This is much more simple for research}
  For Count := 1 to Length(S) do S[Count] := UpCase(S[Count]);

  {Initialize Data and put the current drive and path in "S2", just in case this}
  {is missing in the source}
  Count := Length(S); GetDir(0, S2); Drive := ' '; Path := ''; FName := ''; Ext := '';

  {Check if "source" length = 0. If this is the case then nothing to do : Exit}
  If Count = 0 then Exit;

  {If the 2nd character of the source is ":" then take the first letter as the drive.}
  {This is usually the case. If drive letter not found then take it the same as the}
  {currenf drive}
  If (Count >= 2) and (S[2] = ':') then Drive := S[1]
  Else Drive := S2[1];

  {Now that we have the drive sort out then recheck the current directory of this drive}
  GetDir(Ord(Drive) - 64, S2); If S2[Length(S2)] <> '\' then S2 := S2 + '\';

  {"S3" is a pointer. It's better in this case because we can put the address of}
  {of another string to it ("Source" directory if exist or the current directory string}
  {If drive directory is found in the "source" then "S3" will point to "S" else it is}
  {gonna point to "S2" (Current directory)}
  If (Count >= 3) and (S[3] = '\') then S3 := @S
  Else S3 := @S2;

  {Check where the directory (path) end in the filename string. We do not need to look}
  {for the beginning because we expect it to be 3. eg: "c:\"}
  Count2 := Length(S3^);
  Repeat If S3^[Count2] <> '\' then Dec(Count2) Until (Count2 = 0) or (S3^[Count2] = '\');

  {Retreive directory to path}
  If Count2 > 0 then for Count := 3 to Count2 do Path := Path + S3^[Count];

  {Retreive FileName and extension}
  Count := Length(S); Count2 := 0;
  Repeat
    Case S[Count] of
      '.'  : Count2 := 1;

      '\'  : Begin End;

      Else If Count2 = 0 then Ext := S[Count] + Ext
           Else FName := S[Count] + FName;
    End;

    Dec(Count);
  Until (Count = 0) or (S[Count] in ['\', ':']);

  {As the procedure will first try to recognize an extension and not all file}
  {got extension; but all file got File Name. If the file name is nothing then we}
  {know that the extension was not found, and what we beleived to be an extension}
  {is a file Name}
  If FName = '' then
  Begin
    FName := Ext;
    Ext   := '';
  End;
End;

(*************************************************************************************)
(* Function GetFileInfo : Find the ATTRIBUTS, SIZE, DATE AND TIME of a specific file *)
(* FInfo                : The variable where the Info are gonna be store.            *)
(*                        The only necessary you have got to specify if the          *)
(*                        File Name. Specify it to FInfo.FName                       *)
(*************************************************************************************)
Function GetFileInfo(Var FInfo : TFileInfo) : Byte; Export;
Var Count : Byte;
Begin
  {Check if file exist}
  Count := FileExist(FInfo.FName);

  If Count in [File_Access_Denied, 0] then
  Begin
    Assign(FInfo.F, FInfo.FName);

    {Get the file attributs (Hidden, Archive, System, ReadOnly) and set the file}
    {to Archive only attribut. I'm doing this to prevent opennig a ReadOnly file}
    {If I do this then the system will probably crash, or at least your program}
    GetFAttr(FInfo.F, FInfo.Attr); SetFAttr(FInfo.F, faArchive);

    {Now that everything is OK, I'm opening the file}
    Reset(FInfo.F, 1);

    {I get the size of the file}
    FInfo.Size := FileSize(FInfo.F);

    {I get the time and date it was created}
    GetFTime(FInfo.F, FInfo.DT);

    {Finnally I close the file}
    Close(FInfo.F);

    {As I changed the attributs above, I put them back}
    Assign(FInfo.F, FInfo.FName); SetFAttr(FInfo.F, FInfo.Attr);

    Count := 0;
  End;

  GetFileInfo := Count;
End;

(*************************************************************************************)
(* Function SetFileInfo : Set the ATTRIBUTS, DATE AND TIME of a specific file        *)
(* FInfo                : The variable where the Info to set to the file are         *)
(*                        The only necessary you have got to specify if the          *)
(*                        File Name. Specify it to FInfo.FName                       *)
(*************************************************************************************)
Function SetFileInfo(FInfo : TFileInfo) : Byte; Export;
Var Count : Byte;
Begin
  {Check if the file exist}
  Count := FileExist(FInfo.FName);

  If Count in [File_Access_Denied, 0] then
  Begin
    {Set the attribut to archive, to prevent the ReadOnly Crach}
    Assign(FInfo.F, FInfo.FName); SetFAttr(FInfo.F, faArchive);

    {Now that everythings is all right, open the file}
    Reset(FInfo.F, 1);

    {Set the date and time of the file}
    SetFTime(FInfo.F, FInfo.DT);

    {Close the file}
    Close(FInfo.F);

    {Now we can set the file Attributs}
    Assign(FInfo.F, FInfo.FName); SetFAttr(FInfo.F, FInfo.Attr);

    Count := 0;
  End;

  SetFileInfo := Count;
End;

(*************************************************************************************)
(* Function CopyFile : Copy the file on to another                                   *)
(* Source            : The Source file                                               *)
(* Dest              : The Destinaton file (copy of the source file)                 *)
(* Result            : 0 = Ok, Else there is an error                                *)
(*************************************************************************************)
Function CopyFile(Source, Dest : String) : Byte; Export;
Var FSource, FDest : TFileInfo;
    Buf            : Array[1..8192] of Char;
    NRead          : Word;
    NWrite         : Word;
    Count          : Byte;
Begin
  {Retrieive entire source and destination drive, path, file name and extension}
  With FSource do
  Begin
    SeparateFileName(Source, Drv, Path, FName, Ext);
    Source := Drv + ':' + Path + FName + '.' + Ext;
  End;

  With FDest do
  Begin
    SeparateFileName(Dest, Drv, Path, FName, Ext);
    Dest := Drv + ':' + Path + FName + '.' + Ext;
  End;

  {Set "count" to 0 and put the error value if the source file is the same than}
  {the destination file}
  Count := 0;
  If Source = Dest then Count := Cant_Copy_File_On_Itself;

  {If no Errors then Get the File information of the source}
  FSource.FName := Source;
  If Count = 0 then Count := GetFileInfo(FSource);

  If Count in [File_Access_Denied, 0] then
  Begin
    {Set Archive attribut to the source file and Open the file}
    Assign(FSource.F, Source); SetFAttr(FSource.F, faArchive);
    Reset(FSource.F, 1);

    {Verify is the destination exist. It does not matter in a way because this file is}
    {gonna be erase, to be the copy of the "source". But if this file exist and it}
    {has got a Read Only attribut then an error will occur if erase it. If this is the}
    {case then you'll just have to set this file with archive Attribut Only}
    Count := FileExist(Dest);

    If Count = File_Access_Denied then
    Begin
      Assign(FDest.F, Dest); SetFAttr(FDest.F, faArchive);
    End;

    {* Create the destination file}
    Assign(FDest.F, Dest); Rewrite(FDest.F, 1);

    {Copy the file}
    Repeat
      BlockRead(FSource.F, Buf, SizeOf(Buf), NRead);
      BlockWrite(FDest.F, Buf, NRead, NWrite);
    Until (NRead = 0) or (NWrite <> NRead);

    {If "NRead" (Num of character read from source fil) is different than "NWrite"}
    {(Num of character write to the destination file) then an error has occur}
    {Else copy was OK}
    If NRead = NWrite then Count := 0
    Else Count := Error_While_Copying;

    {Close all file}
    Close(FSource.F); Close(FDest.F);

    {As we change the attribut of source file to Archive, we have to put back the}
    {attribut of it. We also have to put the copied file with the same attribut, date}
    {and time}
    FSource.FName := Source; SetFileInfo(FSource);
    FSource.FName := Dest;   SetFileInfo(FSource);

    Count := 0;
  End;

  CopyFile := Count;
End;

(*************************************************************************************)
(* Function RenameFile : Rename a file to another one                                *)
(* Source              : The Source file                                             *)
(* Dest                : The Destinaton file (copy of the source file)               *)
(* Result              : 0 = Ok, Else there is an error                              *)
(*************************************************************************************)
Function RenameFile(Source, Dest : String) : Byte; Export;
Var F     : File;
    Count : Byte;
Begin
  {Copy the "source" file in the "dest"ination file}
  Count := CopyFile(Source, Dest);

  {If no error then Erase "source" file name}
  If Count = 0 then
  Begin
    {Before erasing the source file name, you have to set his attribut to archive}
    {this way you are sure not to get the ReadOnly Error}
    Assign(F, Source); SetFAttr(F, faArchive); Erase(F);
  End;

  RenameFile := Count;
End;

(*************************************************************************************)
(* Function CompareFile : Rename a file to another one                               *)
(* Source               : The Source file                                            *)
(* Dest                 : The seond file                                             *)
(* ErrFile              : A variable containing the the name of the temp Error File  *)
(* Result               : 0 = Ok, Else there is an error                             *)
(*************************************************************************************)
Function CompareFile(Source, Dest : String; Var ErrFile : String) : Byte; Export;
Var FSource, FDest : TFileInfo;
    F              : File;
    Count, Count2  : Byte;
    SByte          : Set of Byte;
    EndLoop        : LongInt;
    LI             : LongInt;
    NRead          : Word;
    Buf            : Array[0..1] of Array[1..4096] of Char;
    CompRec        : TCompRec;
    ErrCount       : LongInt;
Begin
  {Set the existing file error}
  SByte := [File_Access_Denied, 0];

  {Make a complete filename}
  With FSource do
  Begin
    SeparateFileName(Source, Drv, Path, FName, Ext);
    Source := Drv + ':' + Path + FName + '.' + Ext;
  End;

  {Make a complete filename}
  With FDest do
  Begin
    SeparateFileName(Dest, Drv, Path, FName, Ext);
    Dest := Drv + ':' + Path + FName + '.' + Ext;
  End;

  {Check if the 2 files are the same}
  If Source = Dest then
  Begin
    CompareFile := Cant_Compare_Same_File;
    Exit;
  End;

  {Check if the files exist}
  Count := FileExist(Source); Count2 := FileExist(Dest);

  If (Count in SByte) and (Count2 in SByte) then
  Begin
    {Get the files infos}
    FSource.FName := Source; GetFileInfo(FSource);
    FDest.FName   := Dest;   GetFileInfo(FDest);

    {Get the name of the temp error files}
    ErrFile := GetFreeFile; Assign(F, ErrFile); Rewrite(F, 1);
    BlockWrite(F, Compare_File_Header, SizeOf(Compare_File_Header));

    {Check the sizes of the 2 files}
    If FSource.Size = FDest.Size then BlockWrite(F, Same, SizeOf(Same))
    Else BlockWrite(F, Diff, SizeOf(Diff));

    {Check the attributs of the 2 files}
    If FSource.Attr = FDest.Attr then BlockWrite(F, Same, SizeOf(Same))
    Else BlockWrite(F, Diff, SizeOf(Diff));

    {Check the dat and time of the 2 files}
    If FSource.DT = FDest.DT then BlockWrite(F, Same, SizeOf(Same))
    Else BlockWrite(F, Diff, SizeOf(Diff));

    {Set attribut to archive to prevent the Read Only error}
    Assign(FSource.F, Source); SetFAttr(FSource.F, faArchive); Reset(FSource.F, 1);
    Assign(FDest.F,   Dest);   SetFAttr(FDest.F,   faArchive); Reset(FDest.F,   1);

    {Start the file comparaison}
    EndLoop := Min(FSource.Size, FDest.Size); ErrCount := 0;
    BlockWrite(F, ErrCount, SizeOf(ErrCount));
    Repeat
      If EndLoop > SizeOf(Buf[0]) then BlockRead(FSource.F, Buf[0], SizeOf(Buf[0]), NRead)
      Else BlockRead(FSource.F, Buf[0], EndLoop, NRead);

      BlockRead(FDest.F, Buf[1], NRead);

      LI := 0;
      If NRead > 0 then
      Repeat
        Inc(LI);

        If Buf[0][LI] <> Buf[1][LI] then
        Begin
          CompRec.Pos        := FilePos(FSource.F) - NRead + LI;
          CompRec.CharSource := Buf[0][LI];
          CompRec.CharDest   := Buf[1][LI];

          BlockWrite(F, CompRec, SizeOf(CompRec));

          Inc(ErrCount);
        End
      Until LI = NRead
      Else EndLoop := 0;

      EndLoop := EndLoop - NRead;
    Until EndLoop <= 0;

    {Write the number of error in the Error file}
    Seek(F, SizeOf(Compare_File_Header) + 3); BlockWrite(F, ErrCount, SizeOf(ErrCount));

    {Close the files}
    Close(FSource.F); Close(FDest.F); Close(F);

    {Set back the original info of files}
    SetFileInfo(FSource); SetFileInfo(FDest);

    {Make a full file out of the error file}
    With FSource do
    Begin
      SeparateFileName(ErrFile, Drv, Path, FName, Ext);

      ErrFile := Drv + ':' + Path + FName + '.' + Ext;
    End;

    Count := 0;
  End
  Else If Count in SByte then Count := Count2;

  CompareFile := Count;
End;

Function OpenCompareFile(Var FileInfo : TFileInfo) : Byte; Export;
Var Buf   : Array[0..11] of Char;
    NRead : Word;
    Found : Boolean;
Begin
  Assign(FileInfo.F, FileInfo.FName); Reset(FileInfo.F, 1);

  BlockRead(FileInfo.F, Buf, SizeOf(Buf), NRead);

  If NRead <> SizeOf(Buf) then
  Begin
    Close(FileInfo.F);
    OpenCompareFile := Wrong_Compare_Header;
    Exit;
  End;

  {$B+}
    For NRead := 0 to 11 do Found := Found and (Buf[NRead] = Compare_File_Header[NRead]);
  {$B-}

  If not Found then
  Begin
    Close(FileInfo.F);
    OpenCompareFile := Wrong_Compare_Header;
    Exit;
  End;

  OpenCompareFile := 0;
End;

Function CheckCompareAttr(FileInfo : TFileInfo; Var Check : Word) : Boolean; Export;
Var Buf           : Array[0..2] of Char;
    Count         : Byte;
    Count2        : Word;
Begin
  Seek(FileInfo.F, SizeOf(Compare_File_Header));

  {$I-}
    BlockRead(FileInfo.F, Buf, SizeOf(Buf));
  {$I+}

  If IOResult <> 0 then
  Begin
    CheckCompareAttr := False;
    Exit;
  End;

  {Set all byte to 0, this give in binary : 0000000000000000; I'm only interested}
  {in the 3 first byte, N0 - Size, N1 - Attributs, N2 - DT}
  Check := $0000;

  For Count := 0 to 2 do
  Begin
    Case Count of
      0 : Count2 := $0001;
      1 : Count2 := $0002;
      2 : Count2 := $0004;
    End;

    If Buf[Count] = Same then Check := Check or Count2;
  End;

  CheckCompareAttr := True
End;

Function GetCompareErrNum(FileInfo : TFileInfo) : Longint; Export;
Var LI : LongInt;
Begin
  {$I-}
    Seek(FileInfo.F, SizeOf(Compare_File_Header) + 3);
  {$I+}

  LI := IOResult;

  If LI = 0 then
  {$I-}
    BlockRead(FileInfo.F, LI, SizeOf(LI));
  {$I+}

  GetCompareErrNum := LI;
End;

Function GetCompareErrRec(FInfo : TFileInfo; Pos : LongInt; Var CompRec : TCompRec) : Byte; Export;
Begin
  {$I-}
    Seek(FInfo.F, SizeOf(Compare_File_Header) + SizeOf(LongInt) + 3 + (SizeOf(CompRec) * Pos));
    BlockRead(FInfo.F, CompRec, SizeOf(CompRec));
  {$I+}

  GetCompareErrRec := IOResult;
End;

Procedure CloseCompareFile(FileInfo : TFileInfo); Export;
Begin
  Close(FileInfo.F);
End;

Exports
  FilMgr95Ver      index 1,
  FileExist        index 2,
  GetFreeFile      index 3,
  SeparateFileName index 4,
  GetFileInfo      index 5,
  SetFileInfo      index 6,
  CopyFile         index 7,
  RenameFile       index 8,
  CompareFile      index 9,
  OpenCompareFile  index 10,
  CheckCompareAttr index 11,
  GetCompareErrNum index 12,
  GetCompareErrRec index 13,
  CloseCompareFile index 14;

Begin
End.