Unit _Files95;

Interface
  Uses Windos;

  Const (* General File Errors *)
        File_Not_Found           : Byte = 2;
        Path_Not_Found           : Byte = 3;
        Too_Many_File_Open       : Byte = 4;
        File_Access_Denied       : Byte = 5;
        Invalid_Drive            : Byte = 15;
        Cant_Remove_Dir          : Byte = 16;
        Disk_Read_Error          : Byte = 100;
        Disk_Write_Error         : Byte = 101;

        (* General File Copy Errors *)
        Cant_Copy_File_On_Itself : Byte = 1;
        Error_While_Copying      : Byte = 6;

        (* General File Compare Errors *)
        Cant_Compare_Same_File   : Byte = 7;
        Wrong_Compare_Header     : Byte = 8;

        (* Compare File Items *)
        Same                     : Char = #0;
        Diff                     : Char = #1;
        Compare_File_Header      : Array[0..11] of Char = 'Compfilev1.0';

        (* General Compare Status *)
        Same_Size                : Word = $0001;
        Same_Attr                : Word = $0002;
        Same_DT                  : Word = $0004;

  Type (************************************************************)
       (* Type TFileInfo, store essential information about a file *)
       (************************************************************)
       TFileInfo = Record
                     F     : File;    (* File Handler                                *)
                     Drv   : Char;    (* Drive letter                                *)
                     Path  : String;  (* Path                                        *)
                     FName : String;  (* Name of file                                *)
                     Ext   : String;  (* Extension of file                           *)
                     Attr  : Word;    (* Attrib (Archive, Hidden, Read Only, System) *)
                     Size  : LongInt; (* Size of the file in byte                    *)
                     DT    : LongInt; (* Date and time of creation of the File       *)
                   End;

       (****************************************************************************)
       (* Type TCompRec, Store the position where a compare between 2 files didn't *)
       (* match. It store as well the 2 different character                        *)
       (****************************************************************************)
       TCompRec  = Record
                     Pos                  : Longint; (* Position in file     *)
                     CharSource, CharDest : Char;    (* Character mismatched *)
                   End;

  Function FilMgr95Ver : LongInt;
  Function FileExist(FName : String) : Byte;
  Function GetFreeFile : String;
  Procedure SeparateFileName(S : String; Var Drive : Char; Var Path, FName, Ext : String);
  Function GetFileInfo(Var FInfo : TFileInfo) : Byte;
  Function SetFileInfo(FInfo : TFileInfo) : Byte;
  Function CopyFile(Source, Dest : String) : Byte;
  Function RenameFile(Source, Dest : String) : Byte;
  Function CompareFile(Source, Dest : String; Var ErrFile : String) : Byte;
  Function OpenCompareFile(Var FileInfo : TFileInfo) : Byte;
  Function CheckCompareAttr(FileInfo : TFileInfo; Var Check : Word) : Boolean;
  Function GetCompareErrNum(FileInfo : TFileInfo) : Longint;
  Function GetCompareErrRec(FInfo : TFileInfo; Pos : LongInt; Var CompRec : TCompRec) : Byte;
  Procedure CloseCompareFile(FileInfo : TFileInfo);
Implementation

Function FilMgr95Ver : LongInt;                                                             External 'FILMGR95.DLL' index 1;
Function FileExist(FName : String) : Byte;                                                  External 'FILMGR95.DLL' index 2;
Function GetFreeFile : String;                                                              External 'FILMGR95.DLL' index 3;
Procedure SeparateFileName(S : String; Var Drive : Char; Var Path, FName, Ext : String);    External 'FILMGR95.DLL' index 4;
Function GetFileInfo(Var FInfo : TFileInfo) : Byte;                                         External 'FILMGR95.DLL' index 5;
Function SetFileInfo(FInfo : TFileInfo) : Byte;                                             External 'FILMGR95.DLL' index 6;
Function CopyFile(Source, Dest : String) : Byte;                                            External 'FILMGR95.DLL' index 7;
Function RenameFile(Source, Dest : String) : Byte;                                          External 'FILMGR95.DLL' index 8;
Function CompareFile(Source, Dest : String; Var ErrFile : String) : Byte;                   External 'FILMGR95.DLL' index 9;
Function OpenCompareFile(Var FileInfo : TFileInfo) : Byte;                                  External 'FILMGR95.DLL' index 10;
Function CheckCompareAttr(FileInfo : TFileInfo; Var Check : Word) : Boolean;                External 'FILMGR95.DLL' index 11;
Function GetCompareErrNum(FileInfo : TFileInfo) : Longint;                                  External 'FILMGR95.DLL' index 12;
Function GetCompareErrRec(FInfo : TFileInfo; Pos : LongInt; Var CompRec : TCompRec) : Byte; External 'FILMGR95.DLL' index 13;
Procedure CloseCompareFile(FileInfo : TFileInfo);                                           External 'FILMGR95.DLL' index 14;
End.
