unit _twofile;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, StdCtrls, ExtCtrls;

type
  TTwoFileForm = class(TForm)
    Panel1: TPanel;
    txt1: TLabel;
    txt2: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Button1: TButton;
    Button2: TButton;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private-dclarations }
  public
    { Public-dclarations }
  end;

var
  TwoFileForm: TTwoFileForm;

implementation

Uses _Var;

{$R *.DFM}

procedure TTwoFileForm.Button1Click(Sender: TObject);
begin
  Case ToDo of
    FCopy    : OpenDialog.Title := 'File Copy : Select the source file';
    FRename  : OpenDialog.Title := 'File Rename : Select the source file';
    FCompare : OpenDialog.Title := 'File Compare : Select the first file';
  End;

  If OpenDialog.Execute then Edit1.Text := OpenDialog.Filename;
end;

procedure TTwoFileForm.Button2Click(Sender: TObject);
begin
  Case ToDo of
    FCopy    : SaveDialog.Title := 'File Copy : Select the destination file';
    FRename  : SaveDialog.Title := 'File Rename : Select the destination file';
    FCompare : OpenDialog.Title := 'File Compare : Select the second file';
  End;

  Case ToDo of
    FCopy,
    FRename  : If SaveDialog.Execute then Edit2.Text := SaveDialog.Filename;

    FCompare :  If OpenDialog.Execute then Edit2.Text := OpenDialog.Filename;
  End;
end;

end.
