unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, About, Register,
  Status, BDisk, FileCtrl, Graflite;

type
  TSFXFormat = class(TForm)
    MainMenu: TMainMenu;
    DisketteSize: TComboBox;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    VerifyCheckBox: TCheckBox;
    VolumeLabelEdit: TEdit;
    Label2: TLabel;
    AboutBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Label3: TLabel;
    FileMenu: TMenuItem;
    ExitItem: TMenuItem;
    FormatItem: TMenuItem;
    HelpMenu: TMenuItem;
    AboutItem: TMenuItem;
    DriveComboBox1: TDriveComboBox;
    GraphicLight1: TGraphicLight;
    GraphicLight2: TGraphicLight;
    SOTBtn: TBitBtn;
    HelpBtn: TBitBtn;
    FormatBtn: TBitBtn;
    N2: TMenuItem;
    procedure SetWinTitle;
    procedure RepeatFormat;
    procedure FormatIt;
    procedure FileExit(Sender: TObject);
    procedure HelpAbout(Sender: TObject);
    procedure FormatItemClick(Sender: TObject);
    procedure ExitItemClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure AboutItemClick(Sender: TObject);
    procedure FormatBtnClick(Sender: TObject);
    procedure AboutBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Format2Click(Sender: TObject);
    procedure SOTBtnClick(Sender: TObject);
    procedure HelpBtnClick(Sender: TObject);
    procedure N2Click(Sender: TObject);
    private
       DNum: Byte;             {Drive Number}
       DTyp: Char;             {Drive Type 0..4}
       Verify: Boolean;        {Verify ?}
       VStr: VolumeStr;        {Volume String}
       SOT: Boolean;           {Keep form on top?}
  end;

var
  SFXFormat: TSFXFormat;

implementation

{$R *.DFM}

{-required function for Format}
function AbortFunc (Track, MaxTrack : Byte; Kind : Byte) : Boolean; far;
var
Msg: string;
EndMessage: string;
Percent: Integer;  {Percent Complete}
const
NewLine = #10#13;
{-Send status to status form}
 begin  {AbortFunc}
   case Kind of
     0 : begin
            {set graphiclites}
            SFXFormat.GraphicLight2.ActiveLight := AlGray;{Format beginning}
            SFXFormat.GraphicLight1.DarkLite := True;
            SFXFormat.GraphicLight1.ActiveLight := AlRed;
         end;
     1 : {Formatting track}
         begin
            if StatusForm.ModalResult <> mrCancel then
            begin
                 Msg := 'Formatting track ';
                 Msg := Msg + IntToStr(Track);
                 {Set label text in status form}
                 StatusForm.Label2.Caption := Msg;
                 Percent := (Track*100) div MaxTrack;
                 {Draw status bar with ratio value}
                 StatusForm.Gauge1.Progress := Percent;
                 {Process windows messages - permit detection of cancel button}
                 Application.ProcessMessages;
            end;
            if StatusForm.ModalResult = mrCancel then
            begin
                 StatusForm.Hide;
                 {set graphiclites}
                 SFXFormat.GraphicLight1.DarkLite := False;
                 SFXFormat.GraphicLight1.ActiveLight := AlGreen;
                 SFXFormat.GraphicLight2.ActiveLight := AlGray;
                 MessageDlg('Formatting has been cancelled!!', mtWarning, [mbOk], 0);
                 exit;
            end;
         end;
     2 : {Verifying track}
         begin
            Msg := 'Verifying track... ';
            Msg := Msg + IntToStr(Track);
            {Set static text in statusform}
            StatusForm.Label1.Caption := Msg;
         end;
     3 : {Writing boot, FAT and VOLUME Label}
         begin
            {Set static text in statusform}
            Msg := 'Writing boot, FAT and Volume Label';
            StatusForm.Label1.Caption := Msg;
         end;
     4 : {Format ending}
         begin
         {Track returns final status code in this case}
         if Track = 0 then
         {}
         else
         begin
         {Finished with error, get rid of progress dialog}
          if StatusForm.ModalResult <> mrCancel then begin
          {set graphiclites}
          SFXFormat.GraphicLight1.DarkLite := True;
          SFXFormat.GraphicLight1.ActiveLight := AlRed;
          SFXFormat.GraphicLight2.ActiveLight := AlGray;
          EndMessage := 'Disk drive is not ready.' + NewLine;
          EndMessage := EndMessage + 'Be sure to select the correct disk size!' + NewLine + NewLine;
          EndMessage := EndMessage + 'Place a diskette in drive and try again!';
          MessageDlg(EndMessage, mtError, [mbOk], 0);
          end;
          end;
       end;
   end;
   AbortFunc := False;
end;

procedure TSFXFormat.SetWinTitle;
var
WinTitle: string;
begin
   WinTitle := 'Formatting '+ DisketteSize.Text + ' Floppy Disk';
   StatusForm.Caption := WinTitle;
end;

{-repeat formatting method}
procedure TSFXFormat.RepeatFormat;
begin
   FormatIt;
end;

{-format diskette}
procedure TSFXFormat.FormatIt;
var
Msg: string;
VerifyStr: string;
EndMsg: string;
WinMsg: string;
Again: Integer;
begin

   {Set window tile of progress meter};
   SetWinTitle;
   {Make and show status messages}
   if VerifyCheckBox.State = cbChecked then
   begin
      VerifyStr := 'Verify is on';
      Verify := True;
   end
   else
   begin
      VerifyStr := 'Verify is off';
      Verify := False;
   end;
   StatusForm.Label1.Caption := VerifyStr;
   Msg := 'Formatting...';
   {Set static text in statusform}
   StatusForm.Label2.Caption := Msg;
   StatusForm.ModalResult := mrNone;
   {Show the status Form}
   StatusForm.Show;
   {Format the disk}
             FormatDisk (DNum,                    {drive number}
                         Byte(DTyp)-Byte('0'),    {format type}
                         Verify,                  {verify?}
                         0,                       {max bad sectors, 0 -> no limit}
                         VStr,                    {volume label}
                         AbortFunc);              {abort function}
    StatusForm.Close;
    {set graphiclites}
    GraphicLight1.DarkLite := False;
    GraphicLight1.ActiveLight := AlGreen;
    GraphicLight1.ActiveLight := AlGray;
    EndMsg := 'Do you want to format another disk?';
    Again := MessageDlg(EndMsg, mtConfirmation, [mbYes, mbNo], 0);
    if Again = mrYes then begin
    GraphicLight1.ActiveLight := AlGray;
    GraphicLight2.DarkLite := True;
    GraphicLight2.ActiveLight := AlRed;
    WinMsg := 'Place the disk to be formatted into drive '+
    DriveComboBox1.Drive + ' and select &Ok to format the diskette.';
    if MessageDlg(WinMsg, mtConfirmation, [mbOk, mbCancel], 0) = mrOk then FormatIt else
     begin
        {set graphiclites}
        GraphicLight1.DarkLite := False;
        GraphicLight1.ActiveLight := AlGray;
        GraphicLight2.DarkLite := True;
        GraphicLight2.ActiveLight := AlRed;
        RepeatFormat;
     end;
    end;
    {set graphiclites}
    GraphicLight1.DarkLite := False;
    GraphicLight1.ActiveLight := AlGreen;
    GraphicLight2.DarkLite := False;
    GraphicLight2.ActiveLight := AlGray;
 end;

procedure TSFXFormat.FileExit(Sender: TObject);
begin
  Close;
end;

procedure TSFXFormat.HelpAbout(Sender: TObject);
begin
  { Add code to show program's About Box }
  AboutBox.ShowModal;
end;

procedure TSFXFormat.FormatItemClick(Sender: TObject);
begin
     FormatBtnClick(Sender); 
end;

procedure TSFXFormat.ExitItemClick(Sender: TObject);
begin
     Close;
end;

procedure TSFXFormat.CancelBtnClick(Sender: TObject);
begin
     Close;
end;

procedure TSFXFormat.AboutItemClick(Sender: TObject);
begin
     AboutBox.ShowModal;
end;

procedure TSFXFormat.FormatBtnClick(Sender: TObject);
var
Msg: string;
WinMsg: string;
const
NewLine = #10#13;
begin {Format}
   {only format drive A or B}
   if DriveComboBox1.Drive <> 'A' then
      if DriveComboBox1.Drive <> 'B' then
   begin
      MessageDlg('Sorry, This program will only format floppy drives!',
      mtWarning, [mbOk], 0);
      {set graphiclites}
      GraphicLight1.DarkLite := False;
      GraphicLight1.ActiveLight := AlGreen;
      GraphicLight2.DarkLite := False;
      GraphicLight2.ActiveLight := AlGray;
      exit;
   end;
   {set graphiclites}
   GraphicLight1.DarkLite := True;
   GraphicLight1.ActiveLight := AlRed;
   GraphicLight2.DarkLite := False;
   GraphicLight2.ActiveLight := AlGray;

   {if A Drive then set drive number 0}
   if DriveComboBox1.Drive = 'A' then
      DNum := 0;

   {if B Drive then set drive number 1}
   if DriveComboBox1.Drive = 'B' then
      DNum := 1;

   {if 360k then set DriveType = 1}
   if DisketteSize.Text = '360 kb' then
      DTyp := '1';

   {if 720k then set DriveType = 2}
   if DisketteSize.Text = '720 kb' then
      DTyp := '3';

   {if 1.2M then set DriveType = 3}
   if DisketteSize.Text = '1.2 mb' then
      DTyp := '2';

   {if 1.44M then set DriveType = 4}
   if DisketteSize.Text = '1.44 mb' then
      DTyp := '4';

   {add volume label string to message}
   Msg := 'The diskette volume label is ';
   if Length(VolumeLabelEdit.Text) > 0 then Msg := Msg + VolumeLabelEdit.Text +
      '.' else Msg := 'The diskette does not have a volume label.';
   {Convert the array to a pascal string}
   VStr := VolumeLabelEdit.Text;
   {Add a new line}
   Msg := Msg + NewLine;
   {Get verify status and set boolean variable}
   if VerifyCheckBox.State = cbChecked then
   begin
      WinMsg := 'Formatting verification is on.';
      Verify := True;
   end
   else
   begin
      WinMsg := 'Formatting verification is off.';
      Verify := False;
   end;
   WinMsg := WinMsg + NewLine + Msg;
   {Add two lines}
   WinMsg := WinMsg + NewLine;
   WinMsg := WinMsg + 'Place the disk to be formatted into drive ';
   WinMsg := WinMsg + DriveComboBox1.Drive + ' and select &Ok to format the diskette.';
   if MessageDlg(WinMsg, mtConfirmation, [mbOk, mbCancel], 0) = mrOk then FormatIt else
     begin
        {set graphiclites}
        GraphicLight1.DarkLite := False;
        GraphicLight1.ActiveLight := AlGreen;
        GraphicLight2.DarkLite := False;
        GraphicLight2.ActiveLight := AlGray;
     end;
end;

procedure TSFXFormat.AboutBtnClick(Sender: TObject);
begin
     if FormStyle = fsStayOnTop then AboutBox.FormStyle := fsStayOnTop;
     AboutBox.ShowModal;
end;

procedure TSFXFormat.FormCreate(Sender: TObject);
begin
     DriveComboBox1.Drive := 'A';
     DisketteSize.Text := '1.44 mb';
     SOT := True;
end;

procedure TSFXFormat.Format2Click(Sender: TObject);
begin
     FormatBtnClick(Sender);
end;


procedure TSFXFormat.SOTBtnClick(Sender: TObject);
begin
if SOT then
   begin
      SFXFormat.FormStyle := fsNormal;
      SOTBtn.Caption := 'StayOnTop';
      SOT := False;
   end
   else
   begin
      SFXFormat.FormStyle := fsStayOnTop;
      SOTBtn.Caption := 'Normal';
      SOT := True;
   end;
end;

procedure TSFXFormat.HelpBtnClick(Sender: TObject);
begin
   Application.HelpFile := 'FORMAT.HLP';
   Application.HelpCommand(HELP_CONTENTS,0);
end;

procedure TSFXFormat.N2Click(Sender: TObject);
begin
   Application.HelpFile := 'FORMAT.HLP';
   Application.HelpCommand(HELP_CONTENTS,0);
end;

end.
