unit dSize;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TSizeForm = class(TForm)
    HorizontalSize: TRadioGroup;
    SizeWidth: TEdit;
    VerticalSize: TRadioGroup;
    SizeHeight: TEdit;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure SizeWidthKeyPress(Sender: TObject; var Key: Char);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SizeForm: TSizeForm;

implementation

{$R *.DFM}

procedure TSizeForm.SizeWidthKeyPress(Sender: TObject; var Key: Char);
begin
     If Not ( Key In ['0'..'9'] ) Then Key := #0;
end;

procedure TSizeForm.FormShow(Sender: TObject);
begin
     HorizontalSize.ItemIndex := 0;
     VerticalSize.ItemIndex := 0;

     SizeWidth.Text := '0';
     SizeHeight.Text := '0';
end;

procedure TSizeForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
Var
   X, Y : Integer;
begin
     If ModalResult = mrOK Then
     Begin
          { Check horizontal width }
          If HorizontalSize.ItemIndex = 3 Then
          Try
             X := StrToInt(SizeWidth.Text);
             If X <= 0 Then
             Begin
                  ShowMessage ( 'Width must be greater than 0' );
                  CanClose := False;
             End;
          Except
                On eConvertError Do
                Begin
                     ShowMessage ( 'Invalid width entry.  Please re-enter.' );
                     CanClose := False;
                End;
          End;

          If CanClose = False Then
             SizeWidth.SetFocus
          { Check vertical height }
          Else If VerticalSize.ItemIndex = 3 Then
          Begin
               Try
                  Y := StrToInt(SizeHeight.Text);
                  If Y <= 0 Then
                  Begin
                       ShowMessage ( 'Height must be greater than 0' );
                       CanClose := False;
                  End;
               Except
                     On eConvertError Do
                     Begin
                          ShowMessage ( 'Invalid height entry.  Please re-enter.' );
                          CanClose := False;
                     End;
               End;

               If CanClose = False Then
                  SizeHeight.SetFocus;
          End;
     End;
end;

end.
