unit PeekUnit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, FileCtrl, MPlayer;

type
  TForm1 = class(TForm)
    LBHolder: TPanel;
    FL: TFileListBox;
    DL: TDirectoryListBox;
    DCB: TDriveComboBox;
    ImageHolder: TPanel;
    Image: TImage;
    MP: TMediaPlayer;
    AVIPanel: TPanel;
    procedure FLChange(Sender: TObject);
    procedure FLDblClick(Sender: TObject);
    procedure AVIPanelResize(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FLChange(Sender: TObject);
begin
  if FL.ItemIndex >= 0 then
    begin
      {Close the Media Player}
      MP.Close;
      {Only stretch metafiles}
      Image.Stretch := (Pos('.wmf',FL.FileName) > 0);
      if (Pos('.bmp',FL.FileName) > 0) or
         (Pos('.wmf',FL.FileName) > 0) or
         (Pos('.ico',FL.FileName) > 0) then
         begin
           Cursor := crHourglass;
           Image.Picture.LoadFromFile(FL.FileName);
           AVIPanel.Hide;
           Image.Show;
           Cursor := crDefault;
         end;
    end;
end;

procedure TForm1.FLDblClick(Sender: TObject);
begin
  {If the user double-clicks on any WAV or AVI file, it will load and
   activate the MediaPlayer control. AVI files are displayed on their own
   area (AVIPanel). I selectively hide and show the AVIPanel and the Image
   control based off of what is being displayed. This was because the
   MediaPlayer needs a Panel to display on, and the BMP's, ICO's, and WMF's
   needed an Image control to display on}
  if (Pos('.wav',FL.FileName) > 0) or (Pos('.avi',FL.FileName) > 0) then
    begin
      Screen.Cursor := crHourglass;
      MP.FileName := FL.FileName;
      MP.Open;
      if (Pos('.avi',FL.FileName) > 0) then
        begin
          Image.Hide;
          AVIPanel.Show;
          MP.Display := AVIPanel;
          {I don't know why I have to shift the AVI panels display rect, but
          it was off center if I didn't. Oh well, someone out there will be
          able to explain it I am sure.}
          With AVIPanel.BoundsRect do
            MP.DisplayRect := Rect(Left-3,Top-3,Right-3,Bottom-3);
        end;
      Screen.Cursor := crDefault;
      MP.Play;
    end;
end;

procedure TForm1.AVIPanelResize(Sender: TObject);
begin
  With AVIPanel.BoundsRect do
    MP.DisplayRect := Rect(Left-3,Top-3,Right-3,Bottom-3);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  {This procedure resizes the list boxes based off of the size of the main
   form. This allows the listboxes to always be as large as they can}
  MP.Top := Form1.ClientHeight-3-MP.Height;
  DCB.Top := (Form1.ClientHeight-DCB.Height) div 2;
  FL.Height := DCB.Top - 6;
  DL.Top := DCB.Top + DCB.Height + 3;
  DL.Height := Form1.ClientHeight - DL.Top - MP.Height - 6;
end;

end.
