unit FreeRes;
{ ********************************************************************
  This unit can be used to free windows resources otherwise consumed
  by non-visible controls.  If you use it on visible controls, they
  will disappear, but not know it.  It makes use of a protected method
  of TWinControl, DestroyHandle.  This unit exports one procedure,
  FreeWinControl.  This procedure takes a TWinControl as a parameter
  and frees its resources.

  Released to the public domain on 8/21/1995
  Jim Seach
  Compuserve - 76012,3614
  internet   - jseach@ix.netcom.com

 ******************************************************************* }

interface

uses Controls, ExtCtrls;

procedure FreeWinControl(WC : TWinControl);

implementation

{ ================================================================== }
{ This is a "cousin" Class of TWinControl.  It is used to get around
  the fact that DestroyHandle is protected }

Type

  TMyWinControl = Class(TWinControl)
  public
    procedure FreeResources;
  end;

procedure TMyWinControl.FreeResources;
begin
  DestroyHandle;
end; {procedure FreeResources}

{ ================================================================== }

procedure FreeWinControl(WC : TWinControl);
var
  IsWinControl : boolean;
  ThisControl  : integer;
begin
  {check to make sure WC is really a TWinControl}
  try
    if WC is TWinControl then
      IsWinControl := True
    else
      IsWinControl := False;
  except
    { Catch the exception which will occur if WC is not an object}
    IsWinControl := False;
  end;

  {it is a TWinControl, so lets free its resources}
  if IsWinControl then
    TMyWinControl(WC).FreeResources;

end; {procedure FreePage}

end.
