unit Grep;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, StdCtrls, ExptIntf, ToolIntf, FileCtrl, ExtCtrls;

type
  TGrepForm = class(TForm)
    SearchFileName: TEdit;
    Label1: TLabel;
    FoundList: TListBox;
    CancelButton: TBitBtn;
    LoadButton: TBitBtn;
    FoundListLabel: TLabel;
    Search: TEdit;
    Label2: TLabel;
    Directories: TCheckBox;
    IgCase: TCheckBox;
    SearchBtn: TBitBtn;
    procedure CancelButtonClick(Sender: TObject);
    procedure LoadButtonClick(Sender: TObject);
    procedure SearchButtonClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
  end;

var
  GrepForm: TGrepForm;

Type
  GrepExpert = class(TIExpert)
  public
    function GetStyle: TExpertStyle; override;
    function GetIDString: string; override;
    function GetName: string; override;
    function GetComment: string; override;
    function GetGlyph: HBITMAP; override;
    function GetState: TExpertState; override;
    function GetMenuText: string; override;
    procedure Execute; override;
  end;

  procedure Register;

implementation

uses IniFiles;

{$R *.DFM}

procedure Register;
begin
  RegisterLibraryExpert(GrepExpert.Create);
end;

function GrepExpert.GetStyle: TExpertStyle;
begin
  Result := esStandard
end;

function GrepExpert.GetIDString: String;
begin
  Result := 'Gerald Lindner Grep'
end;

function GrepExpert.GetComment: String;
begin
  Result := ''
end;

function GrepExpert.GetGlyph: HBITMAP;
begin
  Result := 0
end;

function GrepExpert.GetName: String;
begin
  Result := 'Grep'
end;

function GrepExpert.GetState: TExpertState;
begin
  Result := [esEnabled]
end;

function GrepExpert.GetMenuText: String;
begin
  Result := 'Grep'
end;

procedure GrepExpert.Execute;
begin
 if not Assigned(GrepForm) then
   GrepForm:= TGrepForm.Create(Application);
 GrepForm.Show;
 GrepForm.SetFocus;
end;

procedure TGrepForm.CancelButtonClick(Sender: TObject);
begin
 Close;
end;

procedure TGrepForm.LoadButtonClick(Sender: TObject);
var
 FileName : String;
begin
  FileName := FoundList.Items[FoundList.ItemIndex];
  if (FoundList.ItemIndex = -1) or not Assigned(ToolServices)then Exit;
  if UpperCase(ExtractFileExt(FileName)) = '.DPR' then begin
   if ToolServices.CloseProject then ToolServices.OpenProject(FileName);
  end else ToolServices.OpenFile(FileName);
end;

procedure TGrepForm.SearchButtonClick(Sender: TObject);
Var
 SearchFileX:String[79];
 SearchFile:String[12];
 SearchPath:String[67];
 SearchText:Array[0..50] of Char;
 DoRecurse,
 IgnoreCase:Boolean;

 function Search(AFile:String):Boolean;
 Var Stream:TFileStream;
     FileString:PChar;
     BufSize:Word;
 begin
  if StrLen(SearchText) = 0 then begin
   result:=true;
   Exit;
  end;
  Stream:=TFileStream.Create(AFile,fmOpenRead);
  if Stream.Size > 0 then begin
   BufSize:=$FFF0;
   if BufSize > (Stream.Size + 1) then BufSize:=Stream.Size + 1;
   FileString:=StrAlloc(BufSize);
   Repeat
    FileString[Stream.Read(FileString^,BufSize - 1)]:=#0;
    if IgnoreCase then StrUpper(FileString);
    Result:=StrPos(FileString,SearchText) <> Nil;
    if Stream.Position < Stream.Size then
     Stream.Position:=Stream.Position - StrLen(SearchText);
   Until Result or (Stream.Position >= Stream.Size);
   StrDispose(FileString);
  end else Result:=false;
  Stream.Free;
 end;

 procedure RecurseDirTree(NewPath : string);
 var
   SearchRec: TSearchRec;
   ReturnCode : Integer;
 begin
  if FindFirst(NewPath + SearchFile, faAnyFile, SearchRec) = 0 then repeat
   if (SearchRec.Attr and (faHidden or faSysFile or FaVolumeID)) = 0 then begin
    if Search(NewPath + SearchRec.Name) then begin
     FoundList.Items.Add(NewPath + SearchRec.Name);
     LoadButton.Enabled := True;
     Application.ProcessMessages;
    end;
   end;
   ReturnCode := FindNext(SearchRec);
  until ReturnCode <> 0;
  if DoRecurse then begin
   if FindFirst(NewPath + '*.*', faDirectory, SearchRec) = 0 then repeat
    if (SearchRec.Attr and faDirectory > 1) and (SearchRec.Name <> '.') and
       (SearchRec.Name <> '..') then RecurseDirTree(NewPath + SearchRec.Name + '\');
   until FindNext(SearchRec) <> 0;
  end;
 end;

begin
  LoadButton.Enabled := False;
  FoundList.Items.Clear;
  SearchFileX:=ExpandFileName(SearchFileName.Text);
  DoRecurse:=Directories.Checked;
  IgnoreCase:=IgCase.Checked;
  SearchFile:=ExtractFileName(SearchFileX);
  if Pos('.', SearchFile) = 0 then SearchFile:=SearchFile + '.PAS';
  SearchPath:=ExtractFilePath(SearchFileX);
  StrPCopy(SearchText,GrepForm.Search.Text);
  if IgnoreCase then StrUpper(SearchText);
  RecurseDirTree(SearchPath);
  if FoundList.Items.Count > 0 then FoundList.ItemIndex := 0
   else FoundList.Items.Add('No File(s) Found');
end;

procedure TGrepForm.FormShow(Sender: TObject);
begin
  Search.SetFocus;
end;

end.
