(***************************************************************)
(*       TITLE: LOCATE.PAS Copyright (c) 1995 Datacraft, Inc.  *)
(* DESCRIPTION: Primary component unit for dbLocate. Makes     *)
(*              calls to ABOUT.DCU and FINDER.DCU and requires *)
(*              the corresponding *.dfm files for compilation. *)
(*                                                             *)
(*              The Search Engine Source is available. See     *)
(*              DBLOCATE.WRI                                   *)
(*                                                             *)
(***************************************************************)

unit Locate;

interface

uses
  SysUtils, WinTypes, WinProcs,Classes,Forms, Dialogs,DBTAbles,Dsgnintf;

type
  ETDBLocateError = class(Exception);
  TLocateEvent = procedure (Sender : TObject) of object;
  TDBLocate = class(TComponent)
  private
    { Private declarations }
     pAbout    : string;

  protected
    { Protected declarations }
  public
    { Public declarations }

    pUseDisplayLabels : boolean;
           pShowHints : Boolean;
         pSearchTable : TTable;
    procedure execute;
    procedure close;
  published
      { Published declarations }

    property SearchTable : TTable     {Table to be searched}
        read pSearchTable
       write pSearchTable;

    property About : string           {Design time about box}
        read pAbout
       write pAbout;

    property UseDisplayLabels : boolean   {Use display labels or natural field names}
        read pUseDisplayLabels
       write pUseDisplayLabels
     default false;

    property ShowHints : boolean     {Show hints on search form}
        read pShowHints
       write pShowHints
     default false;


 end;

 TAboutShow = class(TPropertyEditor)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

 TSearchTable = class(TComponentProperty);

procedure Register;

implementation

uses finder,about;

function TAboutShow.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

procedure TAboutShow.edit;
begin
  try
    Application.CreateForm(TAboutBox, AboutBox);
    AboutBox.showmodal;
  except
   on e : exception do
     messageDlg(e.message,mtError,[mbOk],0);
  end;
end;

procedure TDBLocate.close;
begin
 try
   findForm.close;
 except
  {do nothing}
 end;
end;

procedure TDBLocate.execute;
begin
  try
    if searchTable = nil then
      raise ETDBLocateError.create('SearchTable property is not assigned');

    if not searchTable.active then
      raise ETDBLocateError.create('Specified search table is not active.');

    if searchTable.indexFieldcount = 0 then
      raise ETDBLocateError.create('Specified search table must be indexed.');

    Application.CreateForm(TFindForm, FindForm);
    findForm.tb := SearchTable;
    findForm.UDN := useDisplayLabels;
    findForm.showHint := showHints;
    findForm.show;
  except
   on e : exception do
     messageDlg(e.message,mtError,[mbOk],0);
  end;
end;



procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(String),TDBLocate,'About',TAboutShow);
  RegisterPropertyEditor(TypeInfo(TTable),TDBLocate,'SearchTable',TSearchTable);
  RegisterComponents('Samples', [TDBLocate]);
end;

end.
