(*
 *  m a p i . pas
 *
 *  Messaging Applications Programming Interface.
 *
 *  Purpose:
 *    This file defines the structures and constants used by
 *    that subset of the messaging applications programming
 *    interface which will be supported under Windows by
 *    Microsoft Mail for PC Networks vesion 3.0.
 *)

Unit MAPI;
{$F+}
Interface
Uses
  Strings, WinTypes, WinProcs;

(*
  Types
*)

Type
  ULong = LongInt;
  LPULong = ^LongInt;
  Flags = LongInt;
  LHandle = LongInt;
  LPLHandle = ^LHandle;

Const
  lhSessionNull	: LongInt = 0;

Type
  PMapiFileDesc = ^TMapiFileDesc;
  TMapiFileDesc = Record
    ulReserved : LongInt;       (* Reserved for future use (must be 0) *)
    flFlags : LongInt;		(* Flags *)
    nPosition : LongInt;        (* character in text to be replaced by attachment *)
    lpszPathName : PChar;       (* Full path name of attachment file *)
    lpszFileName : PChar;       (* Original file name (optional) *)
    lpFileType : Pointer;       (* Attachment file type (optional) *)
  end;

Const

  MAPI_OLE	   : LongInt =	$00000001;
  MAPI_OLE_STATIC  : LongInt =	$00000002;

Type
  PMapiRecipDesc = ^TMapiRecipDesc;
  TMapiRecipDesc = Record
    ulReserved : LongInt;           (* Reserved for future use *)
    ulRecipClass : LongInt;         (* Recipient class *)
                                    (* MAPI_TO, MAPI_CC, MAPI_BCC, MAPI_ORIG *)
    lpszName : PChar;               (* Recipient name *)
    lpszAddress : PChar;            (* Recipient address (optional) *)
    ulEIDSize : LongInt;            (* Count in bytes of size of pEntryID *)
    lpEntryID : Pointer;            (* System-specific recipient reference *)
  end;

Const
  MAPI_ORIG =  0;           (* Recipient is message originator *)
  MAPI_TO   =  1;           (* Recipient is a primary recipient *)
  MAPI_CC   =  2;           (* Recipient is a copy recipient *)
  MAPI_BCC  =  3;           (* Recipient is blind copy recipient *)

Type
  PMapiMessage = ^TMapiMessage;
  TMapiMessage = Record
    ulReserved : LongInt;                   (* Reserved for future use (M.B. 0) *)
    lpszSubject : PChar;                  (* Message Subject *)
    lpszNoteText : PChar;                 (* Message Text *)
    lpszMessageType : PChar;              (* Message Class *)
    lpszDateReceived : PChar;             (* in YYYY/MM/DD HH:MM format    *)
    lpszConversationID : PChar;		(* conversation thread ID *)
    flFlags : Flags;                      (* unread,return receipt *)
    lpOriginator : pMapiRecipDesc;       (* Originator descriptor *)
    nRecipCount : ULong;                  (* Number of recipients *)
    lpRecips : pMapiRecipDesc;           (* Recipient descriptors *)
    nFileCount : ULong;                   (* # of file attachments *)
    lpFiles : pMapiFileDesc;             (* Attachment descriptors *)
  end;

Const

  MAPI_UNREAD            : LongInt = $00000001;
  MAPI_RECEIPT_REQUESTED : LongInt = $00000002;
  MAPI_SENT              : LongInt = $00000004;

(*
 *  Entry points.
 *)

  MAPI_LOGON_UI         : LongInt = $00000001;  (* Display logon UI *)
  MAPI_NEW_SESSION      : LongInt = $00000002;  (* Do not use default. *)
  MAPI_DIALOG           : LongInt = $00000008;  (* Display a send note UI *)
  MAPI_UNREAD_ONLY      : LongInt = $00000020;  (* Only unread messages *)
  MAPI_ENVELOPE_ONLY    : LongInt = $00000040;  (* Only header information *)
  MAPI_PEEK             : LongInt = $00000080;  (* Do not mark as read. *)
  MAPI_GUARANTEE_FIFO	: LongInt = $00000100;	(* use date order *)
  MAPI_BODY_AS_FILE	: LongInt = $00000200;
  MAPI_AB_NOMODIFY	: LongInt = $00000400;	(* Don't allow mods of AB entries *)
  MAPI_SUPPRESS_ATTACH	: LongInt = $00000800;	(* header + body, no files *)
  MAPI_FORCE_DOWNLOAD	: LongInt = $00001000;	(* force download of new mail during MAPILogon *)

Function MAPILogon(ulUIParam : ULong; lpszName, lpszPassword : PChar;
                   flFlags : Flags; ulReserved : ULong;
                   lplhSession : LPLHandle) : ULong;

Function MAPILogoff(lhSession : LHandle; ulUIParam : ULong; flFlags : Flags;
                    ulReserved : ULong) : ULong;

Function MAPISendMail(lhSession : LHandle; ulUIParam : ULong;
                      lpMessage : pMapiMessage; flFlags : Flags;
                      ulReserved : ULong) : ULong;

Function MAPISendDocuments(ulUIParam : ULONG; lpszDelimChar : PChar;
                           lpszFilePaths : PChar; lpszFileNames : PChar;
                           ulReserved : ULong) : ULong;

Function MAPIFindNext(lhSession : LHandle; ulUIParam : ULong;
                      lpszMessageType, lpszSeedMessageID : PChar;
                      flFlags : Flags; ulReserved : ULong;
                      lpszMessageID : PChar) : ULong;

Function MAPIReadMail(lhSession : LHandle; ulUIParam : ULong;
                      lpszMessageID : PChar; flFlags : Flags;
                      ulReserved : ULong; lppMessageOut : pMapiMessage) : ULong;

Function MAPISaveMail(lhSession : LHANDLE; ulUIParam : ULONG;
                      pMessage : pMapiMessage; flFlags : FLAGS;
                      ulReserved : ULONG; lpszMessageID : PChar) : ULong;

Function MAPIDeleteMail(lhSession : LHANDLE; ulUIParam : ULONG;
                        lpszMessageID : PChar; flFlags : Flags;
                        ulReserved : ULONG) : ULong;

Function MAPIFreeBuffer( pv : Pointer ) : ULong;

Function MAPIAddress(lhSession : LHandle; ulUIParam : ULONG;
	             plszCaption : PChar; nEditFields : ULONG;
		     lpszLabels : PChar; nRecips : ULONG;
		     lpRecips : pMapiRecipDesc; flFlags : FLAGS; ulReserved : ULONG;
		     lpnNewRecips : LPULONG; lppNewRecips : pMapiRecipDesc) : ULong;

Function MAPIDetails(lhSession : LHANDLE; ulUIParam : LHANDLE;
		     lpRecip : pMapiRecipDesc; flFlags : FLAGS; ulReserved : ULONG) : ULong;

Function MAPIResolveName(lhSession : LHANDLE; ulUIParam : ULONG;
			 lpszName : PChar; flFlags : FLAGS;
			 ulReserved : ULONG; lppRecip : pMapiRecipDesc) : ULong;

Const

  SUCCESS_SUCCESS                   =  0;
  MAPI_USER_ABORT                   =  1;
  MAPI_E_FAILURE                    =  2;
  MAPI_E_LOGIN_FAILURE              =  3;
  MAPI_E_DISK_FULL                  =  4;
  MAPI_E_INSUFFICIENT_MEMORY        =  5;
  MAPI_E_ACCESS_DENIED		    =  6;
  MAPI_E_TOO_MANY_SESSIONS          =  8;
  MAPI_E_TOO_MANY_FILES             =  9;
  MAPI_E_TOO_MANY_RECIPIENTS        =  10;
  MAPI_E_ATTACHMENT_NOT_FOUND       =  11;
  MAPI_E_ATTACHMENT_OPEN_FAILURE    =  12;
  MAPI_E_ATTACHMENT_WRITE_FAILURE   =  13;
  MAPI_E_UNKNOWN_RECIPIENT          =  14;
  MAPI_E_BAD_RECIPTYPE              =  15;
  MAPI_E_NO_MESSAGES                =  16;
  MAPI_E_INVALID_MESSAGE            =  17;
  MAPI_E_TEXT_TOO_LARGE             =  18;
  MAPI_E_INVALID_SESSION	    =  19;
  MAPI_E_TYPE_NOT_SUPPORTED	    =  20;
  MAPI_E_AMBIGUOUS_RECIPIENT	    =  21;
  MAPI_E_MESSAGE_IN_USE		    =  22;
  MAPI_E_NETWORK_FAILURE	    =  23;
  MAPI_E_INVALID_EDITFIELDS	    =  24;
  MAPI_E_INVALID_RECIPS		    =  25;
  MAPI_E_NOT_SUPPORTED		    =  26;

Implementation

Function MAPILogon;          external 'MAPI' Index 11;
Function MAPILogoff;         external 'MAPI' Index 12;
Function MAPISendMail;       external 'MAPI' Index 13;
Function MAPISendDocuments;  external 'MAPI' Index 10;
Function MAPIFindNext;       external 'MAPI' Index 16;
Function MAPIReadMail;       external 'MAPI' Index 15;
Function MAPISaveMail;       external 'MAPI' Index 14;
Function MAPIDeleteMail;     external 'MAPI' Index 17;
Function MAPIFreeBuffer;     external 'MAPI' Index 18;
Function MAPIAddress;        external 'MAPI' Index 19;
Function MAPIDetails;        external 'MAPI' Index 20;
Function MAPIResolveName;    external 'MAPI' Index 21;

end.