(*************************************)
(* Simple MAPI example for W4Wg      *)
(* (c) G.T. Swindell 1993.           *)
(* Parts (c) Microsoft Corp. 1992    *)
(*************************************)

Program MapiApp;
{$R MAPIAPP}
Uses
  Strings, WinTypes, WinProcs, ODialogs, OWindows, MAPI;

Const
  { Menu Constants }
  IDM_ACCESS       =  1000;
  IDM_A_LOGON      =  1050;
  IDM_A_LOGOFF     =  1100;
  IDM_SEND         =  2000;
  IDM_S_MAIL       =  2050;
  IDM_S_DOCUMENT   =  2100;
  IDM_MANIPULATE   =  3000;
  IDM_M_FINDFIRST  =  3040;
  IDM_M_FINDNEXT   =  3050;
  IDM_M_READ       =  3100;
  IDM_M_DELETE     =  3150;

  APPNAME : PChar = 'MAPIAPP';

{ Constants used in messages in this app }
  Orig : PChar = 'ONE';
  DateRec : PChar = '1993/03/30 09:00';

Var
  { Global variables }
  ULResult : ULong;
  mmMAPIMessage : TMAPIMessage;
  rdOriginator : TMAPIRecipDesc;
  flFlag : LongInt;

  szSeedMessageID,
  szMessageID,
  szSubject : Array[0..512] of Char;
  szNoteText : Array[0..4096] of Char;

Procedure InitMessage(M : PMAPIMessage);
{ Initialise the message structure }
begin
  { Message ID's initially blank }
  StrCopy(szSeedMessageID, '');
  StrCopy(szMessageID, '');
  StrCopy(szSubject, '');
  StrCopy(szNoteText, '');

  { Message structure initially blank }
  FillChar(M^, Sizeof(TMapiMessage), 0);
  FillChar(rdOriginator, Sizeof(TMAPIRecipDesc), 0);
  With rdOriginator do
  begin
    ulRecipClass := MAPI_ORIG; { We are sending here }
    lpszName := Orig;
  end;
  With M^ do
  begin
    lpszDateReceived := DateRec;
    lpOriginator := @rdOriginator;
    m^.flFlags := MAPI_UNREAD
  end;
end;

Type { Main window class }
  PMAPIAppWin = ^TMAPIAppWin;
  TMapiAppWin = object(TWindow)
    Constructor Init(AParent : PWindowsObject; ATitle : PChar);
    Procedure GetWindowClass(var AWndClass : TWndClass); virtual;
    Procedure Logon(var Msg : TMessage); virtual cm_First + IDM_A_Logon;
    Procedure Logoff(var Msg : TMessage); virtual cm_First + IDM_A_LOGOFF;
    Procedure SendMail(var Msg : TMessage); virtual cm_First + IDM_S_MAIL;
    Procedure SendDocuments(var Msg : TMessage); virtual cm_First + IDM_S_DOCUMENT;
    Procedure FindFirstMessage(var Msg : TMessage); virtual cm_First + IDM_M_FINDFIRST;
    Procedure FindNextMessage(var Msg : TMessage); virtual cm_First + IDM_M_FINDNEXT;
    Procedure ReadMessage(var Msg : TMessage); virtual cm_first + IDM_M_READ;
    Procedure DeleteMessage(var Msg : TMessage); virtual cm_First + IDM_M_DELETE;
  Private
    hMAPISESSION : LHandle;
    iFindFirst : Boolean;
  end;

Constructor TMapiAppWin.Init(AParent : PWindowsObject; ATitle : PChar);
Var
  nWndUnits : LongInt;
  nWndX, nWndY : Integer;
  nX, nY : Integer;
  nWidth, nHeight : Integer;

begin
  nWndUnits := GetDialogBaseUnits;
  nWndX := LoWord(nWndUnits);
  nWndY := HiWord(nWndUnits);
  nX := ROUND(((60 * nWndX) / 4));
  nY := ROUND(((60 * nWndY) / 8));
  nWidth := ROUND(((197 * nWndX) / 4));
  nHeight := ROUND(((138 * nWndX) / 8));

  Inherited Init(AParent, ATitle);
  With Attr do
  begin
    Style := WS_Caption + WS_SysMenu + WS_Minimizebox + WS_Maximizebox +
             WS_Border + WS_ClipChildren + WS_OverLapped;
    x := nX;
    y := nY;
    w := nWidth;
    h := nHeight;
    Menu := LoadMenu(hInstance, AppName);
    EnableMenuItem(Menu, IDM_A_LOGOFF, MF_Disabled OR MF_Grayed);
    EnableMenuItem(Menu, IDM_S_MAIL, MF_Disabled OR MF_Grayed);
    EnableMenuItem(Menu, IDM_S_DOCUMENT, MF_Disabled OR MF_Grayed);
    EnableMenuItem(Menu, IDM_M_FINDFIRST, MF_Disabled OR MF_Grayed);
    EnableMenuItem(Menu, IDM_M_FINDNEXT, MF_Disabled OR MF_Grayed);
    EnableMenuItem(Menu, IDM_M_READ, MF_Disabled OR MF_Grayed);
    EnableMenuItem(Menu, IDM_M_DELETE, MF_Disabled OR MF_Grayed);
  end;
  InitMessage(@mmMAPIMessage);
  iFindFirst := TRUE;
end;

Procedure TMapiAppWin.GetWindowClass(var AWndClass : TWndClass);
begin
  Inherited GetWindowClass(AWndClass);
  With AWndClass do
    hIcon := LoadIcon(hInstance, AppName);
end;

Procedure TMapiAppWin.Logon(var Msg : TMessage);
{ Logon on to the mail server }
begin
  flFlag := MAPI_New_Session + MAPI_Logon_UI; { set flags to show logon box if required }
  ulResult := MAPILogon(hWindow, NIL, NIL, flFlag, 0, @hMAPISession); { hMapISeesion - returned ID for this session }

  { All MAPI functions from this point on use hMAPISession }
  { as an identification flag                              }

  If ulResult=Success_Success then
  begin
    With Attr do
    begin
      EnableMenuItem(menu, IDM_A_LOGOFF, MF_Enabled);
      EnableMenuItem(menu, IDM_S_MAIL, MF_Enabled);
      EnableMenuItem(menu, IDM_S_DOCUMENT, MF_Enabled);
      EnableMenuItem(menu, IDM_M_FINDFIRST, MF_Enabled);
      EnableMenuItem(menu, IDM_M_FINDNEXT, MF_Enabled);
    end;
  end;
end;

Procedure TMapiAppWin.Logoff(var Msg : TMessage);
begin
  ulResult := MAPILogoff(hMAPISession, hWindow, 0, 0); { Logoff and close the Mail server }
  If ulResult=Success_Success then
  begin
    With Attr do
    begin
      EnableMenuItem(Menu, IDM_A_LOGOFF, MF_Disabled OR MF_Grayed);
      EnableMenuItem(Menu, IDM_S_MAIL, MF_Disabled OR MF_Grayed);
      EnableMenuItem(Menu, IDM_S_DOCUMENT, MF_Disabled OR MF_Grayed);
      EnableMenuItem(Menu, IDM_M_FINDFIRST, MF_Disabled OR MF_Grayed);
      EnableMenuItem(Menu, IDM_M_FINDNEXT, MF_Disabled OR MF_Grayed);
      EnableMenuItem(Menu, IDM_M_READ, MF_Disabled OR MF_Grayed);
      EnableMenuItem(Menu, IDM_M_DELETE, MF_Disabled OR MF_Grayed);
    end;
  end;
end;

Procedure TMapiAppWin.SendMail(var Msg : TMessage);
begin
  flFlag := MAPI_DIALOG; { Brings up default meesage creation dialog }
                         { Could also set up the message structure }
                         { directly and send without the need for the }
                         { in-built dialog }
  MAPISendMail(hMAPISession, hWindow, @mmMapiMessage, flFlag, 0);
end;

Procedure TMapiAppWin.SendDocuments(var Msg : TMessage);
begin
  { Send a default document }
  MAPISendDocuments(hWindow, ';', 'C:\CONFIG.SYS', 'CONFIG.SYS', 0);
end;

Procedure TMapiAppWin.FindFirstMessage(var Msg : TMessage);
begin
  { Position on the first message in the queue }
  iFindFirst := TRUE;
  FindNextMessage(Msg);
end;

Procedure TMapiAppWin.FindNextMessage(var Msg : TMessage);
begin
  if (iFindFirst) then
  begin
    StrCopy(szSeedMessageID, '');
    { Seed should be NULL to grab the first message }
    iFindFirst := FALSE;
  end
  else
    StrCopy(szSeedMessageID, szMessageID);

  { Get the ID of the next message in the queue }
  { SeedMessage is NULL for the first one }

  ulResult := MAPIFindNext(hMAPISession, hWindow, NIL, @szSeedMessageID, 0, 0, @szMessageID);

  { the returned szMessageID is a key used to access the mail item with }
  { read, delete, save functions                                        }

  With Attr do
  begin
    If ulResult = Success_Success then
    begin
      EnableMenuItem(menu, IDM_M_FINDNEXT, MF_Enabled);
      EnableMenuItem(menu, IDM_M_READ, MF_Enabled);
      EnableMenuItem(menu, IDM_M_DELETE, MF_Enabled);
    end
    else
    begin
      EnableMenuItem(menu, IDM_M_FINDNEXT, MF_DISABLED or MF_GRAYED);
      EnableMenuItem(menu, IDM_M_READ, MF_DISABLED or MF_GRAYED);
      EnableMenuItem(menu, IDM_M_DELETE, MF_DISABLED or MF_GRAYED);
    end;
  end;
end;

Procedure TMapiAppWin.ReadMessage(var Msg : TMessage);
Var
  lpMessage : pMapiMessage;
  szBuf : Array[0..1048] of Char;
  szMain : Array[0..2048] of Char;
  szTmp : Array[0..512] of Char;

  Function MyStrCopy(Dest, Src : PChar) : PChar;
  begin
    if src<>NIL then
      strcopy(dest, Src)
    else
      StrCopy(dest, '');
    MyStrCopy := Dest;
  end;

begin
  { Get the message with the current ID }
  ulResult := MAPIReadMail(hMAPISession, LongInt(hWindow), @szMessageID, 0, 0, @lpMessage);
  if ulResult=Success_Success then
  begin
    StrCopy(szMain, 'From : ');
    With lpMessage^ do
    begin
      { Display it }
      MyStrCopy(szTmp, lpOriginator^.lpszName);
      StrCat(szMain, szTmp);
      StrCat(szMain, #13'To : ');
      MyStrCopy(szTmp, lpRecips^.lpszName);
      StrCat(szMain, szTmp);
      StrCat(szMain, #13'Date : ');
      MyStrCopy(szTmp, lpszDateReceived);
      StrCat(szMain, szTmp);
      StrCat(szMain, #13'Subject : ');
      MyStrCopy(szTmp, lpszSubject);
      StrCat(szMain, szTmp);
      StrCat(szMain, #13#13);
      MyStrCopy(szTmp, lpszNoteText);
      StrCat(szMain, szTmp);
      MessageBox(hWindow, szMain, 'Message', MB_Ok);
      { Destroy the message buffer }
      MAPIFreeBuffer(lpMessage);
    end;
  end;
end;

Procedure TMapiAppWin.DeleteMessage(var Msg : TMessage);
begin
  { Remove the current message from the queue }
  ulResult := MAPIDeleteMail(hMapiSession, hWindow, @szMessageID, 0, 0);
  If ulResult = Success_Success then
  begin
    EnableMenuItem(attr.menu, IDM_M_READ, MF_DISABLED or MF_GRAYED);
    EnableMenuItem(attr.menu, IDM_M_DELETE, MF_DISABLED or MF_GRAYED);
  end;
end;

Type { Main application class }
  TMAPIApp_Application = object(TApplication)
     Procedure InitMainWindow; virtual;
  end;

Procedure TMAPIApp_Application.InitMAinWindow;
begin
  MainWindow := New(PMAPIAppWin, Init(Nil, 'MAPI Sample App'));
end;

var
  AMAPIApp : TMAPIApp_Application;

begin
  With AMAPIApp do
  begin
    Init('MAPIAPP');
    Run;
    Done;
  end;
end.