PROGRAM CallNamM;

USES WINTYPES,WINPROCS,WinCRT,Strings;

CONST
   MaxResults           = 20; {do not change}
   CertaintyThreshold   = 8;  {vary from 0 to 11}

TYPE
   ProofStrings   = array [1..MaxResults] of PChar;
   PCharMem       = array [0..255] of char;

FUNCTION INITLOAD(VAR MEMHDL:THANDLE;MaxDisp:integer;
		                FlName:PChar;VAR ErrRtn:integer):LONGBOOL;FAR;EXTERNAL
            'NAMEMCH' INDEX 1;
FUNCTION INITITEM(VAR MEMHDL:THANDLE;MaxDisp:integer;
                      ProofName:PChar;VAR ErrRtn:integer):LONGBOOL;
                      FAR;EXTERNAL
            'NAMEMCH' INDEX 2;
FUNCTION PERFORMMATCH(VAR MEMHDL:THANDLE;Trial:PChar;
                      VAR Certainty:integer;VAR NumResults:integer;
                      VAR ProofArry:ProofStrings;
                      VAR ErrRtn:integer):LONGBOOL;FAR;EXTERNAL
            'NAMEMCH' INDEX 3;
FUNCTION DESTROYMATCH(VAR MEMHDL:THANDLE;
                      VAR ErrRtn:integer):LONGBOOL;FAR;EXTERNAL
            'NAMEMCH' INDEX 4;

const
   TCols     = 30;
   PCols     = 40;

procedure FullCRT;
begin
   ScreenSize.X:=77;
   ScreenSize.Y:=100;
   WindowOrg.X:=0; 
   WindowOrg.Y:=0;
   WindowSize.X:=639; 
   WindowSize.Y:=481;
end;

function AlignNames(Reslt:PChar;Len1,Len2:integer;Trial,Proof:PChar):PChar;
var
   N           : integer;
   TLen        : integer;
   Lim         : integer;
   Stor        : PCharMem;
   aPStr       : PChar;
begin
   TLen:=Len1+Len2;
   if TLen>255 then
      begin
         Writeln('Oops, too long');
         Halt(999);
      end;
   aPStr:=Stor;
   for N:=0 to 254 do
      aPStr[N]:=' ';
   aPStr[255]:=#0;
   Lim:=StrLen(Trial);
   if Len1<=Lim then Lim:=Len1;
   for N:=0 to Lim-1 do
      aPStr[N]:=Trial[N];
   Lim:=Len1+StrLen(Proof);
   if TLen<Lim then Lim:=TLen;
   for N:=Len1 to Lim-1 do
      aPStr[N]:=Proof[N-Len1];
   aPStr[TLen-1]:=#0;
   StrCopy(Reslt,aPStr);
   AlignNames:=Reslt;
end;

procedure UsersChoice(Reslt,Trial:PChar;Certainty,NumResults:integer;
                  var ProofArry:ProofStrings);
var
   N           : integer;
   Choice      : integer;
   Code        : integer;
   aStr        : string[255];
begin
   Writeln;
   Writeln('   ',Trial,'   certainty=',Certainty);
   Writeln;
   for N:=1 to NumResults do
      Writeln(N:2,' ',ProofArry[N]);
   Writeln('Choice > [1 to ',NumResults,'] [9=no match] [corrected string]');
   Write('Choice > ');
   Readln(aStr);
   if length(aStr)=0 then
      Choice:=1
   else
      if ((length(aStr)=1) and (aStr[1] in ['0'..'9']))
                           OR
         ((length(aStr)=2) and (aStr[1] in ['0'..'9']) and
                               (aStr[2] in ['0'..'9'])) then

         Val(aStr,Choice,Code)

      else
         begin
            StrPCopy(Reslt,aStr);
            AlignNames(Reslt,TCols,PCols,Trial,Reslt);
            EXIT;
         end;
   if Choice=9 then
      StrCopy(Reslt,'*nm*')
   else
      if (Choice>=1) and (Choice<=NumResults) then
         StrCopy(Reslt,ProofArry[Choice])
      else
         StrCopy(Reslt,'*ERROR*');
   AlignNames(Reslt,TCols,PCols,Trial,Reslt);
end;

VAR
   N           : integer;
   ErrRtn      : integer;
   Certainty   : integer;
   NumResults  : integer;
   MemHdl      : THandle;
   ProofFN     : PChar;
   TrialFN     : PChar;
   ResltFN     : PChar;
   TrialMe2    : PCharMem;
   Trial       : PChar;
   ResltMe2    : PCharMem;
   Reslt       : PChar;
   PStor       : PCharMem;
   aPStr       : PChar;
   TrialFl     : Text;
   ResultFl    : Text;
   ProofArry   : ProofStrings;
BEGIN
   FullCRT;
   Writeln;
   Writeln('NameMch.dll Test');
   Writeln;
   Trial:=TrialMe2;
   Reslt:=ResltMe2;
   aPStr:=PStor;

   ProofFN:='proof.txt';
   TrialFN:='trial.txt';
   ResltFN:='MTCHTEST.txt';

   MemHdl:=0;              {IMPORTANT: Initialize before 1st call}

   if not INITLOAD(MemHdl,5,ProofFN,ErrRtn) then
      begin
         Writeln('Oops:',ErrRtn);
         Halt(999);
      end;
   Assign(TrialFl,TrialFN);
   Assign(ResultFl,ResltFN);
   Reset(TrialFl);
   if IOResult<>0 then
      begin
         Writeln('Cannot open ',TrialFN);
         Halt(999);
      end;
   Rewrite(ResultFl);
   if IOResult<>0 then
      begin
         Writeln('Cannot open ',ResltFN);
         Halt(999);
      end;
   Writeln('Press Enter for default Choice of 1');
   repeat
      Readln(TrialFl,TrialMe2);
      if not PERFORMMATCH(MemHdl,Trial,Certainty,
                          NumResults,ProofArry,ErrRtn) then
         begin
            Writeln('Oops2:',ErrRtn);
            Halt(999);
         end;
      if Certainty>=CertaintyThreshold then
         begin
            AlignNames(Reslt,TCols,PCols,Trial,ProofArry[1]);
            Writeln(ResultFl,Reslt);
         end
      else
         begin
            UsersChoice(Reslt,Trial,Certainty,NumResults,ProofArry);
            Writeln(ResultFl,Reslt);
         end;
   until EOF(TrialFl);
   Close(ResultFl);
   if not DESTROYMATCH(MemHdl,ErrRtn) then
      begin
         Writeln('Oops3:',ErrRtn);
         Halt(999);
      end;
   Writeln;
   Writeln('File ',ResltFN,' created');
   Writeln;
   Write('Done. Press Enter to exit...');
   Readln;
   DoneWinCRT;
END.
