unit Main;

{original MCHTXT.ZIP by Paul Onstad	CompuServe ID 70641,3236}
{Delphi.zip demo file for Delphi by R. Curzon, Solid Systems Inc.
  	CompuServe ID 71371,2521    ssi@interlog.com}

interface

uses
  SysUtils, WinTypes, WinProcs, Forms, Dialogs, Classes, Controls, StdCtrls;

TYPE
  ProofStrings  = array [1..20] of PChar;

type
  TForm1 = class(TForm)
    btnMatch: TButton;
    memMatches: TMemo;
    edtName: TEdit;
    Label1: TLabel;
    lstProof: TListBox;
    btnAddItem: TButton;
    btnDeleteSelected: TButton;
    Label2: TLabel;
    btnClearList: TButton;
    btnReloadList: TButton;
    lblMemHdl: TLabel;
    procedure btnMatchClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnAddItemClick(Sender: TObject);
    procedure btnClearListClick(Sender: TObject);
    procedure btnReloadListClick(Sender: TObject);
    procedure btnDeleteSelectedClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
    ProofArry  : ProofStrings;
        ErrRtn,
    Certainty,
    NumResults : Integer;
    FlName     : PChar;
    TrialName  : String;
    procedure FuzzyLoad(Items: TStrings);
    procedure LoadFromFile(rstrFileName: String);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------match}
FUNCTION INITLOAD     (VAR MEMHDL:THANDLE;MaxDisp:integer;
            		      FlName:PChar;VAR ErrRtn:integer):LONGBOOL;
            		      FAR;EXTERNAL
            'NAMEMCH' INDEX 1;
FUNCTION INITITEM     (VAR MEMHDL:THANDLE;MaxDisp:integer;
                      ProofName:PChar;VAR ErrRtn:integer):LONGBOOL;
                      FAR;EXTERNAL
            'NAMEMCH' INDEX 2;
FUNCTION PERFORMMATCH (VAR MEMHDL:THANDLE;Trial:PChar;
                      VAR Certainty:integer;VAR NumResults:integer;
                      VAR ProofArry:ProofStrings;
                      VAR ErrRtn:integer):LONGBOOL;FAR;EXTERNAL
            'NAMEMCH' INDEX 3;
FUNCTION DESTROYMATCH (VAR MEMHDL:THANDLE;
                      VAR ErrRtn:integer):LONGBOOL;FAR;EXTERNAL
            'NAMEMCH' INDEX 4;  {resets MemHdl}


var
  MemHdl     : THandle;  {reset to zero before first use}

const
  gcstrPROOFFILE  = 'proof.txt';

{------match}

type
  TDLLMode = (FUZZINIT, FUZZMATCH);
   {
   FUZZINIT is the startup DLLMode.  It tells .Add that it's
     okay to add a new item with InitItem.
     Otherwise, Add must DestroyMatch, and
        recreate the current proof list before adding to it.
     Add does that, then sets AppMode to FUZZINIT.
   FUZZMATCH mode is set by the PerformMatch routine.
   Clear clears the visible list and then:
     if DLLMode is FUZZMATCH, calls DestroyMatch
     else, reset MemHdl to zero... subsequent Match tests for zero.
       ... got it? <g>
   }

var
  gDLLMode : TDLLMode;

procedure TForm1.LoadFromFile(rstrFileName: String);
 {indifferent re DLLMode}
begin
  try
    lstProof.Items.LoadFromFile(ExtractFilePath(Application.ExeName) +
            rstrFileName)
  except
    on E:Exception do
      begin
        MessageBeep(MB_ICONEXCLAMATION);
        ShowMessage('Error loading proof string file: ' + #13 + E.Message);
        raise Exception.Create('User notified, caller to handle cleanup only');
      end;
  end; {exception}
end;

procedure TForm1.btnMatchClick(Sender: TObject);
var
    N          : Integer ;
begin
  edtName.SelectAll;
  lblMemHdl.Caption := Format('MemHdl: %d',[MemHdl]);

  if (MemHdl = 0) then exit;  {nothing to compare}
  gDLLMode := FUZZMATCH;
  TrialName:=edtName.Text + #0;  {make usable as asciiz string}
  if not PerformMatch(MemHdl,@TrialName[1],Certainty,NumResults,
                      ProofArry,ErrRtn)   then
    begin
      ShowMessage ( Format( 'PerformMatch failed! (err=%d)',
          [ErrRtn]) );
      exit;
    end;
  memMatches.Clear;
  for N:=1 to NumResults do
    begin
      memMatches.Lines.Add(Format('%s [%d]',[ProofArry[N], Certainty]));
    end;

  lblMemHdl.Caption := Format('MemHdl: %d',[MemHdl]);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  gDLLMode := FUZZINIT;
  try
    try
      LoadFromFile(gcstrPROOFFILE)
    except; {LoadFromFile handles error and notifies user, but
            reraises error; here we just want to do "finally" clause cleanup}
    end;
  finally
    FuzzyLoad(lstProof.Items);
    lblMemHdl.Caption := Format('MemHdl: %d',[MemHdl]);
  end;
end;

procedure TForm1.FuzzyLoad(Items: TStrings);
var
  i:       Integer;
  astrTemp: String;
begin
  For i := 0 to Items.Count - 1 do
    begin
      astrTemp := Items[i] + #0; {make usable as asciiz string}
      if not InitItem( MemHdl, 5, @astrTemp[1], ErrRtn ) then
        begin
          ShowMessage ( Format( 'InitItem failed! (err=%d at item %d)',
            [ErrRtn, i]) );
          exit;
        end;
    end; {for Items}
end;

procedure TForm1.btnAddItemClick(Sender: TObject);
var
  astrTemp: String;
begin
  edtName.SelectAll;
  if gDLLMode = FUZZMATCH then {must destroy match, and recreate
       proof list before adding a new item}
    begin
      if not DestroyMatch( MemHdl, ErrRtn )      then
        begin
          ShowMessage ( Format( 'DestroyMatch failed! (err=%d)',
              [ErrRtn]) );
          exit;
        end;
      FuzzyLoad(lstProof.Items);
      gDLLMode := FUZZINIT
    end;
  lstProof.Items.Insert(0, edtName.Text);
  astrTemp := edtName.Text + #0; {make usable as asciiz string}
  if not InitItem( MemHdl, 5, @astrTemp[1], ErrRtn ) then
    begin
      ShowMessage ( Format( 'InitItem failed! (err=%d)',
        [ErrRtn] ) );
      exit;
    end;
  lblMemHdl.Caption := Format('MemHdl: %d',[MemHdl]);
end;

procedure TForm1.btnClearListClick(Sender: TObject);
begin
  if gDLLMode = FUZZMATCH then {must destroy match memory}
    begin
      if not DestroyMatch( MemHdl, ErrRtn )      then
        begin
          ShowMessage ( Format( 'DestroyMatch failed! (err=%d)',
              [ErrRtn]) );
          exit;
        end;
      gDLLMode := FUZZINIT
    end
  else
    MemHdl := 0; {reinitialize, then next DLL call must be Initxxxx}
  lstProof.Clear;
  lblMemHdl.Caption := Format('MemHdl: %d',[MemHdl]);
end;

procedure TForm1.btnReloadListClick(Sender: TObject);
begin
  btnClearListClick(Sender);
  try
    LoadFromFile(gcstrPROOFFILE);
  except
    lblMemHdl.Caption := Format('MemHdl: %d',[MemHdl]);
    Exit;  {LoadFromFile notifies user, and reraises exception.
            Here, we just want to exit and forget the reload}
  end; {exception}
  FuzzyLoad(lstProof.Items);
  lblMemHdl.Caption := Format('MemHdl: %d',[MemHdl]);
  gDLLMode := FUZZINIT;
end;

procedure TForm1.btnDeleteSelectedClick(Sender: TObject);
  {for non-multi select mode}
var
  i: Integer;
  astrTemp: String;
begin
  If lstProof.ItemIndex <> -1 then
    lstProof.Items.Delete(lstProof.ItemIndex);
    MemHdl := 0;
    for i := 0 to lstProof.Items.Count-1 do
      begin
        astrTemp := lstProof.Items[i] + #0; {make usable as asciiz string}
        if not InitItem( MemHdl, 5, @astrTemp[1], ErrRtn ) then
          begin
            ShowMessage ( Format( 'InitItem failed! (err=%d at item %d)',
              [ErrRtn, i]) );
            exit;
          end;
      end; {if itemindex <> -1 ; for Items.count}
  lblMemHdl.Caption := Format('MemHdl: %d',[MemHdl]);
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if gDLLMode = FUZZMATCH then {must destroy match memory}
    begin
      if not DestroyMatch( MemHdl, ErrRtn )      then
        begin
          ShowMessage ( Format( 'DestroyMatch failed! (err=%d)',
              [ErrRtn]) );
          exit;
        end;
      gDLLMode := FUZZINIT
    end;
end;

end.
