unit Calc;
(***********************************************************************
  simple calculator for Delphi programs
  by Martin Austermeier CIS 100116,3455
  Version 1.1 - 10.10.95:
    * corrected embarassing subtract bug
    * "overflow" error display
    * deleted some unnecessary code
  --------------------------------------------------------------

  This is not a component; just include it with "USES Calc".

  Sorry, I don't have the time to write mucho documentation.
  Only a few items:
    * you might want to change the Form's Caption.

    * the calculator is designed to show results with two decimal places.
      Look at SetResult (PRECISION, DECIMAL_PLACES) if you want to change this.

    * there are only the basic functions.
      Not even a "percent" button.. ;-)
      If you integrate new buttons, you should set their "Tag" property,
      and process them like in CalcButtonClick()

    * I invoke the calculator as a modal form (see ShowCalculator).
      You'd have to write a Close mechanism if you want to use it as
      a non-modal window.

    * a typical call would look like
        var myNumber : Double;
        begin
          myNumber := 123.45;
          if Calc.Showcalculator(myNumber) then [myNumber has changed];
        end;
**********************************************************************)

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes,
  Forms, Buttons, Controls, StdCtrls, ExtCtrls;

type
  TCalcStatus = (CS_FIRST, CS_VALID, { the rest is error stati }
                 CS_ERROR, CS_OVERFLOW);

type
  TCalculator = class(TForm)
    MainPanel: TPanel;
    DisplayPanel: TPanel;
    BottomPanel: TPanel;
    Panel3: TPanel;
    resultLabel: TLabel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Button0: TButton;
    ButtonComma: TButton;
    ButtonDiv: TButton;
    ButtonMult: TButton;
    ButtonSub: TButton;
    ButtonAdd: TButton;
    ButtonSign: TButton;
    ButtonC: TButton;
    ButtonEq: TButton;
    okBtn: TBitBtn;
    cancelBtn: TBitBtn;
    procedure CalcButtonClick(Sender: TObject);
    procedure OkBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private-Deklarationen }
    fResult : Double;
    fDisplayText : String[30];
    fStatus : TCalcStatus;
    operand : Double;
    operator : Char;

    procedure SetResult(r : Double);
    function GetResult : Double;
    procedure SetStatus(stat : TCalcStatus);
    procedure SetDisplayText(s : String);
    function GetDisplayText : String;
    property Status : TCalcStatus read fStatus write SetStatus;
    property DisplayText : String read GetDisplayText write SetDisplayText;

  public
    { Public-Deklarationen }
    property CalcResult : Double read GetResult write SetResult;

    procedure Clear;
  end;

var
  Calculator: TCalculator;

function ShowCalculator(var number : Double) : Boolean;
{ display modal (inital result=number); return "number", if TRUE }

implementation

{$R *.DFM}

function ShowCalculator(var number : Double) : Boolean;
begin
  Calculator := TCalculator.Create(application);
  try
    Calculator.CalcResult := number;
    if (Calculator.ShowModal = MROK) then
      number := Calculator.CalcResult;
  finally
    Calculator.Free;
  end;
end;


procedure TCalculator.SetResult(r : Double);
const
  PRECISION = 15;
  DECIMAL_PLACES = 2;
begin
  fResult := r;
  DisplayText := FloatToStrF(fResult, ffFixed, PRECISION, DECIMAL_PLACES);
end;


function TCalculator.GetResult : Double;
begin
  result := StrToFloat(DisplayText);
end;


procedure TCalculator.SetStatus(stat : TCalcStatus);
begin
  fStatus := stat;
  if (fStatus >= CS_ERROR) then
    MessageBeep(MB_ICONSTOP);
end;


procedure TCalculator.SetDisplayText(s : String);
const
  MAX_LEN = 17;  { max# digits in display }
begin
  if (Length(s) <= MAX_LEN) then
    resultLabel.Caption := s
  else begin
    Status := CS_OVERFLOW;
  end;
end;


function TCalculator.GetDisplayText : String;
begin
  result := resultLabel.Caption;
end;


procedure TCalculator.FormCreate(Sender: TObject);
begin
  Clear;
end;


procedure TCalculator.Clear;
begin
  Status := CS_FIRST;
  DisplayText := '0';
  operand := 0;
  operator := #0;
end;


procedure TCalculator.CalcButtonClick(Sender: TObject);
var
  k : Char;
begin
  if (Sender is TButton) then begin
    ButtonEq.SetFocus;  { default button }
    k := Char(TButton(Sender).Tag);
    FormKeyPress(Sender, k);
  end;
end;


procedure TCalculator.OkBtnClick(Sender: TObject);
var
  k : Char;
begin
  k := '=';
  FormKeyPress(self, k);  { simulate "=" to get result }
end;


procedure TCalculator.FormKeyPress(Sender: TObject; var Key: Char);
const
  KEY_SIGN = '#';
  KEY_CLEAR = 'C';
  KEY_DECIMAL = '.';

  ERR_TXT = 'Error';
  OFL_TXT = 'Overflow';

var
  k : Char;
begin
  k := UpCase(key);

  if (k = decimalSeparator) then
    k := KEY_DECIMAL;

  if (Status < CS_ERROR)
  or (k = KEY_CLEAR) then
  case k of
    '0'..'9': begin
      if (Status = CS_FIRST) or (DisplayText = '0') then
        DisplayText := '';
      Status := CS_VALID;
      DisplayText := DisplayText + k;
    end;

    #8 : begin
      if (Length(DisplayText) > 0) then begin
        DisplayText := Copy(DisplayText, 1, Length(DisplayText)-1);
        if (Length(DisplayText) = 0) then
          DisplayText := '0';
        Status := CS_VALID;
      end;
    end;

    KEY_DECIMAL: begin
      if (Pos(decimalSeparator, DisplayText) = 0) then
        DisplayText := DisplayText + decimalSeparator;
      Status := CS_VALID;
    end;

    '+', '-', '/', '*', '=' : begin
      case operator of
        '+': begin
          CalcResult := operand + CalcResult;
        end;

        '-': begin
          CalcResult := operand - CalcResult;
        end;

        '*': begin
          CalcResult := operand * CalcResult;
        end;

        '/': begin
          if (CalcResult = 0) then
            Status := CS_ERROR
          else
            CalcResult :=  operand / CalcResult;
        end;

      end;

      if (Status <> CS_ERROR) then begin
        Status := CS_FIRST;
        operand := CalcResult;
        operator := k;
      end;
    end;

    KEY_SIGN: begin
      CalcResult := -CalcResult;
    end;

    KEY_CLEAR: begin
      Clear;
    end;

  end;

  case Status of  { in case of error.. }
    CS_ERROR : DisplayText := ERR_TXT;
    CS_OVERFLOW : DisplayText := OFL_TXT;
  end;
end;


end.

