unit Flame;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
  TFlameType=(FlameUp, FlameLeft, FlameRight, FlameOnMoon);
  PFlameField=^TFlameField;
  TFlameField=Array[0..100,0..159] of Word;
  PBitmapData=^TBitmapData;
  TBitmapData=Array[0..199,0..319] of Byte;

type
  TFlame = class(TGraphicControl)
  private
    { Private-Deklarationen }
    constructor create(aowner:tcomponent); override;
    destructor destroy; override;
    procedure paint; override;
  protected
    FPalette:HPalette;
    FBitmap:PBitmapData;
    FColorAdd:Byte;
    FFlameType:TFlameType;
    FFlameField:PFlameField;
    { Protected-Deklarationen }
    procedure makepalette; virtual;
    procedure killpalette; virtual;
    function getpalette:hpalette; override;
    procedure DoFlameUp; virtual;
    procedure DoFlameLeft; virtual;
    procedure DoFlameRight; virtual;
    procedure DoFlameOnMoon; virtual;
  public
    { Public-Deklarationen }
    procedure DoFlame; virtual;
    procedure MakeRandomLine(y:byte); virtual;
    procedure SetFlamePixel(x,y:byte); virtual;
    procedure DrawChar(x,y:byte; ch:char); virtual;
    procedure DrawText(x,y:byte; st:string); virtual;
  published
    { Published-Deklarationen }
    property FlameType:TFlametype read FFlameType write FFlameType default FlameUp;
    property Height default 200;
    property OnClick;
    property Width default 320;
  end;

procedure Register;

implementation

constructor tflame.create;
var
  x,y:integer;
begin
  inherited create(aowner);
  makepalette;
  fflametype:=flameup;
  fcoloradd:=0;
  height:=200;
  width:=320;
  new(fbitmap);
  new(fflamefield);
  fillchar(fbitmap^,64000,0);
  fillchar(fflamefield^,32000,0);
end;

destructor tflame.destroy;
begin
  dispose(fflamefield);
  dispose(fbitmap);
  killpalette;
  inherited destroy;
end;

procedure tflame.paint;
var
  dc:hdc;
  BitsInfo:pbitmapinfo;
  i:integer;
  oldpal:hpalette;
begin
  dc:=canvas.handle;
  oldpal:=selectpalette(dc,fpalette,false);
  getmem(bitsinfo,sizeof(tbitmapinfoheader)+256*2);
  with bitsinfo^ do begin
    with bmiheader do begin
      bisize:=40;
      biwidth:=320;
      biheight:=200;
      biplanes:=1;
      bibitcount:=8;
      bicompression:=0;
      bisizeimage:=64000;
      bixpelspermeter:=0;
      biypelspermeter:=0;
      biclrused:=256;
      biclrimportant:=256;
    end;
    for i:=0 to 127 do begin
      bmicolors[i].rgbblue:=2*i+fcoloradd;
      bmicolors[i].rgbgreen:=0;
      bmicolors[i].rgbred:=2*i+1+fcoloradd;
      bmicolors[i].rgbreserved:=0;
    end;
  end;
  setdibitstodevice(dc,0,0,width,height, 0,0,0,200,FBitmap,
  Bitsinfo^,dib_Pal_Colors);
  freemem(bitsinfo,sizeof(tbitmapinfoheader)+256*2);
  selectpalette(dc,oldpal,false);
end;

procedure tflame.makepalette;
var
  pal:plogpalette;
  i:integer;

  procedure setpalettereg(c,r,g,b:byte);
  begin
    pal^.palpalentry[c].pered:=r shl 2;
    pal^.palpalentry[c].pegreen:=g shl 2;
    pal^.palpalentry[c].peblue:=b shl 2;
    pal^.palpalentry[c].peflags:=0;
  end;

begin
  getmem(pal,4+256*4);
  fillchar(pal^,4+256*4,0);
  pal^.palVersion:=$300;
  pal^.palNumEntries:=256;
  for i:=0 to 63 do setpalettereg(i,i,0,0);
  for i:=0 to 63 do setpalettereg(64+i,63,i,0);
  for i:=0 to 63 do setpalettereg(128+i,63,63,i);
  for i:=0 to 63 do setpalettereg(192+i,63,63,63);
  fpalette:=createpalette(pal^);
  freemem(pal,4+256*4);
end;

procedure tflame.killpalette;
begin
  deleteobject(fpalette);
end;

function tflame.getpalette;
begin
  getpalette:=fpalette;
end;

procedure tflame.doflameup;
var
  fieldptr,bitmapptr:pointer;
  y:word;
begin
  fieldptr:=fflamefield;
  bitmapptr:=fbitmap;
  for y:=0 to 97 do asm
    push ds
    les di,bitmapptr
    mov ax,640
    mov bx,99
    sub bx,y
    mul bx
    add di,ax

    lds si,fieldptr
    mov ax,320
    mul y
    add si,ax

    mov cx,160
  @schleifex:

    mov ax,[si+159*2]
    add ax,[si+160*2]
    add ax,[si+161*2]
    add ax,[si+320*2]
    shr ax,2
    cmp ax,0
    je @keindec
    dec ax
  @keindec:
    mov [si],ax
    add si,2
    mov ah,al
    mov es:[di-1],ax
    mov es:[di-321],ax
    sub di,2

    loop @schleifex
    pop ds
  end;
end;

procedure tflame.doflameLeft;
var
  fieldptr,bitmapptr:pointer;
  y:word;
begin
  fieldptr:=fflamefield;
  bitmapptr:=fbitmap;
  for y:=0 to 97 do asm
    push ds
    les di,bitmapptr
    mov ax,640
    mov bx,99
    sub bx,y
    mul bx
    add di,ax

    lds si,fieldptr
    mov ax,320
    mul y
    add si,ax

    mov cx,160
  @schleifex:

    mov ax,[si+159*2]
    add ax,[si+160*2]
    add ax,[si+161*2]
    add ax,[si+319*2]
    shr ax,2
    cmp ax,0
    je @keindec
    dec ax
  @keindec:
    mov [si],ax
    add si,2
    mov ah,al
    mov es:[di-1],ax
    mov es:[di-321],ax
    sub di,2

    loop @schleifex
    pop ds
  end;
end;

procedure tflame.doflameright;
var
  fieldptr,bitmapptr:pointer;
  y:word;
begin
  fieldptr:=fflamefield;
  bitmapptr:=fbitmap;
  for y:=0 to 97 do asm
    push ds
    les di,bitmapptr
    mov ax,640
    mov bx,99
    sub bx,y
    mul bx
    add di,ax

    lds si,fieldptr
    mov ax,320
    mul y
    add si,ax

    mov cx,160
  @schleifex:

    mov ax,[si+159*2]
    add ax,[si+160*2]
    add ax,[si+161*2]
    add ax,[si+321*2]
    shr ax,2
    cmp ax,0
    je @keindec
    dec ax
  @keindec:
    mov [si],ax
    add si,2
    mov ah,al
    mov es:[di-1],ax
    mov es:[di-321],ax
    sub di,2

    loop @schleifex
    pop ds
  end;
end;

procedure tflame.doflameonmoon;
var
  fieldptr,bitmapptr:pointer;
  y:word;
begin
  fieldptr:=fflamefield;
  bitmapptr:=fbitmap;
  for y:=1 to 98 do asm
    push ds
    les di,bitmapptr
    mov ax,640
    mov bx,99
    sub bx,y
    mul bx
    add di,ax

    lds si,fieldptr
    mov ax,320
    mul y
    add si,ax

    mov cx,160
  @schleifex:

    mov ax,[si-160*2]
    add ax,[si-1*2]
    add ax,[si+1*2]
    add ax,[si+160*2]
    shr ax,2
{    cmp ax,0
    je @keindec
    dec ax
  @keindec: }
    mov [si],ax
    add si,2
    mov ah,al
    mov es:[di-1],ax
    mov es:[di-321],ax
    sub di,2

    loop @schleifex
    pop ds
  end;
end;

procedure tflame.DoFlame;
var
  x,y:integer;
begin
  case fflametype of
    flameup:doflameup;
    flameLeft:doflameLeft;
    flameRight:doflameRight;
    flameonmoon:doflameonmoon;
  end;
  paint;
end;

procedure tflame.MakeRandomLine;
var
  x:word;
begin
  for x:=10 to 149 do fflamefield^[y,x]:=random(2)*256;
end;

procedure tflame.setflamepixel;
begin
  if (x<0) or (x>159) or (y<0) or (y>199) then exit;
  fflamefield^[y,x]:=256;
end;

procedure tflame.DrawChar;
begin
end;

procedure tflame.DrawText;
begin
end;

procedure Register;
begin
  RegisterComponents('Laschat', [TFlame]);
end;

end.
