unit Main;

interface

uses Messages, WinTypes, WinProcs, Classes, Graphics, Forms, Controls,
     StdCtrls, MSComm, ExtCtrls, Menus, SysUtils, Dialogs, config, about;
type
  TfrmMain = class(TForm)
    memIn: TMemo;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Help1: TMenuItem;
    Configure1: TMenuItem;
    About1: TMenuItem;
    Exit1: TMenuItem;
    memOut: TMemo;
    Port1: TMenuItem;
    Open1: TMenuItem;
    Close1: TMenuItem;
    N1: TMenuItem;
    MSComm1: TMSComm;
    procedure MSComm1Receive(Sender: TObject; Count: Word);
    procedure Configure1Click(Sender: TObject);
    procedure memOutKeyPress(Sender: TObject; var Key: Char);
    procedure FormResize(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure OpenPort;
    procedure ClosePort;
    procedure Open1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
  private
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

{ fired when we get data from the serial port. Takes the data and
 sends it to the memo component as a keypress windows message.
 I'm not sure this is the most efficient way to do this (?) }
procedure TfrmMain.MSComm1Receive(Sender: TObject; Count: Word);
var
  aChar: Char;
  i: Word;
begin
  for i := 1 to Count do
  begin
    MSComm1.Read(@aChar, SizeOf(aChar));
    SendMessage(memIn.Handle, WM_CHAR, Word(aChar),0);
  end;
end;


{ lets user fritz around with the serial component settings }
procedure TfrmMain.Configure1Click(Sender: TObject);
begin
  { shouldn't be able to change port # if port is open }
  frmSettings.cboPort.Enabled := Open1.Enabled;
  { read settings from comm control into settings dialog }
  frmSettings.cboPort.ItemIndex := MSComm1.Port;
  frmSettings.cboBaud.ItemIndex := Ord(MSComm1.BaudRate);
  frmSettings.cboData.ItemIndex := Ord(MSComm1.DataBits);
  frmSettings.cboParity.ItemIndex := Ord(MSComm1.ParityBits);
  frmSettings.cboStop.ItemIndex := Ord(MSComm1.StopBits);
  frmSettings.cboFlow.ItemIndex := Ord(MSComm1.FlowControl);
  { show settings dialog }
  frmSettings.ShowModal;
  { copy settings from dialog into comm control }
  MSComm1.Port := frmSettings.cboPort.ItemIndex;
  case frmSettings.cboBaud.ItemIndex of
    0: MSComm1.BaudRate := br110;
    1: MSComm1.BaudRate := br300;
    2: MSComm1.BaudRate := br600;
    3: MSComm1.BaudRate := br1200;
    4: MSComm1.BaudRate := br2400;
    5: MSComm1.BaudRate := br4800;
    6: MSComm1.BaudRate := br9600;
    7: MSComm1.BaudRate := br14400;
    8: MSComm1.BaudRate := br19200;
    9: MSComm1.BaudRate := br38400;
    10: MSComm1.BaudRate := br56000;
    11: MSComm1.BaudRate := br128000;
    12: MSComm1.BaudRate := br256000;
  end;
  case frmSettings.cboParity.ItemIndex of
    0: MSComm1.ParityBits := pbNone;
    1: MSComm1.ParityBits := pbOdd;
    2: MSComm1.ParityBits := pbEven;
    3: MSComm1.ParityBits := pbMark;
    4: MSComm1.ParityBits := pbSpace;
  end;
  case frmSettings.cboData.ItemIndex of
    0: MSComm1.DataBits := dbFour;
    1: MSComm1.DataBits := dbFive;
    2: MSComm1.DataBits := dbSix;
    3: MSComm1.DataBits := dbSeven;
    4: MSComm1.DataBits := dbEight;
  end;
  case frmSettings.cboStop.ItemIndex of
    0: MSComm1.StopBits := sbOne;
    1: MSComm1.StopBits := sbOnePointFive;
    2: MSComm1.StopBits := sbTwo;
  end;
  case frmSettings.cboFlow.ItemIndex of
    0: MSComm1.FlowControl := fcNone;
    1: MSComm1.FlowControl := fcRTSCTS;
    2: MSComm1.FlowControl := fcXONXOFF;
  end;
end;

{ every key press in the bottom window gets sent to the serial component }
procedure TfrmMain.memOutKeyPress(Sender: TObject; var Key: Char);
begin
  MSComm1.Write(@Key,SizeOf(Key))
end;

{ make the form resize intelligently }
procedure TfrmMain.FormResize(Sender: TObject);
const
  offset = 4;
var
  tempht: Integer;
  tempwd: Integer;
begin
  tempht := Self.Height div 2 - 25;
  tempwd := Self.Width - 7;
  MemIn.SetBounds(offset, offset, tempWd - (offset * 2), tempHt - (offset * 2));
  MemOut.SetBounds(offset, tempht, tempWd - (offset * 2), tempHt - (offset * 2));
end;

{ show about dialog with control version number in x.xx format }
procedure TfrmMain.About1Click(Sender: TObject);
begin
  frmAbout.lblVersion.Caption := FloatToStrF(MSComm1.Version, ffFixed, 0, 2);
  frmAbout.ShowModal;
end;

{ attempt to open the port and sets window options appropriately }
procedure TfrmMain.OpenPort;
var
  temp: array [0..254] of char;
begin
  if (not MSComm1.Open) then begin
    Application.MessageBox(StrPCopy(temp, MSComm1.GetError), 'Cannot open comm port', mb_iconstop);
    ClosePort;
    end
  else begin
    memOut.Color := clWindow;
    memOut.Enabled := True;
    memOut.SetFocus;
    Open1.Enabled := False;
    Close1.Enabled := True;
    exit;
  end;
end;

{ close the port and set window options appropriately }
procedure TfrmMain.ClosePort;
begin
  MSComm1.Close;
  memOut.Clear;
  memOut.Color := clBtnFace;
  memOut.Enabled := False;
  Open1.Enabled := True;
  Close1.Enabled := False;
end;

procedure TfrmMain.Open1Click(Sender: TObject);
begin
  OpenPort;
end;

procedure TfrmMain.Close1Click(Sender: TObject);
begin
  ClosePort;
end;

procedure TfrmMain.Exit1Click(Sender: TObject);
begin
  Close;
end;

end.
