{This unit shows how to accomplish program to program communication
 through message passing. The trick is to create a custom message that
 only your apps can send and will respond to.

 To demonstrate, compile the project to an exe, then start 2 copies
 of the program. When the "Get Data" button is pressed, the other app will
 receive the message and send back a message which points to the data
 required. In this example the sender sends his specific window handle, so
 the responder can send the message only to him.

 I had a need to do this sort of thing for a project, but Delphi Tech pay
 for Support was no help, so this was a trial and error project}

unit Getdata1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

Const
    {These are User created message constants. Always specify wm_user + nn}
  RequestMsgID = wm_User+1000;
  ResponseMsgID = wm_User+1001;

type
   {This is a Custom message created in the format of TMessage}
  TCustomMsg = Record
    Msg    : Cardinal;
    Sender : Word;
    Data   : Longint;
    Result : Longint;
  end;

     {Test Record - pointer will be passed with the message routine}
  TDataRec = Class
    EffDate     : TdateTime;
    ExpDate     : TDateTime;
    BadgeNumber : Integer;
    UserID      : String;
  End;

  TForm1 = class(TForm)
    Edit1: TEdit;
    Button1: TButton;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit8: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    Procedure RespondToRequest(Var Msg:TCustomMsg);Message RequestMsgID;
    Procedure SendData(HWindow:Hwnd);
    Procedure ReceiveData(Var Msg:TCustomMsg);Message ResponseMsgID;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
Var DataRec:TDataRec;
{$R *.DFM}

Procedure TForm1.SendData(HWindow:Hwnd);
Begin
  With DataRec do
  Begin
    EffDate := StrToDate(Edit1.Text);
    ExpDate := StrToDate(Edit2.Text);
    BadgeNumber := StrToInt(Edit3.Text);
    UserID := Edit4.Text;
  End;
  SendMessage(HWindow,ResponseMsgID,Handle,LongInt(DataRec));
End;

Procedure TForm1.RespondToRequest(Var Msg:TCustomMsg);
Begin
  {Request message is received here, the sender field is the handle of
   The requester}
  SendData(Msg.Sender);
End;

procedure TForm1.Button1Click(Sender: TObject);
Var s:String;
begin
   {if you know the handle of the window to request data from, use that,
    as hwnd_BroadCast will not return a result. In this case the requester
    handle is send as the sender field of the TCustomMsg}
  SendMessage(hwnd_Broadcast,RequestMsgID,Handle,0);
end;

Procedure TForm1.ReceiveData(Var Msg:TCustomMsg);
Begin
   {The LParam of the received message should point to the data record}
  MessageBeep(0);
  Label2.Caption := 'Message Received at '+TimeToStr(Time)+ ' by Window #'+IntToStr(Msg.Sender);
  Try
    Edit5.Text := DateToStr(TDataRec(msg.Data).EffDate);;
    Edit6.Text := DateToStr(TDataRec(msg.Data).ExpDate);
    Edit7.Text := IntToStr(TDataRec(msg.Data).BadgeNumber);
    Edit8.Text := TDataRec(msg.Data).UserID;
  Except on E : EConvertError do
    ShowMessage(E.Message);
  End;
End;

procedure TForm1.FormCreate(Sender: TObject);
begin
   {Create the object}
  DataRec := TDataRec.Create;
    {PreSet the edit boxes}
  Edit1.Text := DateToStr(Date);
  Edit2.Text := DateToStr(Date+360);
  Edit3.Text := '100';
  Edit4.Text := IntToStr(Handle);
  Form1.Caption := 'Window #'+IntToStr(Handle);
  end;

end.
