{ Example Test bed app to work out methods of creating context sensitive popup
  menus.
  Author : Thomas Hill
  Started: August 12, 1995
  Revision History: Working version August 15, 1995 (TNH)
                    Added event handlers for various thingies 12/1/95 (TNH)

}
unit Pop01;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Grids, Outline, Menus;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    CheckBox1: TCheckBox;
    ListBox1: TListBox;
    Outline1: TOutline;
    Button1: TButton;
    Button2: TButton;
    ColorDialog1: TColorDialog;
    procedure ListBox1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button2Click(Sender: TObject);
  private
    DynPopUp : TPopUpMenu;
    procedure MakeAMenu(Sender : TObject; P : TPoint);
    procedure GetAColor(Sender : TObject);
    procedure DefaultClicker(Sender : TObject);
    procedure CBoxClick(Sender : TObject);
    procedure CBoxAccess(Sender : TObject);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{
Aug 30: Doug - This is a tedious way to do it at best.  Maybe we should look into some
mix of resource embedded data and code here.  still, the time spent accessing the
.EXE to find the resource may have an impact over the network, eh?

Sept 22 : I think I will change the code to use the Tag property for determining
which menu items to attach. That is, I think, a cleaner and better way to do it.
}

procedure TForm1.MakeAMenu(Sender : TObject; P : TPoint);

var
   MItem : TMenuItem;
   ndx : integer;

begin
  DynPopUp := TPopUpMenu.Create(Self);
  MItem := TMenuItem.Create(DynPopUp);
  MItem.Caption := '&Color...';
  MItem.OnClick := GetAColor;
  DynPopUp.Items.Add(MItem);
  MItem := TMenuItem.Create(DynPopUp);
  MItem.Caption := '&Font...';
  DynPopUp.Items.Add(MItem);
  if (Sender as TWinControl).Name = 'CheckBox1' then
  begin
    MItem := TMenuItem.Create(DynPopUp);
    MItem.Caption := '-';
    DynPopUp.Items.Add(MItem);
    MItem := TMenuItem.Create(DynPopUp);
    MItem.Caption := 'Chec&k it';
    MItem.OnClick := CBoxClick;
    DynPopUp.Items.Add(MItem);
    MItem := TMenuItem.Create(DynPopUp);
    MItem.Caption := 'Clea&r it';
    MItem.OnClick := CBoxClick;
    DynPopUp.Items.Add(MItem);
    MItem := TMenuItem.Create(DynPopUp);
    MItem.Caption := '&Disable It';
    MItem.OnClick := CBoxAccess;
    DynPopUp.Items.Add(MItem);
  end;
  if (Sender as TWinControl).Name = 'ListBox1' then
  begin
    MItem := TMenuItem.Create(DynPopUp);
    MItem.Caption := '-';
    DynPopUp.Items.Add(MItem);
    MItem := TMenuItem.Create(DynPopUp);
    MItem.Caption := 'List &Box Stuff';
    MItem.OnClick := DefaultClicker;
    DynPopUp.Items.Add(MItem);
    case (Sender as TListBox).ItemIndex of
      1 : begin
            MItem := TMenuItem.Create(DynPopUp);
            MItem.Caption := 'Item &2 Specific';
            MItem.OnClick := DefaultClicker;
            DynPopUp.Items.Add(MItem);
          end;
      2 : begin
            MItem := TMenuItem.Create(DynPopUp);
            MItem.Caption := 'Item 3 part 1';
            MItem.OnClick := DefaultClicker;
            DynPopUp.Items.Add(MItem);
            MItem := TMenuItem.Create(DynPopUp);
            MItem.Caption := 'Item 3 part 2';
            MItem.OnClick := DefaultClicker;
            DynPopUp.Items.Add(MItem);
          end;
    end; { CASE }
  end;
  if (Sender as TWinControl).Name = 'Outline1' then
  begin
    MItem := TMenuItem.Create(DynPopUp);
    MItem.Caption := '-';
    DynPopUp.Items.Add(MItem);
    MItem := TMenuItem.Create(DynPopUp);
    MItem.Caption := '&Delete';
    MItem.OnClick := DefaultClicker;
    DynPopUp.Items.Add(MItem);
    MItem := TMenuItem.Create(DynPopUp);
    MItem.Caption := '&Edit';
    MItem.OnClick := DefaultClicker;
    DynPopUp.Items.Add(MItem);
    ndx := (Sender as TOutline).SelectedItem;
    MItem := TMenuItem.Create(DynPopUp);
    MItem.Caption := '-';
    DynPopUp.Items.Add(MItem);
    case (Sender as TOutline)[ndx].Level of
      1 : begin
            MItem := TMenuItem.Create(DynPopUp);
            MItem.Caption := 'Do Parent Stuff';
            MItem.OnClick := DefaultClicker;
            DynPopUp.Items.Add(MItem);
            MItem := TMenuItem.Create(DynPopUp);
            MItem.Caption := 'More Parent Stuff';
            DynPopUp.Items.Add(MItem);
          end;
      2 : begin
            MItem := TMenuItem.Create(DynPopUp);
            MItem.Caption := 'Child Stuff';
            MItem.OnClick := DefaultClicker;
            DynPopUp.Items.Add(MItem);
          end;
      3 : begin
            MItem := TMenuItem.Create(DynPopUp);
            MItem.Caption := 'GrandKid Stuff';
            DynPopUp.Items.Add(MItem);
            MItem := TMenuItem.Create(DynPopUp);
            MItem.Caption := 'More Grandkids';
            DynPopUp.Items.Add(MItem);
          end;
    end; { CASE }
  end;
  DynPopup.Popup(P.X,P.Y);
end;


{$R *.DFM}

procedure TForm1.ListBox1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);

var
   P1 : TPoint;

begin
  if Button = mbRight then
  begin
    P1.X := X; P1.Y := Y;
    P1 := ClientToScreen(P1);
    MakeAMenu(Sender,P1);
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.GetAColor(Sender : TObject);

begin
  if ColorDialog1.Execute then
  begin
    if (ActiveControl is TEdit) then
      (ActiveControl as TEdit).Font.Color := ColorDialog1.Color;
    if (ActiveControl is TListBox) then
      (ActiveControl as TListBox).Color := ColorDialog1.Color;
  end;
end;

procedure TForm1.DefaultClicker(Sender : TObject);

begin
{ Using ActiveControl is not totally correct.  The Active control is the one with
  keyboard focus, and right clicking a control WITHOUT moving the focus leaves the
  active control behind.  Need some other method here.
}
  if (ActiveControl is TListBox) then
    ShowMessage('Listbox action take place here.')
  else
  if (ActiveControl is TOutline) then
    ShowMessage('Outline actions take place here.')
  else
    ShowMessage('Default action take place here.');
end;

procedure TForm1.CBoxClick(Sender : TObject);

begin
  CheckBox1.Checked := not CheckBox1.Checked;
end;

{ Hey, we got a problem with this one!  If you disable a control, you cannot
  access the right button popup menu!
}
procedure TForm1.CBoxAccess(Sender : TObject);

begin
  CheckBox1.Enabled := not CheckBox1.Enabled;
end;

end.
