LIBRARY PropExp;
{
   Property Expert Version 1.0 (C)1995 Sutron Corporation, (703)406-2800, August 2, 1995
   Written by: Jonathan D. Weisberg, CIS:74710,1675
   Language  : Delphi for Windows version 1.0

   Sutron develops mission critical Windows programs for environmental real-time data
   collection which multi-task and run for extended periods. We also offer a complete
   line of data recorders, sensors, and RTUs for control applications. Call and ask
   for a sales person or a catalog if you are interested.

   You may make changes to this source code and executable as long as you do not delete
   or change the information in this header or remove the (C)1995 Sutron Corp from the
   property form. If you re-distribute a changed version, please comment any changes
   you make in the area reserved below...

   The executable may be freely distributed, executed, and copied.

   This software is made available to the public "as-is" without warranty of any kind.

   PropExp.DLL uses the version control installable dll feature of delphi,
   to implement new menu features which help with the creation
   of component properties. This removes a lot of the tedium from adding
   new properties to a control.

   Before you can use the property expert you need to add it as a version control
   manager. If you already have a version control manager perhaps you can add PropExp
   as second one ... although I am not sure. To add it you need to edit the
   C:\WINDOWS\DELPHI.INI file and add the following section:

   [Version Control]
   VCSManager=C:\wherever\PROPEXP.DLL

   The next time you run Delphi, an Extension menu will be added. Use Set Properties...
   to tell PropExp what kind of property you are trying to make. Arrow around in your
   source file to the appropriate section and then select Paste Published, Private,
   Protected, and Methods to add the stub code for your property to the component.

   PropExp is really just a first shot at using Delphi's version control interface
   to customize the IDE. There may be other ways ... but this was the one that was
   somewhat documented. At the very least PropExp should encourage others to explore
   this interface and add their own customizations.
}
{
   Change history:

}

USES
  Messages,
  WinProcs,
  WinTypes,
  Strings,
  Clipbrd,
  Forms,
  VcsIntf in '\DELPHI\SOURCE\VCL\VCSINTF.PAS',
  ToolIntf in '\DELPHI\SOURCE\VCL\TOOLINTF.PAS',
  VirtIntf in '\DELPHI\SOURCE\VCL\VIRTINTF.PAS',
  Propform in 'PROPFORM.PAS' {PropExpert};

Type
  TIClient = class(TIVCSClient)
    Function GetIDString: string;                     override;
    Procedure ExecuteVerb(Index: Integer);            override;
    Function GetMenuName: string;                     override;
    Function GetVerb(Index: Integer): string;         override;
    Function GetVerbCount: Integer;                   override;
    Function GetVerbState(Index: Integer): Word;      override;
    Procedure ProjectChange;                          override;
  end;

Var
   VCS : TIToolServices;
   Client : TIClient;

Function GetEditControl : HWnd;
Var
   Wnd : HWND;
   Name : Array[0..32] Of Char;
Begin
   Wnd := GetWindow(FindWindow('TEditWindow', Nil), GW_CHILD);
   While Wnd <> 0 Do
      Begin
         GetClassName(Wnd, Name, 32);
         If StrComp(Name, 'TEditControl') = 0 Then
            Begin
               GetEditControl := Wnd;
               Exit;
            End;
         Wnd := GetWindow(Wnd, GW_HWNDNEXT);
      End;
   GetEditControl := 0;
End;

Function TVCSManagerInitProc(VCSInterface: TIToolServices): TIVCSClient; Export;
Begin
   VCS := VCSInterface;
   Client := TIClient.Create;
   TVCSManagerInitProc := Client;
End;

Function TIClient.GetIDString: string;
Begin
   GetIDString := 'Sutron.Extensions';
End;

Var p : Array[0..2048] Of Char;

Procedure Cat(Const s : String);
Begin
   StrPCopy(p+StrLen(p), s);
End;

Procedure TIClient.ExecuteVerb(Index: Integer);
Begin
   p[0] := #0;
   Case Index Of
      0 : { Set Properties... }
         PropExpert.ShowModal;
      1 : { Paste Published }
         With PropExpert Do
         Begin
            Cat('   Property ' + PropertyName.Text);
            If ArrayIndex.Text <> '' Then
               Cat('[' + ArrayIndex.Text + ']');
            Cat(' : ' + DataType.Text);
            If Index.Text <> '' Then
               Cat(' Index ' + Index.Text);
            If ReadMethod.Checked Then
               Cat(' Read Get' + PropertyName.Text)
            Else
               Cat(' Read F' + PropertyName.Text);
            If WriteMethod.Checked Then
               Cat(' Write Set' + PropertyName.Text)
            Else
               Cat(' Write F' + PropertyName.Text);
            If Default.Text <> '' Then
               Cat(' Default ' + Default.Text);
            Cat(';' + ^M^J);
         End;
      2 : { Paste Private }
         With PropExpert Do
         Begin
            Cat('   F' + PropertyName.Text + ' : ' + DataType.Text + ';'^M^J);
         End;
      3 : { Paste Protected }
         With PropExpert Do
         Begin
            If ReadMethod.Checked Then
               Begin
                  Cat('   Function Get' + PropertyName.Text);
                  If Index.Text <> '' Then
                     Cat('(Index : Integer)');
                  If ArrayIndex.Text <> '' Then
                     Cat('(' + ArrayIndex.Text + ')');
                  Cat(' : ' + DataType.Text + ';' + ^M^J);
               End;
            If WriteMethod.Checked Then
               Begin
                  Cat('   Procedure Set' + PropertyName.Text + '(');
                  If Index.Text <> '' Then
                     Cat('Index : Integer; ');
                  If ArrayIndex.Text <> '' Then
                     Cat(ArrayIndex.Text + '; ');
                  Cat('A' + PropertyName.Text + ' : ' + DataType.Text + ');' + ^M^J);
               End;
         End;
      4 : { Paste Method(s) }
         With PropExpert Do
         Begin
            If ReadMethod.Checked Then
               Begin
                  Cat(^M^J'Function ' + ClassName.Text + '.Get' + PropertyName.Text);
                  If Index.Text <> '' Then
                     Cat('(Index : Integer)');
                  If ArrayIndex.Text <> '' Then
                     Cat('(' + ArrayIndex.Text + ')');
                  Cat(' : ' + DataType.Text + ';' + ^M^J);
                  Cat('Begin'^M^J'   Get' + PropertyName.Text + ' := F'
                     + PropertyName.Text + ';'^M^J'End;'^M^J);
               End;
            If WriteMethod.Checked Then
               Begin
                  Cat(^M^J'Procedure ' + ClassName.Text + '.Set' + PropertyName.Text + '(');
                  If Index.Text <> '' Then
                     Cat('Index : Integer; ');
                  If ArrayIndex.Text <> '' Then
                     Cat(ArrayIndex.Text + '; ');
                  Cat('A' + PropertyName.Text + ' : ' + DataType.Text + ');' + ^M^J);
                  Cat('Begin'^M^J'   If A' + PropertyName.Text + ' <> F'
                     + PropertyName.Text + ' Then'^M^J'      Begin'^M^J);
                  Cat('         F' + PropertyName.Text + ' := A'
                     + PropertyName.Text + ';'^M^J'      End;'^M^J'End;'^M^J);
               End;
         End;
   Else
   End;
   If p[0] <> #0 Then
      Begin
          Clipboard.SetTextBuf(p);
          SendMessage(GetEditControl, WM_PASTE, 0, 0);
      End;
End;

Function TIClient.GetMenuName: string;
Begin
   GetMenuName := 'E&xtensions';
End;

Function TIClient.GetVerb(Index: Integer): string;
Begin
   Case Index Of
      0 : GetVerb := 'Set Properties...';
      1 : GetVerb := 'Paste Published';
      2 : GetVerb := 'Paste Private';
      3 : GetVerb := 'Paste Protected';
      4 : GetVerb := 'Paste Method(s)';
   Else
      GetVerb := 'Unknown';
   End;
End;

Function TIClient.GetVerbCount: Integer;
Begin
   GetVerbCount := 5;
End;

Function TIClient.GetVerbState(Index: Integer): Word;
Begin
   GetVerbState := vsEnabled;
End;

Procedure TIClient.ProjectChange;
Begin
End;


EXPORTS
  TVCSManagerInitProc Index 1 Name VCSManagerEntryPoint;

BEGIN
   PropExpert := TPropExpert.Create(Application);
END.

