unit Bitmap;

interface
Uses
  StdCtrls, WinTypes, Graphics, IniFiles;

Var
  zx, zy       : Integer;                            { pic Width and Height }
  cx, cy       : Integer;                            { pic Pos }
  vx, vy, w, h : integer;                            { Accel amd Width }
  Pic, PicMask : TBitmap;                            { Bitmap }
  FirstPass    : Boolean;

Procedure MovePic;                                         { Move the Message }
Procedure InitPicture;                                     { Startup }
Procedure FreePic;                                         { Free any resources }
Procedure ReadPicDefaults;                                 { Read any defaults }

implementation
Uses
  Globals,
  Ssave;

{ Import routines from Sprite DLL.  }
function makemask(Image: HBitmap): HBitmap;
  far; external 'SPRITE';
procedure initialize(ImageMask: HBitmap; Image: HBitmap);
  far; external 'SPRITE';
procedure start(TheWindow: HDC; x: Integer; y: Integer);
  far; external 'SPRITE';
procedure moveto(TheWindow: HDC; x: Integer; y: Integer);
  far; external 'SPRITE';
procedure hide(TheWindow: HDC);
  far; external 'SPRITE';
procedure redraw(TheWindow: HDC);
  far; external 'SPRITE';
procedure getcoord(PicRect: TRect);
  far; external 'SPRITE';

Procedure ReadPicDefaults;                                 { Read Defaults }
Var
  Ini   : TiniFile;
  Fnt   : Integer;                                         { Font }
  Style : TFontStyles;                                     { Font Styles }
Begin
  Ini := TIniFile.Create('WOW.INI');                   { Open the Ini File }
  Apptitle := 'Bitmap';                                { Set title }


  BitmapFile := Ini.ReadString(Apptitle,
                            'Bitmap File Location',
                            #0); { bitmap filename }
  Speed := Ini.ReadInteger(Apptitle,
                           'Speed',25);                    { Get the Speed }


  Pwd := Ini.ReadString('Apptitle',
                        'Password',
                        '');                               { Read the Password, if any }
  Ini.Free;
end;

procedure InitPicture;
begin
  ReadPicDefaults;                                      { Read the Default Settings }
  FirstPass := True;
  Pic := TBitmap.Create;                                { Create the Bitmap }
  Pic.LoadFromFile(BitmapFile);
  PicMask := TBitmap.Create;
  PicMask.Assign(Pic);
  zx := ScreenWd;                                       { get Width }
  zy := ScreenHt;                                       { Get Height }
  w := Pic.Width;
  h := Pic.Height;
  {  randomize;                                            { Ramdom init }
  {  cx := random (zx div 2) + 1;                          { get starting x }
  {  cy := random (zy div 2) + 1;    }                      { get starting y }

  { temporary start postition until I fix graphics problem }
  cx := 300;
  cy := 0;

  vx := -1 + 2 * random (2);                            { get speed: }
  vy := -1 + 2 * random (2);                            { vx, vy = 1 or -1 }

  initialize(PicMask.Handle, Pic.Handle);
{  start(Scrn.Canvas.Handle, cx, cy); }
end;

Procedure FreePic;
Begin
  Pic.Free;                                             { Free the Bitmap }
  PicMask.Free;
end;

Procedure MovePic;
Begin
  if ((cx <= 0) or (cx+w >= zx)) then vx := -vx;           { bounce light at X edges }
  if ((cy <= 0) or (cy+h >= zy)) then vy := -vy;           { bounce light at Y edges }
  cx := cx+vx;                                             { calculate new X position }
  cy := cy+vy;                                             { calculate new Y position }
  moveto(Scrn.Canvas.Handle, cx, cy);

  { temporary fix until I fix graphics problem }
  if FirstPass then
  begin
    Scrn.Canvas.Brush.Color := clBlack;
    Scrn.Canvas.Rectangle(0, 0, zx, zy);
  end;

  FirstPass := False;
  Delay(Speed);                                            { Delay a Bit }

end;

end.
