/////////////////////////////////////////////////////////////////
//                                                             //
// CLSPRITE.H: Header file for the ClSprite class.             //
//                                                             //
/////////////////////////////////////////////////////////////////

#define STRICT
#include <windows.h>

class ClSprite
{
   int mHeight;
   HBITMAP mHBMImage;
   HBITMAP mHBMMask;
   HBITMAP mHBMSave;
   int mWidth;
   int mX;
   int mY;

public:
   ClSprite ();
   ClSprite (const ClSprite &OtherSprite);
   ~ClSprite ();
   
   ClSprite & operator= (const ClSprite &OtherSprite);
   
   void GetCoord (RECT *Rect);
   BOOL Hide (HDC HDc);
   BOOL Initialize (HBITMAP HBMMask, HBITMAP HBMImage);         
   HBITMAP static MakeMask (HBITMAP HBMImage);
   BOOL MoveTo (HDC HDc, int X, int Y);
   BOOL Redraw (HDC HDc);
   BOOL Start (HDC HDc, int X, int Y);
};
