unit Newpass;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, Dialogs, IniFiles;

type
  TChPwd = class(TForm)
    Label1: TLabel;
    OldPwd: TEdit;
    Label2: TLabel;
    NewPwd: TEdit;
    Label3: TLabel;
    Rpwd: TEdit;
    Ok: TBitBtn;
    Cancel: TBitBtn;
    procedure OldPwdChange(Sender: TObject);
    procedure OkClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    Loading : Boolean;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ChPwd: TChPwd;

implementation

{$R *.DFM}

Uses WinPwd, Globals;

procedure TChPwd.OldPwdChange(Sender: TObject);            { Old is changing }
begin
  if Not NewPwd.Enabled then begin                         { If New is NOT enabled }
    NewPwd.Enabled := True;                                { Enable New Password }
    Rpwd.Enabled := True;                                  { Enable Retypr }
    end;
end;

procedure TChPwd.OkClick(Sender: TObject);                 { Ok }
Var
  Op,Np,Rp : String;                                       { Local Vars }
  Ini : TiniFile;                                          { For Wow.Ini }
begin
  if NewPwd.Enabled then Begin                             { If New is enabled }
    Op := OldPwd.Text;                                     { Get the Old Password }
    EncryptString(Op);                                     { Encrypt it }
    if Op <> Pwd then begin                                { Check against Current Password }
      MessageDlg('Old password is not correct',
                 mtError,[mbOk],0);                        { Not the same }
      exit;                                                { Try again }
      end;
    end;

  Np := NewPwd.Text;                                       { Get the New Password }
  Rp := Rpwd.Text;                                         { Get the Retyped Password }
  if Np <> Rp then begin                                   { If Not Same }
    MessageDlg('New and retyped password are not the same',
               mtError,[mbOk],0);                          { Err Message }
    exit;                                                  { Bye Bye }
    end;
  EncryptString(Np);                                       { Encrypt the Password }
  Ini := TIniFile.Create('Wow.Ini');                   { Open Wow.Ini }
  Ini.WriteString('ScreenSaver','Password',Np);            { Save the Password }
  Ini.Free;                                                { Close INI and Free }
  Close;                                                   { Bye Bye }
end;

procedure TChPwd.FormCreate(Sender: TObject);
begin
  Loading := True;                                         { Set Loading Flag }
end;

procedure TChPwd.FormActivate(Sender: TObject);
begin
  if Loading then begin                                    { If Loading }
    Loading := False;                                      { Reset Flag }
    if OldPwd.Enabled then                                 { If Old is enabled }
      OldPwd.SetFocus                                      { Set focus }
    else
      NewPwd.SetFocus;                                     { Else set focus to New }
    end;
end;

end.
