unit Picdlg;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, Dialogs;

type
  TBitmapDlg = class(TForm)
    OKBtn: TBitBtn;
    Bevel1: TBevel;
    OpenDialog: TOpenDialog;
    EditFile: TEdit;
    FileBtn: TSpeedButton;
    PrevBtn: TSpeedButton;
    Panel1: TPanel;
    Image: TImage;
    Memo1: TMemo;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Spd: TScrollBar;
    procedure FileBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure PrevBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure SpdChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  BitmapDlg: TBitmapDlg;

implementation

uses Globals, IniFiles;
{$R *.DFM}

procedure TBitmapDlg.FileBtnClick(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin
    EditFile.Text := OpenDialog.Filename;
    BitmapFile    := EditFile.Text;
  end;
end;

procedure TBitmapDlg.OKBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TBitmapDlg.PrevBtnClick(Sender: TObject);
begin
  Image.Picture.LoadFromFile(BitmapFile);
end;

procedure TBitmapDlg.FormActivate(Sender: TObject);
var
  Ini   : TiniFile;
begin
  Ini := TIniFile.Create('Wow.Ini');                   { Open the Ini File }
  Apptitle := 'Bitmap';
  EditFile.Text := Ini.ReadString(Apptitle, 'Bitmap File Location', #0); { bitmap filename }
  BitmapFile := EditFile.Text;
  Spd.Position := Ini.ReadInteger(Apptitle, 'Speed', 25); { bitmap speed }
  Ini.Free;
end;

procedure TBitmapDlg.SpdChange(Sender: TObject);
begin
  SetFocus;
end;

procedure TBitmapDlg.FormClose(Sender: TObject; var Action: TCloseAction);
var
  Ini   : TiniFile;
begin
  Ini := TIniFile.Create('Wow.Ini');                   { Open the Ini File }
  Apptitle := 'Bitmap';                                { Set title }
  Ini.WriteString(Apptitle, 'Bitmap File Location', BitmapFile); { bitmap filename }
  Ini.WriteInteger(Apptitle,'Speed',Spd.Position);         { Write the Speed }
  Ini.Free;
end;

end.
